/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.system.OS;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@IntellijInternalApi
@ApiStatus.Internal
public final class JetBrainsPermanentInstallationID {
    private static final String INSTALLATION_ID_KEY = "user_id_on_machine";
    private static final String INSTALLATION_ID = JetBrainsPermanentInstallationID.calculateInstallationId();

    @NotNull
    public static String get() {
        String string = INSTALLATION_ID;
        if (string == null) {
            JetBrainsPermanentInstallationID.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String calculateInstallationId() {
        String installationId;
        block5: {
            installationId = "";
            try {
                ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
                String companyName = appInfo.getShortCompanyName();
                String nodeName = companyName == null || companyName.isBlank() ? "jetbrains" : companyName.toLowerCase(Locale.ROOT);
                Preferences preferences = Preferences.userRoot().node(nodeName);
                installationId = preferences.get(INSTALLATION_ID_KEY, "");
                if (!JetBrainsPermanentInstallationID.isValid(installationId)) {
                    installationId = UUID.randomUUID().toString();
                    preferences.put(INSTALLATION_ID_KEY, installationId);
                }
                if (!appInfo.isVendorJetBrains()) {
                    return installationId;
                }
                if (OS.CURRENT == OS.Windows) {
                    installationId = JetBrainsPermanentInstallationID.syncWithSharedFile(installationId, preferences);
                }
            }
            catch (Throwable t) {
                Logger.getInstance(JetBrainsPermanentInstallationID.class).info("Unexpected error initializing Installation ID", t);
                if (JetBrainsPermanentInstallationID.isValid(installationId)) break block5;
                installationId = UUID.randomUUID().toString();
            }
        }
        return installationId;
    }

    private static String syncWithSharedFile(String installationId, Preferences preferences) {
        String appdata = System.getenv("APPDATA");
        if (appdata != null) {
            try {
                Path permanentIdFile = Path.of(appdata, "JetBrains/PermanentUserId");
                try {
                    byte[] bytes = Files.readAllBytes(permanentIdFile);
                    int offset = CharsetToolkit.hasUTF8Bom((byte[])bytes) ? CharsetToolkit.UTF8_BOM.length : 0;
                    String fromFile = Strings.trimEnd((String)new String(bytes, offset, bytes.length - offset, StandardCharsets.UTF_8), (char)'\u0000');
                    if (!fromFile.equals(installationId) && JetBrainsPermanentInstallationID.isValid(fromFile)) {
                        preferences.put(INSTALLATION_ID_KEY, installationId);
                        return fromFile;
                    }
                }
                catch (IllegalArgumentException | NoSuchFileException exception) {
                    // empty catch block
                }
                Files.createDirectories(permanentIdFile.getParent(), new FileAttribute[0]);
                Files.writeString(permanentIdFile, (CharSequence)installationId, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return installationId;
    }

    private static boolean isValid(String id2) {
        try {
            UUID.fromString(id2);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/JetBrainsPermanentInstallationID", "get"));
    }
}

