/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ThreadContext;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationActivationStateManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.ShutdownKt;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.idea.AppMode;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.InstantShutdown;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadActionListener;
import com.intellij.openapi.application.RuntimeFlagsKt;
import com.intellij.openapi.application.ThreadingRuntimeFlagsKt;
import com.intellij.openapi.application.ThreadingSupport;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.WriteActionListener;
import com.intellij.openapi.application.WriteIntentReadActionListener;
import com.intellij.openapi.application.WriteLockReacquisitionListener;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.application.impl.AnyModalityState;
import com.intellij.openapi.application.impl.AppImplKt;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.InternalThreading;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.application.impl.OTelReadWriteActionsMonitor;
import com.intellij.openapi.application.impl.ReadActionCacheImpl;
import com.intellij.openapi.application.impl.WriteActionPresenceService;
import com.intellij.openapi.client.ClientAwareComponentManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressResult;
import com.intellij.openapi.progress.impl.ProgressRunner;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SuvorovProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.platform.locking.impl.IntelliJLockingUtil;
import com.intellij.platform.locking.impl.NestedLocksThreadingSupport;
import com.intellij.platform.locking.impl.listeners.ErrorHandler;
import com.intellij.platform.locking.impl.listeners.LegacyProgressIndicatorProvider;
import com.intellij.platform.locking.impl.listeners.LockAcquisitionListener;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.psi.util.ReadActionCache;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.Propagation;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Scope;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.EventListener;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class ApplicationImpl
extends ClientAwareComponentManager
implements ApplicationEx {
    private final EventDispatcher<ApplicationListener> myDispatcher;
    private final WriteActionListener appListenerDispatcherWrapper;
    private final ReadActionListener customReadActionListener;
    private static final ErrorHandler lockingErrorHandler = error -> ApplicationImpl.getLogger().error(error);
    private final boolean myTestModeFlag;
    private final boolean myHeadlessMode;
    private final boolean myCommandLineMode;
    private final boolean myIsInternal;
    private final TransactionGuardImpl myTransactionGuard;
    private final NestedLocksThreadingSupport lock;
    private final ReadActionCacheImpl myReadActionCacheImpl;
    private final ThreadLocal<Boolean> myImpatientReader;
    private final long myStartTime;
    private boolean mySaveAllowed;
    private volatile boolean myExitInProgress;
    @Nullable
    private final Disposable myLastDisposable;
    private static final String WAS_EVER_SHOWN = "was.ever.shown";
    private static final LegacyProgressIndicatorProvider myLegacyIndicatorProvider = () -> {
        ProgressIndicator indicator2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        return indicator2 == null ? null : () -> {
            if (indicator2.isCanceled()) {
                throw new ProcessCanceledException();
            }
        };
    };
    private final Supplier<OTelReadWriteActionsMonitor> otelMonitor;
    private final SynchronizedClearableLazy<IComponentStore> componentStoreValue;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ApplicationImpl.class);
        if (logger == null) {
            ApplicationImpl.$$$reportNull$$$0(0);
        }
        return logger;
    }

    @TestOnly
    public ApplicationImpl(@NotNull CoroutineContext testCoroutineContext, boolean isHeadless) {
        if (testCoroutineContext == null) {
            ApplicationImpl.$$$reportNull$$$0(1);
        }
        super(CoroutineScopeKt.childScope((CoroutineScope)GlobalScope.INSTANCE, (String)"Test Application Scope", (CoroutineContext)testCoroutineContext, (boolean)true));
        this.myDispatcher = EventDispatcher.create(ApplicationListener.class);
        this.appListenerDispatcherWrapper = new WriteActionListener(){

            public void beforeWriteActionStart(@NotNull Class<?> action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ActivityTracker.getInstance().inc();
                ((ApplicationListener)ApplicationImpl.this.myDispatcher.getMulticaster()).beforeWriteActionStart(action2);
            }

            public void writeActionStarted(@NotNull Class<?> action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ((ApplicationListener)ApplicationImpl.this.myDispatcher.getMulticaster()).writeActionStarted(action2);
            }

            public void writeActionFinished(@NotNull Class<?> action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                ((ApplicationListener)ApplicationImpl.this.myDispatcher.getMulticaster()).writeActionFinished(action2);
            }

            public void afterWriteActionFinished(@NotNull Class<?> action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                ApplicationImpl.this.otelMonitor.get().writeActionExecuted();
                ((ApplicationListener)ApplicationImpl.this.myDispatcher.getMulticaster()).afterWriteActionFinished(action2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "action";
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeWriteActionStart";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "writeActionStarted";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "writeActionFinished";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterWriteActionFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.customReadActionListener = new ReadActionListener(){

            public void readActionFinished(@NotNull Class<?> action2) {
                if (action2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationImpl.this.myReadActionCacheImpl.clear();
                ApplicationImpl.this.otelMonitor.get().readActionExecuted();
            }

            public void fastPathAcquisitionFailed() {
                if (ApplicationImpl.this.myImpatientReader.get().booleanValue() && !Cancellation.isInNonCancelableSection()) {
                    throw ApplicationUtil.CannotRunReadActionException.create();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl$2", "readActionFinished"));
            }
        };
        this.myTransactionGuard = new TransactionGuardImpl();
        this.lock = IntelliJLockingUtil.getGlobalNestedLockingThreadingSupport();
        this.myReadActionCacheImpl = new ReadActionCacheImpl();
        this.myImpatientReader = ThreadLocal.withInitial(() -> false);
        this.myStartTime = System.currentTimeMillis();
        this.otelMonitor = new SynchronizedClearableLazy((Function0)new Function0<OTelReadWriteActionsMonitor>(this){

            public OTelReadWriteActionsMonitor invoke() {
                return new OTelReadWriteActionsMonitor(TelemetryManager.getInstance().getMeter(PlatformScopesKt.EDT));
            }
        });
        this.componentStoreValue = new SynchronizedClearableLazy(() -> (IComponentStore)this.getService(IComponentStore.class));
        Extensions.setRootArea((ExtensionsAreaImpl)this.getExtensionArea());
        ApplicationImpl.registerFakeServices(this);
        this.myIsInternal = true;
        this.myTestModeFlag = true;
        this.myHeadlessMode = isHeadless;
        this.myCommandLineMode = true;
        this.mySaveAllowed = false;
        ApplicationImpl.postInit(this);
        this.myLastDisposable = Disposer.newDisposable();
        ApplicationManager.setApplication((Application)this, (Disposable)this.myLastDisposable);
    }

    public ApplicationImpl(@NotNull CoroutineScope parentScope, boolean isInternal) {
        if (parentScope == null) {
            ApplicationImpl.$$$reportNull$$$0(2);
        }
        super(parentScope);
        this.myDispatcher = EventDispatcher.create(ApplicationListener.class);
        this.appListenerDispatcherWrapper = new /* invalid duplicate definition of identical inner class */;
        this.customReadActionListener = new /* invalid duplicate definition of identical inner class */;
        this.myTransactionGuard = new TransactionGuardImpl();
        this.lock = IntelliJLockingUtil.getGlobalNestedLockingThreadingSupport();
        this.myReadActionCacheImpl = new ReadActionCacheImpl();
        this.myImpatientReader = ThreadLocal.withInitial(() -> false);
        this.myStartTime = System.currentTimeMillis();
        this.otelMonitor = new SynchronizedClearableLazy((Function0)new /* invalid duplicate definition of identical inner class */);
        this.componentStoreValue = new SynchronizedClearableLazy(() -> (IComponentStore)this.getService(IComponentStore.class));
        Extensions.setRootArea((ExtensionsAreaImpl)this.getExtensionArea());
        ApplicationImpl.registerFakeServices(this);
        this.myIsInternal = isInternal;
        this.myTestModeFlag = false;
        this.myHeadlessMode = AppMode.isHeadless();
        this.myCommandLineMode = AppMode.isCommandLine();
        if (!this.myHeadlessMode || SystemProperties.getBooleanProperty((String)"allow.save.application.headless", (boolean)false)) {
            this.mySaveAllowed = true;
        }
        this.myLastDisposable = null;
    }

    @NotNull
    public IComponentStore getComponentStore() {
        IComponentStore iComponentStore = (IComponentStore)this.componentStoreValue.get();
        if (iComponentStore == null) {
            ApplicationImpl.$$$reportNull$$$0(3);
        }
        return iComponentStore;
    }

    @TestOnly
    public void componentStoreImplChanged() {
        this.componentStoreValue.drop();
    }

    private static void registerFakeServices(ApplicationImpl app) {
        app.registerServiceInstance(TransactionGuard.class, app.myTransactionGuard, (PluginDescriptor)fakeCorePluginDescriptor);
        app.registerServiceInstance(Application.class, (Object)app, (PluginDescriptor)fakeCorePluginDescriptor);
        app.registerServiceInstance(ReadActionCache.class, app.myReadActionCacheImpl, (PluginDescriptor)fakeCorePluginDescriptor);
    }

    @TestOnly
    @ApiStatus.Internal
    public ThreadingSupport getRwLock() {
        return this.getThreadingSupport();
    }

    public void executeByImpatientReader(@NotNull Runnable runnable2) throws ApplicationUtil.CannotRunReadActionException {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(4);
        }
        if (EDT.isCurrentThreadEdt()) {
            runnable2.run();
            return;
        }
        this.myImpatientReader.set(true);
        try {
            runnable2.run();
        }
        finally {
            this.myImpatientReader.set(false);
        }
    }

    public boolean isInImpatientReader() {
        return this.myImpatientReader.get();
    }

    @VisibleForTesting
    public void disposeContainer() {
        CoroutineContext coroutineContext = ThreadContext.currentThreadContext();
        try (AccessToken ignored = Cancellation.withNonCancelableSection();){
            ShutdownKt.cancelAndJoinBlocking(this, coroutineContext);
            this.runWriteAction(() -> {
                this.startDispose();
                Disposer.dispose((Disposable)this);
            });
            Disposer.assertIsEmpty();
        }
        catch (Throwable t) {
            ApplicationImpl.logErrorDuringExit("Failed to dispose the container", t);
        }
    }

    public boolean holdsReadLock() {
        return this.getThreadingSupport().isReadLockedByThisThread();
    }

    public boolean isInternal() {
        return this.myIsInternal;
    }

    public boolean isEAP() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public boolean isUnitTestMode() {
        return this.myTestModeFlag;
    }

    public boolean isHeadlessEnvironment() {
        return this.myHeadlessMode;
    }

    public boolean isCommandLine() {
        return this.myCommandLineMode;
    }

    public boolean isLightEditMode() {
        return AppMode.isLightEdit();
    }

    @NotNull
    public Future<?> executeOnPooledThread(final @NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(5);
        }
        final Runnable actionDecorated = ClientId.decorateRunnable((Runnable)action2);
        Future<?> future = AppExecutorUtil.getAppExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                if (ApplicationImpl.this.isDisposed()) {
                    return;
                }
                try {
                    actionDecorated.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    ApplicationImpl.getLogger().error(e);
                }
                finally {
                    Thread.interrupted();
                }
            }

            public String toString() {
                return action2.toString();
            }
        });
        if (future == null) {
            ApplicationImpl.$$$reportNull$$$0(6);
        }
        return future;
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(final @NotNull Callable<T> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(7);
        }
        final Callable actionDecorated = ClientId.decorateCallable(action2);
        Future future = AppExecutorUtil.getAppExecutorService().submit(new Callable<T>(){

            @Override
            public T call() {
                if (ApplicationImpl.this.isDisposed()) {
                    return null;
                }
                try {
                    Object v = actionDecorated.call();
                    return v;
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    ApplicationImpl.getLogger().error(e);
                }
                finally {
                    Thread.interrupted();
                }
                return null;
            }

            public String toString() {
                return action2.toString();
            }
        });
        if (future == null) {
            ApplicationImpl.$$$reportNull$$$0(8);
        }
        return future;
    }

    public boolean isDispatchThread() {
        return EDT.isCurrentThreadEdt();
    }

    public boolean isWriteIntentLockAcquired() {
        return this.getThreadingSupport().isWriteIntentLocked();
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(9);
        }
        this.invokeLater(runnable2, this.getDisposed());
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(10);
        }
        if (expired == null) {
            ApplicationImpl.$$$reportNull$$$0(11);
        }
        ModalityState state2 = this.getDefaultModalityState();
        if (RuntimeFlagsKt.getReportInvokeLaterWithoutModality() && state2 == ModalityState.any()) {
            ApplicationImpl.getLogger().error("Application.invokeLater() was called without modality state and default modality state is ANY\nCurrent thread context is: " + String.valueOf(ThreadContext.currentThreadContext()));
        }
        this.invokeLater(runnable2, state2, expired);
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state2) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(12);
        }
        if (state2 == null) {
            ApplicationImpl.$$$reportNull$$$0(13);
        }
        this.invokeLater(runnable2, state2, this.getDisposed());
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state2, @NotNull Condition<?> expired) {
        Runnable locked;
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(14);
        }
        if (state2 == null) {
            ApplicationImpl.$$$reportNull$$$0(15);
        }
        if (expired == null) {
            ApplicationImpl.$$$reportNull$$$0(16);
        }
        boolean ctxAware = Propagation.isContextAwareComputation((Object)runnable2);
        Runnable guarded = this.myTransactionGuard.wrapLaterInvocation(runnable2, state2);
        Runnable finalRunnable = locked = this.wrapWithRunIntendedWriteActionAndModality(guarded, true, ctxAware ? null : state2);
        if (AppExecutorUtil.propagateContext()) {
            Pair captured = Propagation.capturePropagationContext((Runnable)locked, expired, (Runnable)runnable2);
            finalRunnable = (Runnable)captured.getFirst();
            expired = (Condition)captured.getSecond();
        }
        LaterInvocator.invokeLater((ModalityState)state2, expired, (boolean)true, (Runnable)finalRunnable);
    }

    @ApiStatus.Internal
    public void dispatchCoroutineOnEDT(Runnable runnable2, ModalityState state2, boolean needsWriteIntent) {
        Runnable wrapped = this.myTransactionGuard.wrapCoroutineInvocation(runnable2, state2);
        LaterInvocator.invokeLater((ModalityState)state2, (Condition)Conditions.alwaysFalse(), (boolean)needsWriteIntent, (Runnable)wrapped);
    }

    public void dispose() {
        this.lock.removeErrorHandler();
        this.lock.removeLegacyIndicatorProvider(myLegacyIndicatorProvider);
        this.lock.removeWriteActionListener(this.appListenerDispatcherWrapper);
        this.lock.removeReadActionListener(this.customReadActionListener);
        ((ApplicationListener)this.myDispatcher.getMulticaster()).applicationExiting();
        IComponentStore componentStore = (IComponentStore)this.componentStoreValue.getValueIfInitialized();
        super.dispose();
        if (componentStore != null) {
            try {
                componentStore.release();
            }
            catch (Exception e) {
                ApplicationImpl.getLogger().error((Throwable)e);
            }
        }
        AppExecutorUtil.shutdownApplicationScheduledExecutorService();
        if (this.myLastDisposable == null) {
            ApplicationManager.setApplication(null);
        } else {
            Disposer.dispose((Disposable)this.myLastDisposable);
        }
        this.otelMonitor.get().close();
    }

    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle, boolean canBeCanceled, boolean shouldShowModalWindow, @Nullable Project project2, @Nullable JComponent parentComponent, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelText) {
        if (process2 == null) {
            ApplicationImpl.$$$reportNull$$$0(17);
        }
        if (progressTitle == null) {
            ApplicationImpl.$$$reportNull$$$0(18);
        }
        if (this.isDispatchThread() && this.isWriteAccessAllowed()) {
            ApplicationImpl.getLogger().debug("Starting process with progress from within write action makes no sense");
            try {
                ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)new EmptyProgressIndicator());
            }
            catch (ProcessCanceledException ignored) {
                return false;
            }
            return true;
        }
        CompletableFuture<ProgressWindow> progress = this.createProgressWindowAsyncIfNeeded(progressTitle, canBeCanceled, shouldShowModalWindow, project2, parentComponent, cancelText);
        ProgressRunner progressRunner = new ProgressRunner(process2).sync().onThread(ProgressRunner.ThreadToUse.POOLED).modal().withProgress(progress);
        progressRunner = !shouldShowModalWindow && this.isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode() ? progressRunner.fakeModal() : progressRunner;
        ProgressResult result2 = progressRunner.submitAndGet();
        Throwable exception = result2.getThrowable();
        if (!(exception instanceof ProcessCanceledException)) {
            ExceptionUtil.rethrowUnchecked((Throwable)exception);
        }
        return !result2.isCanceled();
    }

    public void invokeAndWaitRelaxed(@NotNull Runnable runnable2, @NotNull ModalityState state2) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(19);
        }
        if (state2 == null) {
            ApplicationImpl.$$$reportNull$$$0(20);
        }
        this.doInvokeAndWait(runnable2, state2, false);
    }

    public void invokeAndWait(@NotNull Runnable runnable2, @NotNull ModalityState state2) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(21);
        }
        if (state2 == null) {
            ApplicationImpl.$$$reportNull$$$0(22);
        }
        this.doInvokeAndWait(runnable2, state2, true);
    }

    public void doInvokeAndWait(@NotNull Runnable runnable2, @NotNull ModalityState state2, boolean wrapWithLocks) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(23);
        }
        if (state2 == null) {
            ApplicationImpl.$$$reportNull$$$0(24);
        }
        if (EDT.isCurrentThreadEdt()) {
            if (wrapWithLocks) {
                this.runIntendedWriteActionOnCurrentThread(runnable2);
            } else {
                runnable2.run();
            }
            return;
        }
        if (this.holdsReadLock()) {
            throw new IllegalStateException("Calling invokeAndWait from read-action leads to possible deadlock.");
        }
        boolean ctxAware = Propagation.isContextAwareComputation((Object)runnable2);
        Runnable guarded = this.myTransactionGuard.wrapLaterInvocation(runnable2, state2);
        boolean wrapWithLocksDeep = wrapWithLocks && !ThreadingRuntimeFlagsKt.getUseNonBlockingFlushQueue();
        Runnable locked = this.wrapWithRunIntendedWriteActionAndModality(guarded, wrapWithLocksDeep, ctxAware ? null : state2);
        Runnable finalRunnable = AppImplKt.rethrowExceptions((Function1<? super Runnable, ? extends Runnable>)((Function1)AppScheduledExecutorService::captureContextCancellationForRunnableThatDoesNotOutliveContextScope), locked);
        LaterInvocator.invokeAndWait((ModalityState)state2, (boolean)wrapWithLocks, (Runnable)finalRunnable);
    }

    @NotNull
    private Runnable wrapWithRunIntendedWriteActionAndModality(final @NotNull Runnable runnable2, final boolean wrapWithLocks, final @Nullable ModalityState modalityState) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(25);
        }
        if (modalityState == null && wrapWithLocks) {
            return new Runnable(){

                @Override
                public void run() {
                    ApplicationImpl.this.runIntendedWriteActionOnCurrentThread(runnable2);
                }

                public String toString() {
                    return runnable2.toString();
                }
            };
        }
        if (modalityState == null) {
            Runnable runnable3 = runnable2;
            if (runnable3 == null) {
                ApplicationImpl.$$$reportNull$$$0(26);
            }
            return runnable3;
        }
        return new Runnable(){

            @Override
            public void run() {
                ThreadContext.installThreadContext((CoroutineContext)ThreadContext.currentThreadContext().plus(ModalityKt.asContextElement((ModalityState)modalityState)), (boolean)true, () -> {
                    if (wrapWithLocks) {
                        ApplicationImpl.this.runIntendedWriteActionOnCurrentThread(runnable2);
                    } else {
                        runnable2.run();
                    }
                    return Unit.INSTANCE;
                });
            }

            public String toString() {
                return runnable2.toString();
            }
        };
    }

    public void invokeAndWait(@NotNull Runnable runnable2) throws ProcessCanceledException {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(27);
        }
        this.invokeAndWait(runnable2, this.getDefaultModalityState());
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        ModalityStateEx modalityStateEx = LaterInvocator.getCurrentModalityState();
        if (modalityStateEx == null) {
            ApplicationImpl.$$$reportNull$$$0(28);
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c) {
        Window window;
        if (c == null) {
            ApplicationImpl.$$$reportNull$$$0(29);
        }
        if ((window = ComponentUtil.getWindow((Component)c)) == null) {
            ModalityState modalityState = this.getNoneModalityState();
            if (modalityState == null) {
                ApplicationImpl.$$$reportNull$$$0(30);
            }
            return modalityState;
        }
        ModalityStateEx modalityStateEx = LaterInvocator.modalityStateForWindow((Window)window);
        if (modalityStateEx == null) {
            ApplicationImpl.$$$reportNull$$$0(31);
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getAnyModalityState() {
        AnyModalityState anyModalityState = AnyModalityState.ANY;
        if (anyModalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(32);
        }
        return anyModalityState;
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        ModalityState modalityState = this.isDispatchThread() ? this.getCurrentModalityState() : ModalityKt.defaultModalityImpl();
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(33);
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        ModalityState modalityState = ModalityState.nonModal();
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(34);
        }
        return modalityState;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    public long getIdleTime() {
        return IdeEventQueue.getInstance().getIdleTime();
    }

    public void restart(boolean exitConfirmed) {
        this.restart(exitConfirmed, false);
    }

    public void restart(boolean exitConfirmed, boolean elevate) {
        int flags = 4;
        if (exitConfirmed) {
            flags |= 2;
        }
        if (elevate) {
            flags |= 8;
        }
        this.restart(flags, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void exit(boolean force, boolean exitConfirmed, boolean restart, int exitCode2) {
        int flags = 4;
        if (force) {
            flags |= 1;
        }
        if (exitConfirmed) {
            flags |= 2;
        }
        this.exit(flags, restart, ArrayUtilRt.EMPTY_STRING_ARRAY, exitCode2);
    }

    public void exit(boolean force, boolean exitConfirmed, boolean restart) {
        this.exit(force, exitConfirmed, restart, 0);
    }

    public void restart(int flags, String @NotNull [] beforeRestart) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(35);
        }
        this.exit(flags, true, beforeRestart, 0);
    }

    public void exit(int flags, int exitCode2) {
        this.exit(flags, false, ArrayUtil.EMPTY_STRING_ARRAY, exitCode2);
    }

    public void exit(int flags) {
        this.exit(flags, false, ArrayUtil.EMPTY_STRING_ARRAY, 0);
    }

    private void exit(int flags, boolean restart, String @NotNull [] beforeRestart, int exitCode2) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(36);
        }
        if (!BitUtil.isSet((int)flags, (int)1) && (this.myExitInProgress || !BitUtil.isSet((int)flags, (int)2) && this.getDefaultModalityState() != ModalityState.nonModal())) {
            return;
        }
        this.myExitInProgress = true;
        if (this.isDispatchThread()) {
            this.doExit(flags, restart, beforeRestart, exitCode2);
        } else {
            this.invokeLater(() -> this.doExit(flags, restart, beforeRestart, exitCode2), ModalityState.nonModal());
        }
    }

    public boolean isExitInProgress() {
        return this.myExitInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExit(int flags, boolean restart, String @NotNull [] beforeRestart, int exitCode2) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(37);
        }
        Integer actualExitCode = null;
        try {
            actualExitCode = this.destructApplication(flags, restart, beforeRestart, exitCode2);
        }
        catch (Throwable err) {
            ApplicationImpl.logErrorDuringExit("Failed to destruct the application", err);
        }
        finally {
            if (actualExitCode != null) {
                System.exit(actualExitCode);
            }
        }
    }

    @Nullable
    private Integer destructApplication(int flags, boolean restart, String @NotNull [] beforeRestart, int exitCode2) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(38);
        }
        IJTracer tracer = TelemetryManager.getInstance().getTracer(new com.intellij.platform.diagnostic.telemetry.Scope("exitApp", null));
        Span exitSpan = tracer.spanBuilder("application.exit").startSpan();
        boolean force = BitUtil.isSet((int)flags, (int)1);
        try {
            Integer n;
            block53: {
                boolean canRestart;
                Scope scope;
                block51: {
                    Integer e22;
                    block52: {
                        block49: {
                            Integer e22;
                            block50: {
                                AppLifecycleListener lifecycleListener;
                                block47: {
                                    Integer n2;
                                    block48: {
                                        block45: {
                                            Integer n3;
                                            block46: {
                                                scope = exitSpan.makeCurrent();
                                                if (force || ApplicationImpl.confirmExitIfNeeded(BitUtil.isSet((int)flags, (int)2))) break block45;
                                                n3 = null;
                                                if (scope == null) break block46;
                                                scope.close();
                                            }
                                            return n3;
                                        }
                                        canRestart = restart && Restarter.isSupported();
                                        lifecycleListener = (AppLifecycleListener)this.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC);
                                        lifecycleListener.appClosing();
                                        if (force || this.canExit(restart)) break block47;
                                        n2 = null;
                                        if (scope == null) break block48;
                                        scope.close();
                                    }
                                    return n2;
                                }
                                try {
                                    try {
                                        this.stopServicePreloading();
                                    }
                                    catch (Throwable t) {
                                        ApplicationImpl.logErrorDuringExit("Failed to stop service preloading", t);
                                    }
                                    try {
                                        lifecycleListener.beforeAppWillBeClosed(restart);
                                    }
                                    catch (Throwable t) {
                                        ApplicationImpl.logErrorDuringExit("Failed to invoke lifecycle listeners", t);
                                    }
                                    if (BitUtil.isSet((int)flags, (int)4)) {
                                        try {
                                            TraceKt.use((SpanBuilder)tracer.spanBuilder("saveSettingsOnExit"), __ -> SaveAndSyncHandler.getInstance().saveSettingsUnderModalProgress((ComponentManager)this));
                                        }
                                        catch (Throwable e3) {
                                            ApplicationImpl.logErrorDuringExit("Failed to save settings", e3);
                                        }
                                    }
                                    try {
                                        if (ApplicationImpl.isInstantShutdownPossible()) {
                                            for (Frame frame : Frame.getFrames()) {
                                                frame.setVisible(false);
                                            }
                                        }
                                    }
                                    catch (Throwable e4) {
                                        ApplicationImpl.logErrorDuringExit("Failed to instant shutdown the frames", e4);
                                    }
                                    try {
                                        lifecycleListener.appWillBeClosed(restart);
                                    }
                                    catch (Throwable t) {
                                        ApplicationImpl.logErrorDuringExit("Failed to invoke lifecycle listeners", t);
                                    }
                                    try {
                                        LifecycleUsageTriggerCollector.onIdeClose(restart);
                                    }
                                    catch (Throwable e5) {
                                        ApplicationImpl.logErrorDuringExit("Failed to notify usage collector", e5);
                                    }
                                    boolean success2 = true;
                                    ProjectManagerEx manager2 = ProjectManagerEx.getInstanceExIfCreated();
                                    if (manager2 != null) {
                                        try {
                                            boolean projectsClosedSuccessfully = (Boolean)TraceKt.use((SpanBuilder)tracer.spanBuilder("disposeProjects"), __ -> manager2.closeAndDisposeAllProjects(!force));
                                            if (!projectsClosedSuccessfully) {
                                                success2 = false;
                                            }
                                        }
                                        catch (Throwable e6) {
                                            ApplicationImpl.logErrorDuringExit("Failed to close and dispose all projects", e6);
                                        }
                                    }
                                    try {
                                        scope.close();
                                        exitSpan.end();
                                    }
                                    catch (Throwable e22) {
                                        ApplicationImpl.logErrorDuringExit("Failed to report the telemetry", e22);
                                    }
                                    this.disposeContainer();
                                    if (success2 && !this.isUnitTestMode()) break block49;
                                    e22 = null;
                                    if (scope == null) break block50;
                                }
                                catch (Throwable throwable) {
                                    if (scope != null) {
                                        try {
                                            scope.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                scope.close();
                            }
                            return e22;
                        }
                        IdeEventQueue.applicationClose();
                        if (!Boolean.getBoolean("idea.test.guimode")) break block51;
                        ShutDownTracker.getInstance().run();
                        e22 = null;
                        if (scope == null) break block52;
                        scope.close();
                    }
                    return e22;
                }
                IdeaLogger.dropFrequentExceptionsCaches();
                if (restart) {
                    if (canRestart) {
                        try {
                            Restarter.scheduleRestart(BitUtil.isSet((int)flags, (int)8), beforeRestart);
                        }
                        catch (Throwable t) {
                            ApplicationImpl.logErrorDuringExit("Failed to restart the application", t);
                        }
                    } else {
                        ApplicationImpl.getLogger().warn("Restart not supported; exiting");
                    }
                    if (exitCode2 == 0) {
                        exitCode2 = 2;
                    }
                }
                n = exitCode2;
                if (scope == null) break block53;
                scope.close();
            }
            return n;
        }
        finally {
            exitSpan.end();
            this.myExitInProgress = false;
        }
    }

    private static void logErrorDuringExit(String message, Throwable err) {
        try {
            class ApplicationExitException
            extends RuntimeException {
                ApplicationExitException(Throwable cause) {
                    super(cause);
                }
            }
            ApplicationImpl.getLogger().error(message, (Throwable)new ApplicationExitException(err));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isInstantShutdownPossible() {
        return InstantShutdown.isAllowed() && !ProgressManager.getInstance().hasProgressIndicator();
    }

    @NotNull
    private @NotNull CompletableFuture<@NotNull ProgressWindow> createProgressWindowAsyncIfNeeded(@NlsContexts.ProgressTitle @NotNull String progressTitle, boolean canBeCanceled, boolean shouldShowModalWindow, @Nullable Project project2, @Nullable JComponent parentComponent, @NlsContexts.Button @Nullable String cancelText) {
        if (progressTitle == null) {
            ApplicationImpl.$$$reportNull$$$0(39);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            CompletableFuture<ProgressWindow> completableFuture = CompletableFuture.completedFuture(this.createProgressWindow(progressTitle, canBeCanceled, shouldShowModalWindow, project2, parentComponent, cancelText));
            if (completableFuture == null) {
                ApplicationImpl.$$$reportNull$$$0(40);
            }
            return completableFuture;
        }
        CompletableFuture<ProgressWindow> completableFuture = CompletableFuture.supplyAsync(() -> this.createProgressWindow(progressTitle, canBeCanceled, shouldShowModalWindow, project2, parentComponent, cancelText), this::invokeLater);
        if (completableFuture == null) {
            ApplicationImpl.$$$reportNull$$$0(41);
        }
        return completableFuture;
    }

    private ProgressWindow createProgressWindow(@NlsContexts.ProgressTitle String progressTitle, boolean canBeCanceled, boolean shouldShowModalWindow, @Nullable Project project2, @Nullable JComponent parentComponent, @NlsContexts.Button @Nullable String cancelText) {
        ProgressWindow progress = new ProgressWindow(canBeCanceled, !shouldShowModalWindow, project2, parentComponent, cancelText);
        Disposer.register((Disposable)this, (Disposable)progress);
        progress.setTitle(progressTitle);
        return progress;
    }

    private static boolean confirmExitIfNeeded(boolean exitConfirmed) {
        final boolean hasUnsafeBgTasks = ProgressManager.getInstance().hasUnsafeProgressIndicator();
        if (exitConfirmed && !hasUnsafeBgTasks) {
            return true;
        }
        var option2 = new DoNotAskOption(){

            public boolean isToBeShown() {
                return GeneralSettings.getInstance().isConfirmExit() && ProjectManager.getInstance().getOpenProjects().length > 0;
            }

            public void setToBeShown(boolean value, int exitCode2) {
                GeneralSettings.getInstance().setConfirmExit(value);
            }

            public boolean canBeHidden() {
                return !hasUnsafeBgTasks;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = IdeBundle.message((String)"do.not.ask.me.again", (Object[])new Object[0]);
                if (string == null) {
                    8.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl$8", "getDoNotShowMessage"));
            }
        };
        if (!hasUnsafeBgTasks && !option2.isToBeShown()) {
            return true;
        }
        if (hasUnsafeBgTasks && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            ApplicationImpl.getLogger().error("Headless application has been completed but background tasks are still running! Application will be terminated.", new Attachment[]{new Attachment("stacktrace.txt", ThreadDumper.dumpThreadsToString())});
            return true;
        }
        final AtomicBoolean alreadyGone = new AtomicBoolean(false);
        if (hasUnsafeBgTasks) {
            final Runnable dialogRemover = Messages.createMessageDialogRemover(null);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    if (alreadyGone.get()) {
                        return;
                    }
                    if (!ProgressManager.getInstance().hasUnsafeProgressIndicator()) {
                        alreadyGone.set(true);
                        dialogRemover.run();
                    } else {
                        AppExecutorUtil.getAppScheduledExecutorService().schedule(this, 1L, TimeUnit.SECONDS);
                    }
                }
            };
            AppExecutorUtil.getAppScheduledExecutorService().schedule(task, 1L, TimeUnit.SECONDS);
        }
        String message = ApplicationBundle.message((String)(hasUnsafeBgTasks ? "exit.confirm.prompt.tasks" : "exit.confirm.prompt"), (Object[])new Object[0]);
        exitConfirmed = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)message).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).noText(CommonBundle.getCancelButtonText())).doNotAsk(option2)).guessWindowAndAsk();
        if (alreadyGone.getAndSet(true)) {
            if (!option2.isToBeShown()) {
                return true;
            }
            exitConfirmed = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"exit.confirm.prompt", (Object[])new Object[0])).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).doNotAsk(option2)).guessWindowAndAsk();
        }
        return exitConfirmed;
    }

    private boolean canExit(boolean restart) {
        Project[] projects;
        for (ApplicationListener applicationListener : this.myDispatcher.getListeners()) {
            if ((!restart || applicationListener.canRestartApplication()) && (restart || applicationListener.canExitApplication())) continue;
            return false;
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceExIfCreated();
        if (projectManager == null) {
            return true;
        }
        for (Project project2 : projects = projectManager.getOpenProjects()) {
            if (projectManager.canClose(project2)) continue;
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    public boolean isCurrentWriteOnEdt() {
        return false;
    }

    public void runIntendedWriteActionOnCurrentThread(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(42);
        }
        this.getThreadingSupport().runWriteIntentReadAction(AppImplKt.runnableUnitFunction(action2));
    }

    public <T, E extends Throwable> T runUnlockingIntendedWrite(@NotNull ThrowableComputable<T, E> action2) throws E {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(43);
        }
        return (T)this.getThreadingSupport().runUnlockingIntendedWrite(AppImplKt.rethrowCheckedExceptions(action2));
    }

    public void runReadAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(44);
        }
        this.getThreadingSupport().runReadAction(action2.getClass(), AppImplKt.runnableUnitFunction(action2));
    }

    public <T> T runReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(45);
        }
        return (T)this.getThreadingSupport().runReadAction(computation.getClass(), () -> computation.compute());
    }

    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(46);
        }
        return (T)this.getThreadingSupport().runReadAction(computation.getClass(), AppImplKt.rethrowCheckedExceptions(computation));
    }

    @ApiStatus.Experimental
    public boolean runWriteActionWithNonCancellableProgressInDispatchThread(@NlsContexts.ProgressTitle @NotNull String title2, @Nullable Project project2, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title2 == null) {
            ApplicationImpl.$$$reportNull$$$0(47);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(48);
        }
        return this.runEdtProgressWriteAction(title2, project2, parentComponent, null, action2);
    }

    @ApiStatus.Experimental
    public boolean runWriteActionWithCancellableProgressInDispatchThread(@NlsContexts.ProgressTitle @NotNull String title2, @Nullable Project project2, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title2 == null) {
            ApplicationImpl.$$$reportNull$$$0(49);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(50);
        }
        return this.runEdtProgressWriteAction(title2, project2, parentComponent, IdeBundle.message((String)"action.stop", (Object[])new Object[0]), action2);
    }

    private boolean runEdtProgressWriteAction(@NlsContexts.ProgressTitle String title2, @Nullable Project project2, @Nullable JComponent parentComponent, @Nls(capitalization=Nls.Capitalization.Title) @Nullable String cancelText, @NotNull Consumer<? super @Nullable ProgressIndicator> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(51);
        }
        return (Boolean)this.lock.runWriteAction(action2.getClass(), () -> {
            if (JBUIScale.isInitialized()) {
                PotemkinProgress indicator2 = new PotemkinProgress(title2, project2, parentComponent, cancelText);
                indicator2.runInSwingThread(() -> action2.accept((ProgressIndicator)indicator2));
                return !indicator2.isCanceled();
            }
            EmptyProgressIndicator indicator3 = new EmptyProgressIndicator();
            action2.accept((ProgressIndicator)indicator3);
            return !indicator3.isCanceled();
        });
    }

    private static void checkWriteActionAllowedOnCurrentThread() {
        if (EDT.isCurrentThreadEdt()) {
            return;
        }
        if (!InternalThreading.isBackgroundWriteActionAllowed()) {
            throw new IllegalStateException("Background write action is not permitted on this thread. Consider using `backgroundWriteAction`, or switch to EDT");
        }
    }

    public void runWriteAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(52);
        }
        ApplicationImpl.checkWriteActionAllowedOnCurrentThread();
        ApplicationImpl.incrementBackgroundWriteActionCounter();
        try {
            this.getThreadingSupport().runWriteAction(action2.getClass(), AppImplKt.runnableUnitFunction(action2));
        }
        finally {
            ApplicationImpl.decrementBackgroundWriteActionCounter();
        }
    }

    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(53);
        }
        ApplicationImpl.checkWriteActionAllowedOnCurrentThread();
        ApplicationImpl.incrementBackgroundWriteActionCounter();
        try {
            Object object = this.getThreadingSupport().runWriteAction(computation.getClass(), () -> computation.compute());
            return (T)object;
        }
        finally {
            ApplicationImpl.decrementBackgroundWriteActionCounter();
        }
    }

    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(54);
        }
        ApplicationImpl.checkWriteActionAllowedOnCurrentThread();
        ApplicationImpl.incrementBackgroundWriteActionCounter();
        try {
            Object object = this.getThreadingSupport().runWriteAction(computation.getClass(), AppImplKt.rethrowCheckedExceptions(computation));
            return (T)object;
        }
        finally {
            ApplicationImpl.decrementBackgroundWriteActionCounter();
        }
    }

    private static void incrementBackgroundWriteActionCounter() {
        if (EDT.isCurrentThreadEdt()) {
            return;
        }
        InternalThreading.incrementBackgroundWriteActionCount();
    }

    private static void decrementBackgroundWriteActionCounter() {
        if (EDT.isCurrentThreadEdt()) {
            return;
        }
        InternalThreading.decrementBackgroundWriteActionCount();
    }

    public boolean hasWriteAction(@NotNull Class<?> actionClass) {
        if (actionClass == null) {
            ApplicationImpl.$$$reportNull$$$0(55);
        }
        ThreadingAssertions.softAssertReadAccess();
        Class<WriteActionPresenceService> serviceClass = WriteActionPresenceService.class;
        return Objects.requireNonNull((WriteActionPresenceService)this.getService(serviceClass)).hasWriteAction(actionClass);
    }

    public <T, E extends Throwable> T runWriteIntentReadAction(@NotNull ThrowableComputable<T, E> computation) {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(56);
        }
        return (T)this.getThreadingSupport().runWriteIntentReadAction(AppImplKt.rethrowCheckedExceptions(computation));
    }

    public void assertReadAccessAllowed() {
        ThreadingAssertions.softAssertReadAccess();
    }

    public void assertReadAccessNotAllowed() {
        ThreadingAssertions.assertNoReadAccess();
    }

    public boolean isReadAccessAllowed() {
        return this.getThreadingSupport().isReadAccessAllowed();
    }

    public void assertIsDispatchThread() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    public void assertIsNonDispatchThread() {
        ThreadingAssertions.assertBackgroundThread();
    }

    public void assertWriteIntentLockAcquired() {
        ThreadingAssertions.assertWriteIntentReadAccess();
    }

    public void assertIsDispatchThread(@Nullable JComponent component2) {
        if (component2 == null) {
            return;
        }
        if (this.isDispatchThread()) {
            return;
        }
        if (Boolean.TRUE.equals(component2.getClientProperty(WAS_EVER_SHOWN))) {
            ThreadingAssertions.assertEventDispatchThread();
        } else if (component2.getRootPane() != null) {
            component2.putClientProperty(WAS_EVER_SHOWN, Boolean.TRUE);
            ThreadingAssertions.assertEventDispatchThread();
        }
    }

    public boolean tryRunReadAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(57);
        }
        return this.getThreadingSupport().tryRunReadAction(action2);
    }

    public boolean isActive() {
        if (this.isHeadlessEnvironment()) {
            return true;
        }
        if (this.isDisposed()) {
            return false;
        }
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeWindow != null) {
            ApplicationActivationStateManager.INSTANCE.updateState(this, activeWindow);
        }
        return ApplicationActivationStateManager.INSTANCE.isActive();
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        PluginException.reportDeprecatedUsage((String)"Application.acquireReadActionLock", (String)"Use `runReadAction()` instead");
        final Function0 cleanup = this.getThreadingSupport().acquireReadActionLock();
        return new AccessToken(this){

            public void finish() {
                cleanup.invoke();
            }
        };
    }

    public boolean isWriteActionPending() {
        return this.getThreadingSupport().isWriteActionPending();
    }

    public boolean isBackgroundWriteActionRunningOrPending() {
        return InternalThreading.isBackgroundWriteActionRunning();
    }

    public boolean isWriteAccessAllowed() {
        return this.getThreadingSupport().isWriteAccessAllowed();
    }

    @NotNull
    public AccessToken acquireWriteActionLock(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(58);
        }
        PluginException.reportDeprecatedUsage((String)"Application#acquireWriteActionLock", (String)"Use `runWriteAction()` instead");
        final Function0 cleanup = this.getThreadingSupport().acquireWriteActionLock(clazz);
        return new AccessToken(this){

            public void finish() {
                cleanup.invoke();
            }
        };
    }

    public void assertWriteAccessAllowed() {
        ThreadingAssertions.assertWriteAccess();
    }

    public void executeSuspendingWriteAction(@Nullable Project project2, @NlsContexts.DialogTitle @NotNull String title2, final @NotNull Runnable runnable2) {
        if (title2 == null) {
            ApplicationImpl.$$$reportNull$$$0(59);
        }
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(60);
        }
        ThreadingAssertions.assertWriteIntentReadAccess();
        this.getThreadingSupport().executeSuspendingWriteAction(AppImplKt.runnableUnitFunction(() -> ProgressManager.getInstance().run((Task)new Task.Modal(this, project2, title2, false){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    12.$$$reportNull$$$0(0);
                }
                runnable2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/impl/ApplicationImpl$12", "run"));
            }
        })));
    }

    public boolean isWriteActionInProgress() {
        return this.getThreadingSupport().isWriteActionInProgress();
    }

    public void addApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(61);
        }
        this.myDispatcher.addListener((EventListener)l);
    }

    public void addApplicationListener(@NotNull ApplicationListener l, @NotNull Disposable parent) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(62);
        }
        if (parent == null) {
            ApplicationImpl.$$$reportNull$$$0(63);
        }
        this.myDispatcher.addListener((EventListener)l, parent);
    }

    public void removeApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(64);
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    public void saveSettings() {
        if (this.mySaveAllowed) {
            StoreUtil.saveSettings((ComponentManager)this, false);
        }
    }

    public void saveAll() {
        StoreUtil.saveDocumentsAndProjectsAndApp(false);
    }

    public void setSaveAllowed(boolean value) {
        this.mySaveAllowed = value;
    }

    public boolean isSaveAllowed() {
        return this.mySaveAllowed;
    }

    public boolean isRestartCapable() {
        return Restarter.isSupported();
    }

    public String toString() {
        boolean writeActionPending = this.isWriteActionPending();
        boolean writeActionInProgress = this.isWriteActionInProgress();
        boolean writeAccessAllowed = this.isWriteAccessAllowed();
        return "Application" + (String)(this.containerState.get() == ComponentManagerImpl.ContainerState.COMPONENT_CREATED ? "" : " (containerState " + this.getContainerStateName() + ") ") + (this.isUnitTestMode() ? " (unit test)" : "") + (this.isInternal() ? " (internal)" : "") + (this.isHeadlessEnvironment() ? " (headless)" : "") + (this.isCommandLine() ? " (command line)" : "") + (String)(writeActionPending || writeActionInProgress || writeAccessAllowed ? " (WA" + (writeActionPending ? " pending" : "") + (writeActionInProgress ? " inProgress" : "") + (writeAccessAllowed ? " allowed" : "") + ")" : "") + (this.isReadAccessAllowed() ? " (RA allowed)" : "") + (this.isInImpatientReader() ? " (impatient reader)" : "") + (this.isExitInProgress() ? " (exit in progress)" : "");
    }

    @NotNull
    public String activityNamePrefix() {
        return "app ";
    }

    @NotNull
    protected ContainerDescriptor getContainerDescriptor(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        if (pluginDescriptor == null) {
            ApplicationImpl.$$$reportNull$$$0(65);
        }
        ContainerDescriptor containerDescriptor = pluginDescriptor.getAppContainerDescriptor();
        if (containerDescriptor == null) {
            ApplicationImpl.$$$reportNull$$$0(66);
        }
        return containerDescriptor;
    }

    protected void logMessageBusDelivery(@NotNull Topic<?> topic, @NotNull String messageName, @NotNull Object handler, long duration2) {
        if (topic == null) {
            ApplicationImpl.$$$reportNull$$$0(67);
        }
        if (messageName == null) {
            ApplicationImpl.$$$reportNull$$$0(68);
        }
        if (handler == null) {
            ApplicationImpl.$$$reportNull$$$0(69);
        }
        super.logMessageBusDelivery(topic, messageName, handler, duration2);
        if (topic == ProjectManager.TOPIC) {
            long start2 = System.nanoTime() - duration2;
            StartUpMeasurer.addCompletedActivity((long)start2, handler.getClass(), (ActivityCategory)ActivityCategory.PROJECT_OPEN_HANDLER, null, (long)StartUpMeasurer.MEASURE_THRESHOLD);
        } else if (topic == VirtualFileManager.VFS_CHANGES && TimeUnit.NANOSECONDS.toMillis(duration2) > 50L) {
            ApplicationImpl.getLogger().info(String.format("LONG VFS PROCESSING. Topic=%s, offender=%s, message=%s, time=%dms", topic.getDisplayName(), handler.getClass(), messageName, TimeUnit.NANOSECONDS.toMillis(duration2)));
        }
    }

    @TestOnly
    @ApiStatus.Internal
    public void disableEventsUntil(@NotNull Disposable disposable) {
        if (disposable == null) {
            ApplicationImpl.$$$reportNull$$$0(70);
        }
        this.myDispatcher.neuterMultiCasterWhilePerformanceTestIsRunningUntil(disposable);
    }

    public boolean isComponentCreated() {
        return ((ComponentManagerImpl.ContainerState)this.containerState.get()).compareTo((Enum)ComponentManagerImpl.ContainerState.COMPONENT_CREATED) >= 0;
    }

    @ApiStatus.Internal
    public static void postInit(@NotNull ApplicationImpl app) {
        if (app == null) {
            ApplicationImpl.$$$reportNull$$$0(71);
        }
        final AtomicBoolean reported = new AtomicBoolean();
        IdeEventQueue.getInstance().addPostprocessor(e -> {
            if (app.isWriteAccessAllowed() && reported.compareAndSet(false, true)) {
                ApplicationImpl.getLogger().error("AWT events are not allowed inside write action: " + String.valueOf(e));
            }
            return true;
        }, app.getCoroutineScope());
        app.lock.addReadActionListener(app.customReadActionListener);
        app.lock.addWriteActionListener(app.appListenerDispatcherWrapper);
        app.lock.setLegacyIndicatorProvider(myLegacyIndicatorProvider);
        app.lock.setErrorHandler(lockingErrorHandler);
        SwingUtilities.invokeLater(() -> {
            SuvorovProgress.INSTANCE.init((Disposable)app);
            app.lock.setLockAcquisitionInterceptor(deferred2 -> {
                SuvorovProgress.dispatchEventsUntilComputationCompletes(deferred2);
                return Unit.INSTANCE;
            });
        });
        app.addApplicationListener(new ApplicationListener(){

            public void afterWriteActionFinished(@NotNull Object action2) {
                if (action2 == null) {
                    13.$$$reportNull$$$0(0);
                }
                reported.set(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl$13", "afterWriteActionFinished"));
            }
        }, (Disposable)app);
        if (app.isInternal() || app.isUnitTestMode()) {
            ContainerUtil.Options.RETURN_REALLY_UNMODIFIABLE_COLLECTION_FROM_METHODS_MARKED_UNMODIFIABLE = true;
        }
    }

    public void flushNativeEventQueue() {
        IdeEventQueue.getInstance().flushNativeEventQueue();
    }

    public void addWriteActionListener(@NotNull WriteActionListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ApplicationImpl.$$$reportNull$$$0(72);
        }
        if (parentDisposable == null) {
            ApplicationImpl.$$$reportNull$$$0(73);
        }
        this.lock.addWriteActionListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.lock.removeWriteActionListener(listener2));
    }

    public void addReadActionListener(@NotNull ReadActionListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ApplicationImpl.$$$reportNull$$$0(74);
        }
        if (parentDisposable == null) {
            ApplicationImpl.$$$reportNull$$$0(75);
        }
        this.lock.addReadActionListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.lock.removeReadActionListener(listener2));
    }

    public void addWriteIntentReadActionListener(@NotNull WriteIntentReadActionListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ApplicationImpl.$$$reportNull$$$0(76);
        }
        if (parentDisposable == null) {
            ApplicationImpl.$$$reportNull$$$0(77);
        }
        this.lock.addWriteIntentReadActionListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.lock.removeWriteIntentReadActionListener(listener2));
    }

    public void addLockAcquisitionListener(@NotNull LockAcquisitionListener<?> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ApplicationImpl.$$$reportNull$$$0(78);
        }
        if (parentDisposable == null) {
            ApplicationImpl.$$$reportNull$$$0(79);
        }
        this.lock.setLockAcquisitionListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.lock.removeLockAcquisitionListener(listener2));
    }

    public void prohibitTakingLocksInsideAndRun(@NotNull Runnable runnable2, boolean failSoftly, @NlsSafe String advice) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(80);
        }
        this.getThreadingSupport().prohibitTakingLocksInsideAndRun(runnable2, failSoftly, advice);
    }

    public String isLockingProhibited() {
        return this.getThreadingSupport().getLockingProhibitedAdvice();
    }

    public boolean isTopmostReadAccessAllowed() {
        return this.getThreadingSupport().isInTopmostReadAction();
    }

    public void addSuspendingWriteActionListener(@NotNull WriteLockReacquisitionListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ApplicationImpl.$$$reportNull$$$0(81);
        }
        if (parentDisposable == null) {
            ApplicationImpl.$$$reportNull$$$0(82);
        }
        this.lock.setWriteLockReacquisitionListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.lock.removeWriteLockReacquisitionListener(listener2));
    }

    public kotlin.Pair<CoroutineContext, AccessToken> getLockStateAsCoroutineContext(CoroutineContext baseContext, boolean shared) {
        final kotlin.Pair pair = this.getThreadingSupport().getPermitAsContextElement(baseContext, shared);
        return new kotlin.Pair((Object)((CoroutineContext)pair.getFirst()), (Object)new AccessToken(this){

            public void finish() {
                ((Function0)pair.getSecond()).invoke();
            }
        });
    }

    public boolean isParallelizedReadAction(CoroutineContext context) {
        return this.getThreadingSupport().isParallelizedReadAction(context);
    }

    @NotNull
    public ThreadingSupport getThreadingSupport() {
        NestedLocksThreadingSupport nestedLocksThreadingSupport = this.lock;
        if (nestedLocksThreadingSupport == null) {
            ApplicationImpl.$$$reportNull$$$0(83);
        }
        return nestedLocksThreadingSupport;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 29, 35, 36, 37, 38, 39, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCoroutineContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentScope";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 60: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 7: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 18: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRestart";
                break;
            }
            case 45: 
            case 46: 
            case 53: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 47: 
            case 49: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 61: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageName";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 73: 
            case 75: 
            case 77: 
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentStore";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithRunIntendedWriteActionAndModality";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalityState";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityStateForComponent";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnyModalityState";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModalityState";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoneModalityState";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressWindowAsyncIfNeeded";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerDescriptor";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadingSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeByImpatientReader";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitRelaxed";
                break;
            }
            case 21: 
            case 22: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doInvokeAndWait";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithRunIntendedWriteActionAndModality";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getModalityStateForComponent";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "restart";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "exit";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "doExit";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "destructApplication";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createProgressWindowAsyncIfNeeded";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runIntendedWriteActionOnCurrentThread";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "runUnlockingIntendedWrite";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "runReadAction";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithNonCancellableProgressInDispatchThread";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithCancellableProgressInDispatchThread";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "runEdtProgressWriteAction";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "runWriteAction";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "hasWriteAction";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "runWriteIntentReadAction";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "tryRunReadAction";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "acquireWriteActionLock";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "executeSuspendingWriteAction";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addApplicationListener";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "removeApplicationListener";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getContainerDescriptor";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "logMessageBusDelivery";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "disableEventsUntil";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "postInit";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "addWriteActionListener";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "addReadActionListener";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addWriteIntentReadActionListener";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addLockAcquisitionListener";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "prohibitTakingLocksInsideAndRun";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "addSuspendingWriteActionListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 29, 35, 36, 37, 38, 39, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82 -> new IllegalArgumentException(string);
        };
    }
}

