/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionContextElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Interactive;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.Mode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import java.lang.invoke.MethodHandles;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a \u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "processUnhandledException", "", "exception", "", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "logExceptionSafely", "message", "", "interactive", "", "interactiveMode", "Lcom/intellij/openapi/application/impl/Mode;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nexceptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 exceptions.kt\ncom/intellij/openapi/application/impl/ExceptionsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,87:1\n57#2:88\n35#2,2:89\n*S KotlinDebug\n*F\n+ 1 exceptions.kt\ncom/intellij/openapi/application/impl/ExceptionsKt\n*L\n21#1:88\n21#1:89,2\n*E\n"})
public final class ExceptionsKt {
    @NotNull
    private static final Logger LOG;

    public static final void processUnhandledException(@NotNull Throwable exception, @Nullable CoroutineContext coroutineContext) {
        CoroutineContext coroutineContext2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        CoroutineContext coroutineContext3 = coroutineContext;
        if (coroutineContext3 == null) {
            coroutineContext3 = ThreadContext.currentThreadContextOrNull();
        }
        if ((object = (coroutineContext2 = coroutineContext3)) == null || (object = object.toString()) == null) {
            object = "EDT";
        }
        String message = "Unhandled exception in " + (String)object;
        Mode interactiveMode = ExceptionsKt.interactiveMode(coroutineContext2);
        if (interactiveMode instanceof Mode.Interactive) {
            SwingUtilities.invokeLater(() -> ExceptionsKt.processUnhandledException$lambda$0(message, exception, interactiveMode));
        } else if (Intrinsics.areEqual((Object)interactiveMode, (Object)Mode.NonInteractive.INSTANCE)) {
            ExceptionsKt.logExceptionSafely(message, exception, false);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void logExceptionSafely(String message, Throwable exception, boolean interactive) {
        try {
            LOG.error(message + ", interactive mode: " + interactive, exception);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final Mode interactiveMode(CoroutineContext coroutineContext) {
        block6: {
            block5: {
                Interactive interactive;
                CoroutineContext coroutineContext2 = coroutineContext;
                ActionContextElement action2 = coroutineContext2 != null ? (ActionContextElement)coroutineContext2.get((CoroutineContext.Key)ActionContextElement.Companion) : null;
                CoroutineContext coroutineContext3 = coroutineContext;
                Interactive interactive2 = interactive = coroutineContext3 != null ? (Interactive)coroutineContext3.get((CoroutineContext.Key)Interactive.Key) : null;
                if (interactive != null) {
                    return new Mode.Interactive(interactive.getAction());
                }
                if (action2 != null) {
                    AnAction anAction = ActionManager.getInstance().getAction(action2.getActionId());
                    String text2 = anAction != null && (anAction = anAction.getTemplatePresentation()) != null ? anAction.getText() : null;
                    return new Mode.Interactive(text2);
                }
                if (SwingUtilities.isEventDispatchThread() && LaterInvocator.isInModalContext()) break block5;
                Project[] projectArray = ProjectManager.getInstanceIfCreated();
                boolean bl = projectArray != null && (projectArray = projectArray.getOpenProjects()) != null ? projectArray.length == 0 : false;
                if (!bl) break block6;
            }
            return new Mode.Interactive(null);
        }
        return Mode.NonInteractive.INSTANCE;
    }

    private static final void processUnhandledException$lambda$0(String $message, Throwable $exception, Mode $interactiveMode) {
        boolean showError;
        ExceptionsKt.logExceptionSafely($message, $exception, true);
        LogMessage defaultMessage = new LogMessage($exception, $message, CollectionsKt.emptyList());
        boolean bl = showError = Registry.Companion.get("ide.exceptions.show.interactive").asBoolean() && !ApplicationManager.getApplication().isHeadlessEnvironment();
        if (showError) {
            MessagePool messagePool = MessagePool.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)messagePool, (String)"getInstance(...)");
            new IdeErrorsDialog(messagePool, null, false, defaultMessage, true, ((Mode.Interactive)$interactiveMode).getAction(), true).show();
        }
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

