/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.LocalCommandMergerSnapshot;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.UndoCommandFlushReason;
import com.intellij.openapi.command.impl.UndoDumpUnit;
import com.intellij.openapi.command.impl.UndoRedoList;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CommandMerger {
    private final boolean isLocalHistoryActivity;
    private final boolean isTransparentSupported;
    private @NlsContexts.Command @Nullable String commandName;
    @Nullable
    private Reference<Object> lastGroupId;
    @NotNull
    private UndoRedoList<UndoableAction> currentActions = new UndoRedoList();
    @NotNull
    private Set<DocumentReference> allAffectedDocuments = new HashSet<DocumentReference>();
    @NotNull
    private Set<DocumentReference> additionalAffectedDocuments = new HashSet<DocumentReference>();
    @NotNull
    private UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
    @Nullable
    private EditorAndState editorStateBefore;
    @Nullable
    private EditorAndState editorStateAfter;
    private boolean isForcedGlobal;
    private boolean isTransparent;
    private boolean isValid = true;

    public static boolean canMergeGroup(Object groupId, Object lastGroupId) {
        return groupId != null && Comparing.equal((Object)lastGroupId, (Object)groupId);
    }

    CommandMerger(boolean isLocalHistoryActivity, boolean isTransparent, boolean isTransparentSupported) {
        this.isLocalHistoryActivity = isLocalHistoryActivity;
        this.isTransparentSupported = isTransparentSupported;
        this.isTransparent = isTransparent;
    }

    boolean isUndoAvailable(@NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            CommandMerger.$$$reportNull$$$0(0);
        }
        if (this.hasNonUndoableActions()) {
            return false;
        }
        if (refs.isEmpty()) {
            return this.isGlobal() && this.hasActions();
        }
        for (DocumentReference each : refs) {
            if (!this.hasChangesOf(each, false)) continue;
            return true;
        }
        return false;
    }

    void addAction(@NotNull UndoableAction action2) {
        if (action2 == null) {
            CommandMerger.$$$reportNull$$$0(1);
        }
        this.currentActions.add(action2);
        DocumentReference[] refs = action2.getAffectedDocuments();
        if (refs != null) {
            Collections.addAll(this.allAffectedDocuments, refs);
        }
        this.isForcedGlobal |= action2.isGlobal();
    }

    @Nullable
    UndoCommandFlushReason shouldFlush(@Nullable Object nextGroupId, @NotNull CommandMerger nextCommandMerger) {
        if (nextCommandMerger == null) {
            CommandMerger.$$$reportNull$$$0(2);
        }
        if (this.isTransparentSupported && nextCommandMerger.isTransparent() && nextCommandMerger.editorStateAfter == null && this.editorStateAfter != null) {
            return this.createFlushReason("NEXT_TRANSPARENT_WITHOUT_EDITOR_STATE_AFTER", nextGroupId, nextCommandMerger);
        }
        if (this.isTransparentSupported && this.isTransparent() && this.editorStateBefore == null && nextCommandMerger.editorStateBefore != null) {
            return this.createFlushReason("CURRENT_TRANSPARENT_WITHOUT_EDITOR_STATE_BEFORE", nextGroupId, nextCommandMerger);
        }
        if (this.isTransparent() || nextCommandMerger.isTransparent()) {
            boolean changedDocs = this.hasActions() && nextCommandMerger.hasActions() && !this.allAffectedDocuments.equals(nextCommandMerger.allAffectedDocuments);
            return changedDocs ? this.createFlushReason("TRANSPARENT_WITH_DIFFERENT_DOCS", nextGroupId, nextCommandMerger) : null;
        }
        if ((this.isForcedGlobal || nextCommandMerger.isForcedGlobal) && !CommandMerger.isMergeGlobalCommandsAllowed()) {
            return this.createFlushReason("GLOBAL", nextGroupId, nextCommandMerger);
        }
        boolean canMergeGroup = CommandMerger.canMergeGroup(nextGroupId, SoftReference.dereference(this.lastGroupId));
        return canMergeGroup ? null : this.createFlushReason("CHANGED_GROUP", nextGroupId, nextCommandMerger);
    }

    void flushCurrentCommand(@NotNull UndoRedoStacksHolder undoStacksHolder, @NotNull UndoCommandFlushReason flushReason, int commandTimestamp) {
        if (undoStacksHolder == null) {
            CommandMerger.$$$reportNull$$$0(3);
        }
        if (flushReason == null) {
            CommandMerger.$$$reportNull$$$0(4);
        }
        if (this.hasActions()) {
            if (!this.additionalAffectedDocuments.isEmpty()) {
                DocumentReference[] refs = this.additionalAffectedDocuments.toArray(DocumentReference.EMPTY_ARRAY);
                this.currentActions.add((UndoableAction)new MyEmptyUndoableAction(refs));
            }
            undoStacksHolder.addToStacks(new UndoableGroup(this.commandName, this.currentActions, this.undoConfirmationPolicy, undoStacksHolder, this.editorStateBefore, this.editorStateAfter, flushReason, commandTimestamp, this.isLocalHistoryActivity, this.isTransparent(), this.isGlobal(), this.isValid));
        }
        this.reset();
    }

    void commandFinished(@NlsContexts.Command String commandName, Object groupId, @NotNull CommandMerger nextCommandToMerge) {
        if (nextCommandToMerge == null) {
            CommandMerger.$$$reportNull$$$0(5);
        }
        this.merge(nextCommandToMerge);
        if (nextCommandToMerge.isTransparent() || !this.hasActions()) {
            return;
        }
        if (groupId != SoftReference.dereference(this.lastGroupId)) {
            WeakReference<Object> weakReference = this.lastGroupId = groupId == null ? null : new WeakReference<Object>(groupId);
        }
        if (this.commandName == null) {
            this.commandName = commandName;
        }
    }

    boolean hasChangesOf(DocumentReference ref2, boolean onlyDirectChanges) {
        for (UndoableAction action2 : this.currentActions) {
            Object[] refs = action2.getAffectedDocuments();
            if (!(refs == null ? !onlyDirectChanges : ArrayUtil.contains((Object)ref2, (Object[])refs))) continue;
            return true;
        }
        return this.hasActions() && this.additionalAffectedDocuments.contains(ref2);
    }

    void setEditorStateBefore(@Nullable EditorAndState state2) {
        if (this.editorStateBefore == null || !this.hasActions()) {
            this.editorStateBefore = state2;
        }
    }

    void setEditorStateAfter(@Nullable EditorAndState state2) {
        this.editorStateAfter = state2;
    }

    void addAdditionalAffectedDocuments(@NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            CommandMerger.$$$reportNull$$$0(6);
        }
        this.allAffectedDocuments.addAll(refs);
        this.additionalAffectedDocuments.addAll(refs);
    }

    void invalidateActionsFor(@NotNull DocumentReference ref2) {
        if (ref2 == null) {
            CommandMerger.$$$reportNull$$$0(7);
        }
        if (this.allAffectedDocuments.contains(ref2)) {
            this.isValid = false;
        }
    }

    @Nullable
    LocalCommandMergerSnapshot getSnapshot(@NotNull DocumentReference reference) {
        DocumentReference currentReference;
        if (reference == null) {
            CommandMerger.$$$reportNull$$$0(8);
        }
        if (this.isGlobal() || !this.additionalAffectedDocuments.isEmpty() || this.allAffectedDocuments.size() > 1) {
            return null;
        }
        if (this.allAffectedDocuments.size() == 1 && (currentReference = this.allAffectedDocuments.iterator().next()) != reference) {
            return null;
        }
        return new LocalCommandMergerSnapshot(this.allAffectedDocuments.stream().findFirst().orElse(null), this.currentActions.snapshot(), this.lastGroupId, this.isTransparent(), this.commandName, this.editorStateBefore, this.editorStateAfter, this.undoConfirmationPolicy);
    }

    boolean resetLocalHistory(@NotNull LocalCommandMergerSnapshot snapshot2) {
        if (snapshot2 == null) {
            CommandMerger.$$$reportNull$$$0(9);
        }
        HashSet<DocumentReference> references = new HashSet<DocumentReference>();
        DocumentReference reference = snapshot2.getDocumentReferences();
        if (reference != null) {
            references.add(reference);
        }
        this.reset(snapshot2.getActions().toList(), references, new HashSet<DocumentReference>(), snapshot2.getLastGroupId(), false, snapshot2.getTransparent(), snapshot2.getCommandName(), true, snapshot2.getStateBefore(), snapshot2.getStateAfter(), snapshot2.getUndoConfirmationPolicy());
        return true;
    }

    void clearDocumentReferences(@NotNull Document document2) {
        if (document2 == null) {
            CommandMerger.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DocumentReference refByFile = DocumentReferenceManager.getInstance().create(document2);
        DocumentReferenceByDocument refByDoc = new DocumentReferenceByDocument(document2);
        this.currentActions.removeIf(action2 -> {
            Object[] refs = (DocumentReference[])ObjectUtils.notNull((Object)action2.getAffectedDocuments(), (Object)DocumentReference.EMPTY_ARRAY);
            return ContainerUtil.and((Object[])refs, ref2 -> ref2.equals((Object)refByDoc) || ref2.equals((Object)refByFile));
        });
        this.allAffectedDocuments.remove(refByFile);
        this.allAffectedDocuments.remove(refByDoc);
        this.additionalAffectedDocuments.remove(refByFile);
        this.additionalAffectedDocuments.remove(refByDoc);
    }

    void mergeUndoConfirmationPolicy(UndoConfirmationPolicy undoConfirmationPolicy) {
        if (this.undoConfirmationPolicy == UndoConfirmationPolicy.DEFAULT) {
            this.undoConfirmationPolicy = undoConfirmationPolicy;
        } else if (this.undoConfirmationPolicy == UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION && undoConfirmationPolicy == UndoConfirmationPolicy.REQUEST_CONFIRMATION) {
            this.undoConfirmationPolicy = UndoConfirmationPolicy.REQUEST_CONFIRMATION;
        }
    }

    boolean isPhysical() {
        if (this.allAffectedDocuments.isEmpty()) {
            return false;
        }
        for (DocumentReference each : this.allAffectedDocuments) {
            if (!CommandMerger.isVirtualDocumentChange(each.getFile())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    String getCommandName() {
        return this.commandName;
    }

    boolean isGlobal() {
        return this.isForcedGlobal || this.affectsMultiplePhysicalDocs();
    }

    void markAsGlobal() {
        this.isForcedGlobal = true;
    }

    boolean isTransparent() {
        if (this.isTransparentSupported) {
            return this.isTransparent;
        }
        return this.isTransparent && !this.hasActions();
    }

    @NotNull
    UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = this.undoConfirmationPolicy;
        if (undoConfirmationPolicy == null) {
            CommandMerger.$$$reportNull$$$0(11);
        }
        return undoConfirmationPolicy;
    }

    boolean hasActions() {
        return !this.currentActions.isEmpty();
    }

    @NotNull
    UndoRedoList<UndoableAction> getCurrentActions() {
        UndoRedoList<UndoableAction> undoRedoList = this.currentActions;
        if (undoRedoList == null) {
            CommandMerger.$$$reportNull$$$0(12);
        }
        return undoRedoList;
    }

    boolean isValid() {
        return this.isValid;
    }

    @NotNull
    Set<DocumentReference> getAllAffectedDocuments() {
        Set<DocumentReference> set = this.allAffectedDocuments;
        if (set == null) {
            CommandMerger.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    Set<DocumentReference> getAdditionalAffectedDocuments() {
        Set<DocumentReference> set = this.additionalAffectedDocuments;
        if (set == null) {
            CommandMerger.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    String dumpState() {
        String string = UndoDumpUnit.fromMerger(this).toString();
        if (string == null) {
            CommandMerger.$$$reportNull$$$0(15);
        }
        return string;
    }

    private void merge(@NotNull CommandMerger nextCommandToMerge) {
        if (nextCommandToMerge == null) {
            CommandMerger.$$$reportNull$$$0(16);
        }
        this.setEditorStateBefore(nextCommandToMerge.editorStateBefore);
        this.editorStateAfter = nextCommandToMerge.editorStateAfter;
        if (this.isTransparent()) {
            if (nextCommandToMerge.hasActions()) {
                this.isTransparent = nextCommandToMerge.isTransparent();
            }
        } else if (!this.hasActions()) {
            this.isTransparent = nextCommandToMerge.isTransparent();
        }
        this.isValid &= nextCommandToMerge.isValid;
        this.isForcedGlobal |= nextCommandToMerge.isForcedGlobal;
        this.currentActions.addAll((Collection<UndoableAction>)nextCommandToMerge.currentActions);
        this.allAffectedDocuments.addAll(nextCommandToMerge.allAffectedDocuments);
        this.additionalAffectedDocuments.addAll(nextCommandToMerge.additionalAffectedDocuments);
        this.mergeUndoConfirmationPolicy(nextCommandToMerge.getUndoConfirmationPolicy());
    }

    @NotNull
    private UndoCommandFlushReason createFlushReason(@NotNull String reason, @Nullable Object nextGroupId, @NotNull CommandMerger nextCommandToMerge) {
        if (reason == null) {
            CommandMerger.$$$reportNull$$$0(17);
        }
        if (nextCommandToMerge == null) {
            CommandMerger.$$$reportNull$$$0(18);
        }
        UndoCommandFlushReason undoCommandFlushReason = UndoCommandFlushReason.cannotMergeCommands(reason, this.commandName, SoftReference.dereference(this.lastGroupId), this.isTransparent(), this.isForcedGlobal, nextCommandToMerge.commandName, nextGroupId, nextCommandToMerge.isTransparent(), nextCommandToMerge.isForcedGlobal);
        if (undoCommandFlushReason == null) {
            CommandMerger.$$$reportNull$$$0(19);
        }
        return undoCommandFlushReason;
    }

    private void reset() {
        this.reset(new UndoRedoList<UndoableAction>(), new HashSet<DocumentReference>(), new HashSet<DocumentReference>(), null, false, false, null, true, null, null, UndoConfirmationPolicy.DEFAULT);
    }

    private void reset(UndoRedoList<UndoableAction> currentActions, HashSet<DocumentReference> allAffectedDocuments, HashSet<DocumentReference> additionalAffectedDocuments, Reference<Object> lastGroupId, boolean forcedGlobal, boolean transparent, @NlsContexts.Command String commandName, boolean isValid, EditorAndState editorStateBefore, EditorAndState editorStateAfter, UndoConfirmationPolicy undoConfirmationPolicy) {
        this.currentActions = currentActions;
        this.allAffectedDocuments = allAffectedDocuments;
        this.additionalAffectedDocuments = additionalAffectedDocuments;
        this.lastGroupId = lastGroupId;
        this.isForcedGlobal = forcedGlobal;
        this.isTransparent = transparent;
        this.commandName = commandName;
        this.isValid = isValid;
        this.editorStateAfter = editorStateAfter;
        this.editorStateBefore = editorStateBefore;
        this.undoConfirmationPolicy = undoConfirmationPolicy;
    }

    private boolean affectsMultiplePhysicalDocs() {
        HashSet<VirtualFile> affectedFiles = new HashSet<VirtualFile>();
        for (DocumentReference each : this.allAffectedDocuments) {
            VirtualFile file2 = each.getFile();
            if (CommandMerger.isVirtualDocumentChange(file2)) continue;
            affectedFiles.add(file2);
            if (affectedFiles.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonUndoableActions() {
        for (UndoableAction each : this.currentActions) {
            if (!(each instanceof NonUndoableAction)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMergeGlobalCommandsAllowed() {
        return ((CoreCommandProcessor)CommandProcessor.getInstance()).isMergeGlobalCommandsAllowed();
    }

    private static boolean isVirtualDocumentChange(VirtualFile file2) {
        return file2 == null || file2 instanceof LightVirtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextCommandMerger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoStacksHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flushReason";
                break;
            }
            case 5: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextCommandToMerge";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/CommandMerger";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/CommandMerger";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoConfirmationPolicy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAffectedDocuments";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalAffectedDocuments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createFlushReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUndoAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldFlush";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "flushCurrentCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commandFinished";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalAffectedDocuments";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActionsFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resetLocalHistory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clearDocumentReferences";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFlushReason";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14, 15, 19 -> new IllegalStateException(string);
        };
    }

    private static final class MyEmptyUndoableAction
    extends BasicUndoableAction {
        MyEmptyUndoableAction(DocumentReference @NotNull [] refs) {
            if (refs == null) {
                MyEmptyUndoableAction.$$$reportNull$$$0(0);
            }
            super(refs);
        }

        public void undo() {
        }

        public void redo() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/openapi/command/impl/CommandMerger$MyEmptyUndoableAction", "<init>"));
        }
    }
}

