/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.CaretStateTransferableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClipboardTextPerCaretSplitter {
    @NotNull
    public List<String> split(@NotNull String input, @Nullable CaretStateTransferableData caretData, int caretCount) {
        if (input == null) {
            ClipboardTextPerCaretSplitter.$$$reportNull$$$0(0);
        }
        if (caretCount <= 0) {
            throw new IllegalArgumentException("Caret count must be positive");
        }
        if (caretCount == 1) {
            List<String> list2 = Collections.singletonList(input);
            if (list2 == null) {
                ClipboardTextPerCaretSplitter.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<String> result2 = new ArrayList<String>(caretCount);
        if (caretData == null) {
            String[] lines = input.split("\n", -1);
            int sourceCaretCount = lines.length == 2 && lines[1].isEmpty() ? 1 : lines.length;
            for (int i2 = 0; i2 < caretCount; ++i2) {
                if (sourceCaretCount == 1) {
                    result2.add(lines[0]);
                    continue;
                }
                result2.add(i2 < lines.length ? lines[i2] : "");
            }
        } else {
            int sourceCaretCount = caretData.startOffsets.length;
            for (int i3 = 0; i3 < caretCount; ++i3) {
                if (sourceCaretCount == 1) {
                    result2.add(input);
                    continue;
                }
                result2.add(i3 < sourceCaretCount ? input.substring(caretData.startOffsets[i3], caretData.endOffsets[i3]) : "");
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ClipboardTextPerCaretSplitter.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ClipboardTextPerCaretSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ClipboardTextPerCaretSplitter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

