/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.CtrlYActionChooser;
import com.intellij.openapi.editor.actions.DocumentGuardedTextUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.TextRange;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DeleteLineAction
extends TextComponentEditorAction {
    public DeleteLineAction() {
        super((EditorActionHandler)new Handler());
    }

    private static TextRange getRangeToDelete(Editor editor2, Caret caret) {
        int endOffset;
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        int startOffset = EditorUtil.getNotFoldedLineStartOffset(editor2, selectionStart, true);
        if (selectionEnd > 0 && selectionEnd != selectionStart) {
            --selectionEnd;
        }
        if ((endOffset = EditorUtil.getNotFoldedLineEndOffset(editor2, selectionEnd, true)) < editor2.getDocument().getTextLength()) {
            ++endOffset;
        } else if (startOffset > 0) {
            --startOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    private static final class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            CommandProcessor.getInstance().setCurrentCommandGroupId(null);
            CopyPasteManager.getInstance().stopKillRings();
            List carets = caret == null ? editor2.getCaretModel().getAllCarets() : Collections.singletonList(caret);
            editor2.getCaretModel().runBatchCaretOperation(() -> {
                int[] caretColumns = new int[carets.size()];
                int caretIndex = carets.size() - 1;
                TextRange range = DeleteLineAction.getRangeToDelete(editor2, (Caret)carets.get(caretIndex));
                while (caretIndex >= 0) {
                    int currentCaretIndex = caretIndex;
                    TextRange currentRange = range;
                    while (--caretIndex >= 0 && (range = DeleteLineAction.getRangeToDelete(editor2, (Caret)carets.get(caretIndex))).getEndOffset() >= currentRange.getStartOffset()) {
                        currentRange = new TextRange(range.getStartOffset(), currentRange.getEndOffset());
                    }
                    for (int i2 = caretIndex + 1; i2 <= currentCaretIndex; ++i2) {
                        caretColumns[i2] = ((Caret)carets.get((int)i2)).getVisualPosition().column;
                    }
                    int targetLine = editor2.offsetToVisualPosition((int)currentRange.getStartOffset()).line;
                    DocumentGuardedTextUtil.deleteString(editor2.getDocument(), currentRange.getStartOffset(), currentRange.getEndOffset());
                    for (int i3 = caretIndex + 1; i3 <= currentCaretIndex; ++i3) {
                        ((Caret)carets.get(i3)).moveToVisualPosition(new VisualPosition(targetLine, caretColumns[i3]));
                    }
                }
            });
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/DeleteLineAction$Handler", "executeWriteAction"));
        }
    }

    public static final class CheckHandler
    extends EditorWriteActionHandler {
        private final EditorWriteActionHandler myOriginal;

        public CheckHandler(EditorActionHandler original) {
            this.myOriginal = (EditorWriteActionHandler)original;
        }

        public void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                CheckHandler.$$$reportNull$$$0(0);
            }
            if (CtrlYActionChooser.isCurrentShortcutOk(dataContext2)) {
                super.doExecute(editor2, caret, dataContext2);
            }
        }

        public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                CheckHandler.$$$reportNull$$$0(1);
            }
            this.myOriginal.executeWriteAction(editor2, caret, dataContext2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "editor";
            objectArray2[1] = "com/intellij/openapi/editor/actions/DeleteLineAction$CheckHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeWriteAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

