/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.ChangeEditorFontSizeStrategy;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.NlsActions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResetFontSizeActionBase
extends EditorAction
implements ActionRemoteBehaviorSpecification.Frontend {
    static final String UNSCALED_FONT_SIZE_TO_RESET_CONSOLE = "fontSizeToResetConsole";
    static final String UNSCALED_FONT_SIZE_TO_RESET_EDITOR = "fontSizeToResetEditor";
    public static final String PREVIOUS_COLOR_SCHEME = "previousColorScheme";
    private final boolean myGlobal;
    private static final Logger LOG = Logger.getInstance(ResetFontSizeActionBase.class);

    @ApiStatus.Internal
    public static Strategy getStrategy(EditorEx editor2, boolean forceGlobal) {
        if (editor2 instanceof EditorImpl) {
            ChangeEditorFontSizeStrategy customStrategy = (ChangeEditorFontSizeStrategy)editor2.getUserData(ChangeEditorFontSizeStrategy.KEY);
            if (customStrategy != null) {
                return new CustomStrategy(customStrategy);
            }
            if (forceGlobal) {
                return new AllEditorsStrategy(editor2);
            }
            if (UISettings.getInstance().getPresentationMode()) {
                return new PresentationModeStrategy();
            }
            if (EditorSettingsExternalizable.getInstance().isWheelFontChangePersistent()) {
                return new AllEditorsStrategy(editor2);
            }
        }
        return new SingleEditorStrategy(editor2);
    }

    ResetFontSizeActionBase(boolean forceGlobal) {
        super((EditorActionHandler)new MyHandler(forceGlobal));
        this.myGlobal = forceGlobal;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ResetFontSizeActionBase.$$$reportNull$$$0(0);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (e.getPlace().equals("popup") && editor2 != null) {
            if (!(editor2 instanceof EditorEx)) {
                return;
            }
            EditorEx editorEx = (EditorEx)editor2;
            Strategy strategy = ResetFontSizeActionBase.getStrategy(editorEx, this.myGlobal);
            float toReset = strategy.getFontSize();
            e.getPresentation().setText(strategy.getText(toReset));
            if (editor2 instanceof EditorImpl) {
                e.getPresentation().setEnabled(((EditorImpl)editor2).getFontSize2D() != toReset);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/actions/ResetFontSizeActionBase", "update"));
    }

    private static final class CustomStrategy
    implements Strategy {
        @NotNull
        private final ChangeEditorFontSizeStrategy myStrategy;

        private CustomStrategy(@NotNull ChangeEditorFontSizeStrategy strategy) {
            if (strategy == null) {
                CustomStrategy.$$$reportNull$$$0(0);
            }
            this.myStrategy = strategy;
        }

        @Override
        public float getFontSize() {
            return this.myStrategy.getDefaultFontSize();
        }

        @Override
        public void setFontSize(float fontSize) {
            this.myStrategy.setFontSize(fontSize);
        }

        @Override
        public String getText(float fontSize) {
            return this.myStrategy.getDefaultFontSizeText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/openapi/editor/actions/ResetFontSizeActionBase$CustomStrategy", "<init>"));
        }
    }

    private static final class AllEditorsStrategy
    implements Strategy {
        private final EditorEx myEditorEx;

        AllEditorsStrategy(EditorEx editorEx) {
            this.myEditorEx = editorEx;
        }

        @Override
        public float getFontSize() {
            return UISettingsUtils.getInstance().scaleFontSize(this.getUnscaledFontSize());
        }

        private float getUnscaledFontSize() {
            PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
            if (ConsoleViewUtil.isConsoleViewEditor(this.myEditorEx)) {
                return propertyComponent.getFloat(ResetFontSizeActionBase.UNSCALED_FONT_SIZE_TO_RESET_CONSOLE, -1.0f);
            }
            return propertyComponent.getFloat(ResetFontSizeActionBase.UNSCALED_FONT_SIZE_TO_RESET_EDITOR, -1.0f);
        }

        @Override
        public void reset() {
            this.setFontSize(this.getUnscaledFontSize());
        }

        @Override
        public void setFontSize(float fontSize) {
            EditorColorsManager.getInstance().getGlobalScheme().setEditorFontSize(fontSize);
            EditorColorsManagerImpl.fireGlobalSchemeChange(null);
        }

        @Override
        public String getText(float fontSize) {
            return IdeBundle.message((String)"action.reset.font.size.all.editors", (Object[])new Object[]{Float.valueOf(fontSize)});
        }
    }

    private static final class PresentationModeStrategy
    implements Strategy {
        private PresentationModeStrategy() {
        }

        @Override
        public float getFontSize() {
            return UISettingsUtils.getInstance().getPresentationModeFontSize();
        }

        @Override
        public void setFontSize(float fontSize) {
            int fs = (int)fontSize;
            for (Editor editor2 : EditorFactory.getInstance().getAllEditors()) {
                if (!(editor2 instanceof EditorEx)) continue;
                ((EditorEx)editor2).setFontSize(fs);
            }
        }

        @Override
        public String getText(float fontSize) {
            return IdeBundle.message((String)"action.reset.font.size", (Object[])new Object[]{Float.valueOf(fontSize)});
        }
    }

    private static final class SingleEditorStrategy
    implements Strategy {
        private final EditorEx myEditorEx;

        SingleEditorStrategy(EditorEx editorEx) {
            this.myEditorEx = editorEx;
        }

        @Override
        public float getFontSize() {
            UISettingsUtils uiSettings = UISettingsUtils.getInstance();
            return ConsoleViewUtil.isConsoleViewEditor(this.myEditorEx) ? uiSettings.getScaledConsoleFontSize() : uiSettings.getScaledEditorFontSize();
        }

        @Override
        public void setFontSize(float fontSize) {
            this.myEditorEx.setFontSize(fontSize);
        }

        @Override
        public String getText(float fontSize) {
            return IdeBundle.message((String)"action.reset.font.size", (Object[])new Object[]{Float.valueOf(fontSize)});
        }
    }

    private static final class MyHandler
    extends EditorActionHandler {
        private final boolean myGlobal;

        MyHandler(boolean forceGlobal) {
            this.myGlobal = forceGlobal;
        }

        public void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            if (!(editor2 instanceof EditorEx)) {
                return;
            }
            ResetFontSizeActionBase.getStrategy((EditorEx)editor2, this.myGlobal).reset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/ResetFontSizeActionBase$MyHandler", "doExecute"));
        }
    }

    @ApiStatus.Internal
    public static interface Strategy {
        public float getFontSize();

        public void setFontSize(float var1);

        @NlsActions.ActionText
        public String getText(float var1);

        default public void reset() {
            float size2 = this.getFontSize();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Resetting font size to %.2f. Strategy: %s", Float.valueOf(size2), this.getClass().getSimpleName()));
            }
            this.setFontSize(size2);
        }
    }
}

