/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorEmbeddedComponentManager {
    private static final Key<ComponentInlays> COMPONENT_INLAYS_KEY = Key.create((String)"editor.embedded.component.inlays");
    private static final int RESIZE_POINT_DELTA = JBUI.scale((int)5);
    private static final EditorEmbeddedComponentManager ourInstance = new EditorEmbeddedComponentManager();

    private EditorEmbeddedComponentManager() {
    }

    @NotNull
    public static EditorEmbeddedComponentManager getInstance() {
        EditorEmbeddedComponentManager editorEmbeddedComponentManager = ourInstance;
        if (editorEmbeddedComponentManager == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(0);
        }
        return editorEmbeddedComponentManager;
    }

    @Nullable
    public Inlay<?> addComponent(@NotNull EditorEx editor2, @NotNull JComponent component2, @NotNull Properties properties) {
        if (editor2 == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(1);
        }
        if (component2 == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ComponentInlays inlays = EditorEmbeddedComponentManager.getComponentInlaysFor(editor2);
        return inlays.add(component2, properties.resizePolicy, properties.rendererFactory, properties.relatesToPrecedingText, properties.showAbove, properties.showWhenFolded, properties.fullWidth, properties.priority, properties.offset);
    }

    @NotNull
    private static ComponentInlays getComponentInlaysFor(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(4);
        }
        if (!COMPONENT_INLAYS_KEY.isIn((UserDataHolder)editor2)) {
            COMPONENT_INLAYS_KEY.set((UserDataHolder)editor2, (Object)new ComponentInlays(editor2));
        }
        ComponentInlays componentInlays = (ComponentInlays)COMPONENT_INLAYS_KEY.get((UserDataHolder)editor2);
        if (componentInlays == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(5);
        }
        return componentInlays;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentInlaysFor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInlaysFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static final class ComponentInlays
    implements Disposable {
        private final EditorEx myEditor;
        private final ResizeListener myResizeListener;

        ComponentInlays(@NotNull EditorEx editor2) {
            if (editor2 == null) {
                ComponentInlays.$$$reportNull$$$0(0);
            }
            this.myEditor = editor2;
            this.myResizeListener = new ResizeListener();
            this.setup();
        }

        @Nullable
        Inlay<MyRenderer> add(@NotNull JComponent component2, @NotNull ResizePolicy policy, @Nullable Properties.RendererFactory rendererFactory, boolean relatesToPrecedingText, boolean showAbove, boolean showWhenFolded, boolean fullWidth, int priority, int offset) {
            if (component2 == null) {
                ComponentInlays.$$$reportNull$$$0(1);
            }
            if (policy == null) {
                ComponentInlays.$$$reportNull$$$0(2);
            }
            if (this.myEditor.isDisposed()) {
                return null;
            }
            MyRenderer renderer2 = fullWidth ? new FullEditorWidthRenderer(component2, policy, rendererFactory, this.myEditor.getScrollPane(), this.myResizeListener) : new MyRenderer(component2, policy, rendererFactory, this.myEditor.getScrollPane(), this.myResizeListener);
            Inlay inlay = this.myEditor.getInlayModel().addBlockElement(offset, new InlayProperties().relatesToPrecedingText(relatesToPrecedingText).showAbove(showAbove).priority(priority).showWhenFolded(showWhenFolded), (EditorCustomElementRenderer)renderer2);
            if (inlay == null) {
                return null;
            }
            Disposer.register((Disposable)this, (Disposable)inlay);
            renderer2.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Object object = e.getSource();
                    if (object instanceof MyRenderer) {
                        MyRenderer renderer2 = (MyRenderer)object;
                        this.revalidateComponents(renderer2.getBounds().y);
                    }
                }
            });
            renderer2.setInlay((Inlay<MyRenderer>)inlay);
            this.myEditor.getContentComponent().add(renderer2);
            Disposer.register((Disposable)inlay, () -> {
                Runnable runnable2 = () -> {
                    renderer2.setInlay(null);
                    this.myEditor.getContentComponent().remove(renderer2);
                };
                Application application = ApplicationManager.getApplication();
                if (application.isDispatchThread()) {
                    runnable2.run();
                } else {
                    application.invokeLater(runnable2);
                }
            });
            if (!this.myEditor.getInlayModel().isInBatchMode()) {
                renderer2.validate();
            }
            return inlay;
        }

        private void revalidateComponents() {
            this.revalidateComponents(Integer.MIN_VALUE);
        }

        private void revalidateComponents(int yTop) {
            JComponent parent = this.myEditor.getContentComponent();
            for (int i2 = 0; i2 < parent.getComponentCount(); ++i2) {
                Component component2 = parent.getComponent(i2);
                if (!(component2 instanceof MyRenderer) || component2.getY() < yTop) continue;
                component2.revalidate();
            }
        }

        private void setup() {
            Disposer.register((Disposable)((EditorImpl)this.myEditor).getDisposable(), (Disposable)this);
            this.myEditor.getFoldingModel().addListener(new FoldingListener(){

                @Override
                public void onFoldProcessingEnd() {
                    this.revalidateComponents();
                }
            }, this);
            this.myEditor.getDocument().addDocumentListener(new DocumentListener(){
                private int linesBefore;

                public void beforeDocumentChange(@NotNull DocumentEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.linesBefore = event.getDocument().getLineCount();
                }

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (this.linesBefore != event.getDocument().getLineCount() && !event.getDocument().isInBulkUpdate()) {
                        int y = myEditor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)event.getDocument().getLineNumber((int)event.getOffset()), (int)0)).y;
                        this.revalidateComponents(y);
                    }
                }

                public void bulkUpdateFinished(@NotNull Document document2) {
                    if (document2 == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    this.revalidateComponents();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "document";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeDocumentChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "documentChanged";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "bulkUpdateFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this);
            this.myEditor.getInlayModel().addListener((InlayModel.Listener)new InlayModel.SimpleAdapter(this){

                public void onUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
                    MyRenderer component2;
                    EditorCustomElementRenderer editorCustomElementRenderer;
                    if (inlay == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if ((changeFlags & 2) != 0 && (editorCustomElementRenderer = inlay.getRenderer()) instanceof MyRenderer && (component2 = (MyRenderer)editorCustomElementRenderer).isValid()) {
                        component2.revalidate();
                    }
                }

                public void onRemoved(@NotNull Inlay<?> inlay) {
                    if (inlay == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    Disposer.dispose(inlay);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "inlay";
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onUpdated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this);
            ComponentAdapter viewportListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.revalidateComponents();
                }
            };
            JViewport viewport = this.myEditor.getScrollPane().getViewport();
            viewport.addComponentListener(viewportListener);
            Disposer.register((Disposable)this, () -> viewport.removeComponentListener(viewportListener));
            this.myEditor.addEditorMouseListener(this.myResizeListener);
            this.myEditor.addEditorMouseMotionListener(this.myResizeListener);
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class ResizeListener
        implements EditorMouseListener,
        EditorMouseMotionListener {
            private ResizeInfo info;

            private ResizeListener() {
            }

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                ResizeInfo info;
                if (e == null) {
                    ResizeListener.$$$reportNull$$$0(0);
                }
                if ((info = this.getInfoForResizeUnder(e.getMouseEvent().getPoint())) == null) {
                    this.resetCursor();
                    return;
                }
                ComponentInlays.this.myEditor.setCustomCursor(ComponentInlays.this, info.direction.cursor);
            }

            public void mousePressed(EditorMouseEvent event) {
                Point point = event.getMouseEvent().getPoint();
                this.info = this.getInfoForResizeUnder(point);
                if (this.info == null) {
                    return;
                }
                event.consume();
            }

            public void mouseReleased(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    ResizeListener.$$$reportNull$$$0(1);
                }
                if (this.info != null) {
                    ((MyRenderer)this.info.inlay.getRenderer()).revalidate();
                    this.info = null;
                }
                this.resetCursor();
            }

            public void mouseDragged(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    ResizeListener.$$$reportNull$$$0(2);
                }
                if (this.info == null) {
                    return;
                }
                Point currentPoint = event.getMouseEvent().getPoint();
                MyRenderer renderer2 = (MyRenderer)this.info.inlay.getRenderer();
                int xDelta = this.info.direction.xMultiplier * (currentPoint.x - renderer2.getX() - renderer2.getWidth());
                int yDelta = this.info.direction.yMultiplier * (currentPoint.y - renderer2.getY() - renderer2.getHeight());
                Dimension size2 = renderer2.getSize();
                int newWidth = Math.max(Math.max(((MyRenderer)this.info.inlay.getRenderer()).getMinimumSize().width, size2.width + xDelta), 0);
                int newHeight = Math.max(Math.max(((MyRenderer)this.info.inlay.getRenderer()).getMinimumSize().height, size2.height + yDelta), 0);
                renderer2.setCustomWidth(newWidth);
                renderer2.setCustomHeight(newHeight);
                renderer2.setSize(newWidth, newHeight);
                renderer2.revalidate();
                renderer2.repaint(50L);
                this.scrollTo(renderer2.getBounds());
                event.consume();
            }

            public void mouseExited(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    ResizeListener.$$$reportNull$$$0(3);
                }
                this.resetCursor();
            }

            boolean isResizeInProgress(@NotNull MyRenderer wrapper2) {
                if (wrapper2 == null) {
                    ResizeListener.$$$reportNull$$$0(4);
                }
                return this.info != null && wrapper2 == this.info.inlay.getRenderer();
            }

            private void scrollTo(@NotNull Rectangle inlayBounds) {
                if (inlayBounds == null) {
                    ResizeListener.$$$reportNull$$$0(5);
                }
                Rectangle contentComponentBounds = ComponentInlays.this.myEditor.getScrollPane().getViewport().getViewRect();
                int compMinX = contentComponentBounds.x;
                int compMaxX = compMinX + contentComponentBounds.width;
                int compMinY = contentComponentBounds.y;
                int compMaxY = compMinY + contentComponentBounds.height;
                int inlayMaxX = inlayBounds.x + inlayBounds.width;
                int inlayMaxY = inlayBounds.y + inlayBounds.height;
                JScrollBar hsb = ComponentInlays.this.myEditor.getScrollPane().getHorizontalScrollBar();
                JScrollBar vsb = ComponentInlays.this.myEditor.getScrollPane().getVerticalScrollBar();
                int hsbNewValue = hsb.getValue() + this.info.direction.xMultiplier * (inlayMaxX > compMaxX ? inlayMaxX - compMaxX : (inlayMaxX < compMinX ? inlayMaxX - compMinX : 0));
                int vsbNewValue = vsb.getValue() + this.info.direction.yMultiplier * (inlayMaxY > compMaxY ? inlayMaxY - compMaxY : (inlayMaxY < compMinY ? inlayMaxY - compMinY : 0));
                hsb.setValue(Math.max(0, hsbNewValue));
                vsb.setValue(Math.max(0, vsbNewValue));
            }

            private void resetCursor() {
                if (this.info == null) {
                    ComponentInlays.this.myEditor.setCustomCursor(ComponentInlays.this, null);
                }
            }

            @Nullable
            private ResizeInfo getInfoForResizeUnder(@NotNull Point point) {
                if (point == null) {
                    ResizeListener.$$$reportNull$$$0(6);
                }
                return (ResizeInfo)ContainerUtil.getFirstItem((List)ContainerUtil.mapNotNull((Object[])ComponentInlays.this.myEditor.getContentComponent().getComponents(), component2 -> {
                    boolean dragFromRight;
                    if (!(component2 instanceof MyRenderer)) {
                        return null;
                    }
                    ResizePolicy policy = ((MyRenderer)component2).resizePolicy;
                    if (!policy.isResizable()) {
                        return null;
                    }
                    Inlay<MyRenderer> inlay = ((MyRenderer)component2).myInlay;
                    if (inlay == null) {
                        return null;
                    }
                    Rectangle bounds = inlay.getBounds();
                    if (bounds == null) {
                        return null;
                    }
                    int pressY = point.y;
                    int pressX = point.x;
                    int inlayTY = bounds.y;
                    int inlayLX = bounds.x;
                    int inlayBY = bounds.y + bounds.height;
                    int inlayRX = bounds.x + bounds.width;
                    boolean dragFromBottom = policy.isResizableFromBottom() && ResizeListener.isInside(pressX, inlayLX, inlayRX) && ResizeListener.isNearTo(pressY, inlayBY);
                    boolean bl = dragFromRight = policy.isResizableFromRight() && ResizeListener.isInside(pressY, inlayTY, inlayBY) && ResizeListener.isNearTo(pressX, inlayRX);
                    ResizeDirection direction = dragFromBottom && dragFromRight ? ResizeDirection.BOTTOM_RIGHT : (dragFromBottom ? ResizeDirection.BOTTOM : (dragFromRight ? ResizeDirection.RIGHT : null));
                    return direction == null ? null : new ResizeInfo(inlay, direction);
                }));
            }

            private static boolean isNearTo(int value, int coordinate) {
                return ResizeListener.isInside(value, coordinate, coordinate);
            }

            private static boolean isInside(int value, int min, int max) {
                return value > min - RESIZE_POINT_DELTA && value < max + RESIZE_POINT_DELTA;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wrapper";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inlayBounds";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "point";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays$ResizeListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseMoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseDragged";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isResizeInProgress";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "scrollTo";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getInfoForResizeUnder";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static enum ResizeDirection {
            BOTTOM(0, 1, Cursor.getPredefinedCursor(9)),
            RIGHT(1, 0, Cursor.getPredefinedCursor(11)),
            BOTTOM_RIGHT(1, 1, Cursor.getPredefinedCursor(5));

            final int xMultiplier;
            final int yMultiplier;
            final Cursor cursor;

            private ResizeDirection(@NotNull int xMultiplier, int yMultiplier, Cursor cursor) {
                if (cursor == null) {
                    ResizeDirection.$$$reportNull$$$0(0);
                }
                this.xMultiplier = xMultiplier;
                this.yMultiplier = yMultiplier;
                this.cursor = cursor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cursor", "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays$ResizeDirection", "<init>"));
            }
        }

        private static final class ResizeInfo {
            final Inlay<? extends MyRenderer> inlay;
            final ResizeDirection direction;
            final int startWidth;

            ResizeInfo(@NotNull Inlay<? extends MyRenderer> inlay, @NotNull ResizeDirection direction) {
                if (inlay == null) {
                    ResizeInfo.$$$reportNull$$$0(0);
                }
                if (direction == null) {
                    ResizeInfo.$$$reportNull$$$0(1);
                }
                this.inlay = inlay;
                this.direction = direction;
                this.startWidth = ((MyRenderer)inlay.getRenderer()).getWidth();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "inlay";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "direction";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays$ResizeInfo";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static final class Properties {
        final ResizePolicy resizePolicy;
        final RendererFactory rendererFactory;
        final boolean relatesToPrecedingText;
        final boolean showAbove;
        final boolean showWhenFolded;
        final boolean fullWidth;
        final int priority;
        final int offset;

        public Properties(@NotNull ResizePolicy resizePolicy, @Nullable RendererFactory rendererFactory, boolean relatesToPrecedingText, boolean showAbove, int priority, int offset) {
            if (resizePolicy == null) {
                Properties.$$$reportNull$$$0(0);
            }
            this(resizePolicy, rendererFactory, relatesToPrecedingText, showAbove, false, false, priority, offset);
        }

        public Properties(@NotNull ResizePolicy resizePolicy, @Nullable RendererFactory rendererFactory, boolean relatesToPrecedingText, boolean showAbove, boolean showWhenFolded, int priority, int offset) {
            if (resizePolicy == null) {
                Properties.$$$reportNull$$$0(1);
            }
            this(resizePolicy, rendererFactory, relatesToPrecedingText, showAbove, false, false, priority, offset);
        }

        public Properties(@NotNull ResizePolicy resizePolicy, @Nullable RendererFactory rendererFactory, boolean relatesToPrecedingText, boolean showAbove, boolean showWhenFolded, boolean fullWidth, int priority, int offset) {
            if (resizePolicy == null) {
                Properties.$$$reportNull$$$0(2);
            }
            this.resizePolicy = resizePolicy;
            this.rendererFactory = rendererFactory;
            this.relatesToPrecedingText = relatesToPrecedingText;
            this.showAbove = showAbove;
            this.showWhenFolded = showWhenFolded;
            this.fullWidth = fullWidth;
            this.priority = priority;
            this.offset = offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resizePolicy", "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$Properties", "<init>"));
        }

        public static interface RendererFactory {
            @Nullable
            public GutterIconRenderer createRenderer(@NotNull Inlay<?> var1);
        }
    }

    public static final class ResizePolicy {
        private static final int RIGHT = 2;
        private static final int BOTTOM = 4;
        private static final ResizePolicy ourAny = new ResizePolicy(6);
        private static final ResizePolicy ourNone = new ResizePolicy(0);
        private final int myFlags;

        private ResizePolicy(int flags) {
            this.myFlags = flags;
        }

        public boolean isResizable() {
            return this.isResizableFromRight() || this.isResizableFromBottom();
        }

        public static ResizePolicy any() {
            return ourAny;
        }

        @NotNull
        public static ResizePolicy none() {
            ResizePolicy resizePolicy = ourNone;
            if (resizePolicy == null) {
                ResizePolicy.$$$reportNull$$$0(0);
            }
            return resizePolicy;
        }

        public boolean isResizableFromRight() {
            return (this.myFlags & 2) != 0;
        }

        public boolean isResizableFromBottom() {
            return (this.myFlags & 4) != 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ResizePolicy", "none"));
        }
    }

    @ApiStatus.Internal
    public static final class FullEditorWidthRenderer
    extends MyRenderer {
        FullEditorWidthRenderer(@NotNull JComponent component2, @NotNull ResizePolicy resizePolicy, @Nullable Properties.RendererFactory rendererFactory, @NotNull JScrollPane editorScrollPane, @NotNull ComponentInlays.ResizeListener resizeListener2) {
            if (component2 == null) {
                FullEditorWidthRenderer.$$$reportNull$$$0(0);
            }
            if (resizePolicy == null) {
                FullEditorWidthRenderer.$$$reportNull$$$0(1);
            }
            if (editorScrollPane == null) {
                FullEditorWidthRenderer.$$$reportNull$$$0(2);
            }
            super(component2, resizePolicy, rendererFactory, editorScrollPane, resizeListener2);
        }

        @Override
        int getPreferredWidth() {
            return this.myEditorScrollPane.getViewport().getWidth() - this.myEditorScrollPane.getVerticalScrollBar().getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resizePolicy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editorScrollPane";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$FullEditorWidthRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class MyRenderer
    extends JPanel
    implements EditorCustomElementRenderer {
        private static final int UNDEFINED = -1;
        final ResizePolicy resizePolicy;
        private final Properties.RendererFactory myRendererFactory;
        private int myCustomWidth;
        private int myCustomHeight;
        @NotNull
        protected final JScrollPane myEditorScrollPane;
        @NotNull
        private final ComponentInlays.ResizeListener myResizeListener;
        @Nullable
        private Inlay<MyRenderer> myInlay;

        MyRenderer(@NotNull JComponent component2, @NotNull ResizePolicy resizePolicy, @Nullable Properties.RendererFactory rendererFactory, @NotNull JScrollPane editorScrollPane, @NotNull ComponentInlays.ResizeListener resizeListener2) {
            if (component2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (resizePolicy == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            if (editorScrollPane == null) {
                MyRenderer.$$$reportNull$$$0(2);
            }
            if (resizeListener2 == null) {
                MyRenderer.$$$reportNull$$$0(3);
            }
            super(new BorderLayout());
            this.myCustomWidth = -1;
            this.myCustomHeight = -1;
            this.resizePolicy = resizePolicy;
            this.myRendererFactory = rendererFactory;
            this.myEditorScrollPane = editorScrollPane;
            this.myResizeListener = resizeListener2;
            this.add((Component)component2, "Center");
            this.setOpaque(false);
        }

        @Nullable
        public GutterIconRenderer calcGutterIconRenderer(@NotNull Inlay inlay) {
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(4);
            }
            return this.myRendererFactory == null ? null : this.myRendererFactory.createRenderer(inlay);
        }

        void setCustomWidth(int customWidth) {
            if (customWidth != this.getPreferredWidth()) {
                this.myCustomWidth = customWidth;
            }
        }

        void setCustomHeight(int customHeight) {
            if (customHeight != this.getPreferredHeight()) {
                this.myCustomHeight = customHeight;
            }
        }

        int getPreferredWidth() {
            return this.isWidthSet() ? this.myCustomWidth : this.getPreferredSize().width;
        }

        int getPreferredHeight() {
            return this.myCustomHeight == -1 ? this.getPreferredSize().height : this.myCustomHeight;
        }

        boolean isWidthSet() {
            return this.myCustomWidth != -1;
        }

        public int calcHeightInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(5);
            }
            return Math.max(this.getPreferredHeight(), 0);
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(6);
            }
            return Math.max(this.getWidth(), 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite old = g2d.getComposite();
            try {
                g2d.setComposite(AlphaComposite.SrcOver);
                super.paint(g);
            }
            finally {
                g2d.setComposite(old);
            }
        }

        @Override
        public void doLayout() {
            ReadAction.run(() -> {
                this.synchronizeBoundsWithInlay();
                super.doLayout();
            });
        }

        @Override
        public void validate() {
            this.synchronizeBoundsWithInlay();
            super.validate();
        }

        private void synchronizeBoundsWithInlay() {
            if (this.myInlay != null && !this.myResizeListener.isResizeInProgress(this) && !this.myInlay.getEditor().getDocument().isInBulkUpdate()) {
                boolean shouldUpdateInlay;
                Rectangle inlayBounds = this.myInlay.getBounds();
                if (inlayBounds != null) {
                    inlayBounds.setLocation(inlayBounds.x + this.verticalScrollbarLeftShift(), inlayBounds.y);
                    int visibleWidth = this.myEditorScrollPane.getViewport().getWidth() - this.myEditorScrollPane.getVerticalScrollBar().getWidth();
                    Rectangle newBounds = new Rectangle(inlayBounds.x, inlayBounds.y, this.isWidthSet() ? this.myCustomWidth : Math.min(this.getPreferredWidth(), visibleWidth), this.getPreferredHeight());
                    boolean bl = shouldUpdateInlay = !this.isVisible() || !newBounds.equals(inlayBounds);
                    if (shouldUpdateInlay || !newBounds.equals(this.getBounds())) {
                        this.setVisible(true);
                        this.setBounds(newBounds);
                    }
                } else {
                    shouldUpdateInlay = this.isVisible();
                    this.setVisible(false);
                }
                if (shouldUpdateInlay) {
                    this.myInlay.update();
                }
            }
        }

        public void setInlay(@Nullable Inlay<MyRenderer> inlay) {
            this.myInlay = inlay;
        }

        private int verticalScrollbarLeftShift() {
            Object flipProperty = this.myEditorScrollPane.getClientProperty(JBScrollPane.Flip.class);
            if (flipProperty == JBScrollPane.Flip.HORIZONTAL || flipProperty == JBScrollPane.Flip.BOTH) {
                return this.myEditorScrollPane.getVerticalScrollBar().getWidth();
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resizePolicy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editorScrollPane";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resizeListener";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$MyRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcGutterIconRenderer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcHeightInPixels";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

