/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
public final class EditorMouseHoverPopupControl {
    private static final Logger LOG = Logger.getInstance(EditorMouseHoverPopupControl.class);
    private static final Key<Integer> MOUSE_TRACKING_DISABLED_COUNT = Key.create((String)"MOUSE_TRACKING_DISABLED_COUNT");
    private final Collection<BiConsumer<@NotNull UserDataHolder, Boolean>> listeners = new CopyOnWriteArrayList<BiConsumer<UserDataHolder, Boolean>>();

    public static EditorMouseHoverPopupControl getInstance() {
        return (EditorMouseHoverPopupControl)ApplicationManager.getApplication().getService(EditorMouseHoverPopupControl.class);
    }

    public static void disablePopups(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(0);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)editor2, true);
    }

    public static void enablePopups(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(1);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)editor2, false);
    }

    public static void disablePopups(@NotNull Document document2) {
        if (document2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(2);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)document2, true);
    }

    public static void enablePopups(@NotNull Document document2) {
        if (document2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(3);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)document2, false);
    }

    public static void disablePopups(@NotNull Project project2) {
        if (project2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(4);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)project2, true);
    }

    public static void enablePopups(@NotNull Project project2) {
        if (project2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(5);
        }
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)project2, false);
    }

    private static void setTrackingDisabled(@NotNull UserDataHolder holder, boolean value) {
        EditorMouseHoverPopupControl instance;
        if (holder == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Integer userData = (Integer)holder.getUserData(MOUSE_TRACKING_DISABLED_COUNT);
        int count = (userData == null ? 0 : userData) + (value ? 1 : -1);
        if (count < 0) {
            LOG.warn((Throwable)new IllegalStateException("Editor mouse hover popups weren't disabled previously"));
            count = 0;
        }
        holder.putUserData(MOUSE_TRACKING_DISABLED_COUNT, (Object)(count == 0 ? null : Integer.valueOf(count)));
        if (userData == null != (count == 0) && (instance = EditorMouseHoverPopupControl.getInstance()) != null) {
            instance.listeners.forEach(listener2 -> listener2.accept(holder, value));
        }
    }

    public static boolean arePopupsDisabled(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Project project2 = editor2.getProject();
        return editor2.getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null || editor2.getDocument().getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null || project2 != null && project2.getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null;
    }

    public void addListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(8);
        }
        this.listeners.add((holder, isDisabled) -> listener2.run());
    }

    @ApiStatus.Internal
    public void addListener(@NotNull @NotNull BiConsumer<@NotNull UserDataHolder, Boolean> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            EditorMouseHoverPopupControl.$$$reportNull$$$0(10);
        }
        this.listeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.listeners.remove(listener2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMouseHoverPopupControl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "disablePopups";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enablePopups";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setTrackingDisabled";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "arePopupsDisabled";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

