/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.FontFallbackIterator;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.EditorPainter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.paint.LinePainter2D;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J,\u0010\f\u001a\u00020\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001f\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/editor/impl/InputMethodInlayRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "paint", "", "g", "Ljava/awt/Graphics2D;", "targetRegion", "Ljava/awt/geom/Rectangle2D;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getFontIterator", "Lcom/intellij/openapi/editor/impl/FontFallbackIterator;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fontStyle", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;)Lcom/intellij/openapi/editor/impl/FontFallbackIterator;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class InputMethodInlayRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private final String text;

    public InputMethodInlayRenderer(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.text = text2;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        FontFallbackIterator iterator = this.getFontIterator(editor2, null);
        iterator.start(this.text, 0, this.text.length());
        double result2 = 0.0;
        while (!iterator.atEnd()) {
            Font font;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.getFont(), (String)"getFont(...)");
            result2 += font.getStringBounds(this.text, iterator.getStart(), iterator.getEnd(), iterator.getFontInfo().getFontRenderContext()).getWidth();
            iterator.advance();
        }
        return MathKt.roundToInt((double)result2);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics2D g, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        g.setColor(textAttributes.getForegroundColor());
        FontFallbackIterator iterator = this.getFontIterator(editor3, textAttributes.getFontType());
        double currentX = targetRegion.getX();
        double y = targetRegion.getY() + (double)editor3.getAscent();
        iterator.start(this.text, 0, this.text.length());
        while (!iterator.atEnd()) {
            String subText;
            Intrinsics.checkNotNullExpressionValue((Object)this.text.substring(iterator.getStart(), iterator.getEnd()), (String)"substring(...)");
            g.setFont(iterator.getFont());
            g.drawString(subText, (float)currentX, (float)y);
            FontMetrics metrics = iterator.getFontInfo().fontMetrics();
            currentX += metrics.getStringBounds(subText, g).getWidth();
            iterator.advance();
        }
        double lineY = y + 1.0;
        g.setStroke(EditorPainter.IME_COMPOSED_TEXT_UNDERLINE_STROKE);
        g.setColor(editor3.getColorsScheme().getDefaultForeground());
        LinePainter2D.paint((Graphics2D)g, (double)targetRegion.getMinX(), (double)lineY, (double)targetRegion.getMaxX(), (double)lineY);
    }

    private final FontFallbackIterator getFontIterator(Editor editor2, Integer fontStyle) {
        Integer n = fontStyle;
        FontFallbackIterator fontFallbackIterator = new FontFallbackIterator().setPreferredFonts(editor2.getColorsScheme().getFontPreferences()).setFontStyle(n != null ? n : 0).setFontRenderContext(FontInfo.getFontRenderContext(editor2.getContentComponent()));
        Intrinsics.checkNotNullExpressionValue((Object)fontFallbackIterator, (String)"setFontRenderContext(...)");
        return fontFallbackIterator;
    }
}

