/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.impl.NativeFileChooserDialogImpl;
import com.intellij.openapi.fileChooser.impl.NewFileChooserDialogImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FileChooserUsageCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ui.file.chooser", 4);
    private static final EnumEventField<Type> TYPE = EventFields.Enum((String)"type", Type.class);
    private static final BooleanEventField FORCED = EventFields.Boolean((String)"forced");
    private static final BooleanEventField JAR_CONTENTS = EventFields.Boolean((String)"jar_contents");
    private static final BooleanEventField NON_LOCAL_ROOTS = EventFields.Boolean((String)"non_local_roots");
    private static final BooleanEventField EXT_FILTER = EventFields.Boolean((String)"ext_filter");
    private static final BooleanEventField FILE_FILTER = EventFields.Boolean((String)"file_filter");
    private static final BooleanEventField NON_LOCAL_FILES = EventFields.Boolean((String)"non_local_files");
    private static final VarargEventId CHOOSER_SHOWN = GROUP.registerVarargEvent("chooser_shown", new EventField[]{TYPE, FORCED, JAR_CONTENTS, NON_LOCAL_ROOTS, EXT_FILTER, FILE_FILTER, NON_LOCAL_FILES});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void log(FileChooserDialog chooser, FileChooserDescriptor descriptor, VirtualFile[] files2) {
        String filter2 = Objects.requireNonNullElse((String)descriptor.getUserData(FileChooserDescriptor.FILTER_TYPE), "");
        CHOOSER_SHOWN.log(new EventPair[]{TYPE.with((Object)FileChooserUsageCollector.chooserType(chooser)), FORCED.with((Object)descriptor.isForcedToUseIdeaFileChooser()), JAR_CONTENTS.with((Object)descriptor.isChooseJarContents()), NON_LOCAL_ROOTS.with((Object)ContainerUtil.exists((Iterable)descriptor.getRoots(), root -> !root.isInLocalFileSystem())), EXT_FILTER.with((Object)(filter2.indexOf(101) != 0 ? 1 : 0)), FILE_FILTER.with((Object)(filter2.indexOf(102) != 0 ? 1 : 0)), NON_LOCAL_FILES.with((Object)ContainerUtil.exists((Object[])files2, file2 -> !file2.isInLocalFileSystem()))});
    }

    private static Type chooserType(FileChooserDialog chooser) {
        return chooser instanceof NativeFileChooserDialogImpl ? Type.NATIVE : (chooser instanceof NewFileChooserDialogImpl ? Type.NEW : (chooser instanceof FileChooserDialogImpl ? Type.CLASSIC : Type.OTHER));
    }

    private static enum Type {
        NATIVE,
        CLASSIC,
        NEW,
        OTHER;

    }
}

