/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorEmptyTextPainter {
    public void paintEmptyText(@NotNull JComponent splitters2, @NotNull Graphics g) {
        if (splitters2 == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(0);
        }
        if (g == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(1);
        }
        if (JBUI.getInt((String)"Islands", (int)0) != 1) {
            this.doPaintEmptyText(splitters2, g);
        }
    }

    @ApiStatus.Internal
    public void doPaintEmptyText(@NotNull JComponent splitters2, @NotNull Graphics g) {
        if (splitters2 == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(2);
        }
        if (g == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(3);
        }
        if (!EditorEmptyTextPainter.isEnabled()) {
            return;
        }
        UISettings.setupAntialiasing((Graphics)g);
        UIUtil.TextPainter painter = EditorEmptyTextPainter.createTextPainter();
        this.advertiseActions(splitters2, painter);
        painter.draw(g, (width, height) -> {
            Dimension s = splitters2.getSize();
            int w = (s.width - width) / 2;
            int h = (int)((double)s.height * this.heightRatio());
            return Couple.of((Object)w, (Object)h);
        });
    }

    protected double heightRatio() {
        return 0.375;
    }

    protected void advertiseActions(@NotNull JComponent splitters2, @NotNull UIUtil.TextPainter painter) {
        if (splitters2 == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(4);
        }
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(5);
        }
        this.appendSearchEverywhere(painter);
        this.appendToolWindow(painter, IdeBundle.message((String)"empty.text.project.view", (Object[])new Object[0]), "Project", splitters2);
        this.appendAction(painter, IdeBundle.message((String)"empty.text.go.to.file", (Object[])new Object[0]), this.getActionShortcutText("GotoFile"));
        this.appendAction(painter, IdeBundle.message((String)"empty.text.recent.files", (Object[])new Object[0]), this.getActionShortcutText("RecentFiles"));
        this.appendAction(painter, IdeBundle.message((String)"empty.text.navigation.bar", (Object[])new Object[0]), this.getActionShortcutText("ShowNavBar"));
        this.appendDnd(painter);
    }

    protected void appendDnd(@NotNull UIUtil.TextPainter painter) {
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(6);
        }
        this.appendLine(painter, IdeBundle.message((String)"empty.text.drop.files.to.open", (Object[])new Object[0]));
    }

    protected void appendSearchEverywhere(@NotNull UIUtil.TextPainter painter) {
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(7);
        }
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"SearchEverywhere").getShortcuts();
        String message = IdeBundle.message((String)"double.ctrl.or.shift.shortcut", (Object[])new Object[]{SystemInfo.isMac ? "\u21e7" : "Shift"});
        this.appendAction(painter, IdeBundle.message((String)"empty.text.search.everywhere", (Object[])new Object[0]), shortcuts.length == 0 ? message : KeymapUtil.getShortcutsText((Shortcut[])shortcuts));
    }

    protected void appendToolWindow(@NotNull UIUtil.TextPainter painter, @NotNull @Nls String action2, @NotNull String toolWindowId, @NotNull JComponent splitters2) {
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(8);
        }
        if (action2 == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(9);
        }
        if (toolWindowId == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(10);
        }
        if (splitters2 == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(11);
        }
        if (!EditorEmptyTextPainter.isToolwindowVisible(splitters2, toolWindowId)) {
            String activateActionId = ActivateToolWindowAction.Manager.getActionIdForToolWindow(toolWindowId);
            this.appendAction(painter, action2, this.getActionShortcutText(activateActionId));
        }
    }

    protected void appendAction(@NotNull UIUtil.TextPainter painter, @NotNull @Nls String action2, @Nullable String shortcut) {
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(12);
        }
        if (action2 == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(13);
        }
        if (Strings.isEmpty((String)shortcut)) {
            return;
        }
        this.appendLine(painter, action2 + " <shortcut>" + shortcut + "</shortcut>");
    }

    protected void appendLine(@NotNull UIUtil.TextPainter painter, @NotNull String line) {
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(14);
        }
        if (line == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(15);
        }
        painter.appendLine(line);
    }

    @NotNull
    protected String getActionShortcutText(@NonNls @NotNull String actionId) {
        if (actionId == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(16);
        }
        String string = KeymapUtil.getFirstKeyboardShortcutText((String)actionId);
        if (string == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(17);
        }
        return string;
    }

    protected static boolean isToolwindowVisible(@NotNull JComponent splitters2, @NotNull String toolwindowId) {
        Project project2;
        if (splitters2 == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(18);
        }
        if (toolwindowId == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(19);
        }
        if ((project2 = ProjectUtil.getProjectForComponent(splitters2)) != null) {
            if (!project2.isInitialized()) {
                return true;
            }
            ToolWindow toolWindow2 = ToolWindowManager.getInstance((Project)project2).getToolWindow(toolwindowId);
            return toolWindow2 != null && toolWindow2.isVisible();
        }
        return false;
    }

    @NotNull
    public static UIUtil.TextPainter createTextPainter() {
        UIUtil.TextPainter textPainter = new UIUtil.TextPainter().withLineSpacing(1.8f).withColor((Color)JBColor.namedColor((String)"Editor.foreground", (Color)new JBColor((Color)Gray._80, (Color)Gray._160))).withFont((Font)JBUI.Fonts.label((float)16.0f));
        if (textPainter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(20);
        }
        return textPainter;
    }

    static boolean isEnabled() {
        return Registry.is((String)"editor.paint.empty.text", (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolwindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionShortcutText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextPainter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintEmptyText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doPaintEmptyText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "advertiseActions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendDnd";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendSearchEverywhere";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendToolWindow";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendAction";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendLine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getActionShortcutText";
                break;
            }
            case 17: 
            case 20: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isToolwindowVisible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 20 -> new IllegalStateException(string);
        };
    }
}

