/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.browsers.actions.WebPreviewFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.HTMLFileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.jcef.JBCefApp;
import java.io.InputStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0004\u0015\u0016\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "disposeEditor", "", "editor", "accept", "", "acceptRequiresReadAction", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "Companion", "Request", "JsQueryHandler", "ResourceHandler", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHTMLEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTMLEditorProvider.kt\ncom/intellij/openapi/fileEditor/impl/HTMLEditorProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class HTMLEditorProvider
implements FileEditorProvider,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Request> REQUEST_KEY;
    @NotNull
    private static final Key<FileEditor> EDITOR_KEY;
    @NotNull
    public static final String JS_FUNCTION_NAME = "jbCefQuery";

    @ApiStatus.Internal
    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileEditor fileEditor = (FileEditor)file2.getUserData(EDITOR_KEY);
        if (fileEditor == null) {
            HTMLFileEditor hTMLFileEditor;
            LightVirtualFile lightVirtualFile = (LightVirtualFile)file2;
            Object object = REQUEST_KEY.get((UserDataHolder)file2);
            Intrinsics.checkNotNull((Object)object);
            HTMLFileEditor it = hTMLFileEditor = new HTMLFileEditor(project2, lightVirtualFile, (Request)object);
            boolean bl = false;
            file2.putUserData(EDITOR_KEY, (Object)it);
            fileEditor = hTMLFileEditor;
        }
        return fileEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void disposeEditor(@NotNull FileEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        try {
            VirtualFile virtualFile = editor2.getFile();
            if (virtualFile != null) {
                VirtualFile file2 = virtualFile;
                boolean bl = false;
                file2.putUserData(EDITOR_KEY, null);
                file2.putUserData(REQUEST_KEY, null);
            }
        }
        finally {
            super.disposeEditor(editor2);
        }
    }

    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return JBCefApp.isSupported() && file2.getUserData(REQUEST_KEY) != null;
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public String getEditorTypeId() {
        return "html-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @JvmStatic
    public static final void openEditor(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title2, @NotNull String html) {
        Companion.openEditor(project2, title2, html);
    }

    @JvmStatic
    public static final void openEditor(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title2, @NotNull String url, @Nullable String timeoutHtml) {
        Companion.openEditor(project2, title2, url, timeoutHtml);
    }

    @JvmStatic
    @Nullable
    public static final FileEditor openEditor(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title2, @NotNull Request request) {
        return Companion.openEditor(project2, title2, request);
    }

    @JvmStatic
    @Nullable
    public static final FileEditor openEditor(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title2, @NotNull Request request, @NotNull FileType fileType2) {
        return Companion.openEditor(project2, title2, request, fileType2);
    }

    static {
        Key key = Key.create((String)"html.editor.request.key");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        REQUEST_KEY = key;
        Key key2 = Key.create((String)"html.editor.component.key");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        EDITOR_KEY = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0007J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0007J$\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0006H\u0007J,\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Companion;", "", "<init>", "()V", "REQUEST_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Request;", "EDITOR_KEY", "Lcom/intellij/openapi/fileEditor/FileEditor;", "JS_FUNCTION_NAME", "", "openEditor", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "html", "url", "timeoutHtml", "request", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nHTMLEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTMLEditorProvider.kt\ncom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n13#2:170\n1#3:171\n*S KotlinDebug\n*F\n+ 1 HTMLEditorProvider.kt\ncom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Companion\n*L\n49#1:170\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void openEditor(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title2, @NotNull String html) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)html, (String)"html");
            this.openEditor(project2, title2, Request.Companion.html$default(Request.Companion, html, null, 2, null));
        }

        @JvmStatic
        public final void openEditor(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title2, @NotNull String url, @Nullable String timeoutHtml) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.openEditor(project2, title2, Request.Companion.url(url).withTimeoutHtml(timeoutHtml));
        }

        public static /* synthetic */ void openEditor$default(Companion companion, Project project2, String string, String string2, String string3, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            companion.openEditor(project2, string, string2, string3);
        }

        @JvmStatic
        @Nullable
        public final FileEditor openEditor(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title2, @NotNull Request request) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            WebPreviewFileType webPreviewFileType = WebPreviewFileType.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)webPreviewFileType), (String)"INSTANCE");
            return this.openEditor(project2, title2, request, (FileType)webPreviewFileType);
        }

        @JvmStatic
        @Nullable
        public final FileEditor openEditor(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title2, @NotNull Request request, @NotNull FileType fileType2) {
            Object object;
            block3: {
                String string;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)fileType2, (String)"fileType");
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(HTMLEditorProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                if (request.url == null) {
                    String string2 = request.html;
                    Intrinsics.checkNotNull((Object)string2);
                    string = "HTML (" + string2.length() + " chars)";
                } else {
                    string = "URL=" + request.url;
                }
                logger.info(string);
                LightVirtualFile file2 = new LightVirtualFile(title2, fileType2, (CharSequence)"");
                REQUEST_KEY.set((UserDataHolder)file2, (Object)request);
                FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project2).openFile((VirtualFile)file2, true);
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
                for (Object object2 : (Object[])fileEditorArray) {
                    FileEditor it = (FileEditor)object2;
                    boolean bl = false;
                    if (!(it instanceof HTMLFileEditor)) continue;
                    object = object2;
                    break block3;
                }
                object = null;
            }
            return (FileEditor)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u00a6@\u00a2\u0006\u0002\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$JsQueryHandler;", "", "query", "", "id", "", "request", "(JLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    public static interface JsQueryHandler {
        @Nullable
        public Object query(long var1, @NotNull String var3, @NotNull Continuation<? super String> var4);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\u0015\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0007R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000f@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Request;", "", "html", "", "url", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "value", "timeoutHtml", "getTimeoutHtml$intellij_platform_ide_impl", "()Ljava/lang/String;", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$JsQueryHandler;", "queryHandler", "getQueryHandler$intellij_platform_ide_impl", "()Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$JsQueryHandler;", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler;", "requestHandler", "getRequestHandler$intellij_platform_ide_impl", "()Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler;", "withTimeoutHtml", "withQueryHandler", "withResourceHandler", "Companion", "intellij.platform.ide.impl"})
    public static final class Request {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @Nullable
        public final String html;
        @JvmField
        @Nullable
        public final String url;
        @Nullable
        private String timeoutHtml;
        @Nullable
        private JsQueryHandler queryHandler;
        @Nullable
        private ResourceHandler requestHandler;

        private Request(String html, String url) {
            this.html = html;
            this.url = url;
        }

        @Nullable
        public final String getTimeoutHtml$intellij_platform_ide_impl() {
            return this.timeoutHtml;
        }

        @Nullable
        public final JsQueryHandler getQueryHandler$intellij_platform_ide_impl() {
            return this.queryHandler;
        }

        @Nullable
        public final ResourceHandler getRequestHandler$intellij_platform_ide_impl() {
            return this.requestHandler;
        }

        @NotNull
        public final Request withTimeoutHtml(@Nullable String timeoutHtml) {
            this.timeoutHtml = timeoutHtml;
            return this;
        }

        @NotNull
        public final Request withQueryHandler(@Nullable JsQueryHandler queryHandler) {
            this.queryHandler = queryHandler;
            return this;
        }

        @ApiStatus.Internal
        @NotNull
        public final Request withResourceHandler(@Nullable ResourceHandler requestHandler) {
            this.requestHandler = requestHandler;
            return this;
        }

        @JvmStatic
        @NotNull
        public static final Request url(@NotNull String url) {
            return Companion.url(url);
        }

        public /* synthetic */ Request(String html, String url, DefaultConstructorMarker $constructor_marker) {
            this(html, url);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Request$Companion;", "", "<init>", "()V", "html", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Request;", "", "url", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            @JvmOverloads
            @NotNull
            public final Request html(@NotNull String html, @Nullable String url) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                return new Request(html, url, null);
            }

            public static /* synthetic */ Request html$default(Companion companion, String string, String string2, int n, Object object) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                return companion.html(string, string2);
            }

            @JvmStatic
            @NotNull
            public final Request url(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                return new Request(null, url, null);
            }

            @JvmOverloads
            @NotNull
            public final Request html(@NotNull String html) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                return com.intellij.openapi.fileEditor.impl.HTMLEditorProvider$Request$Companion.html$default(this, html, null, 2, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bg\u0018\u00002\u00020\u0001:\u0003\t\n\u000bJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler;", "", "shouldInterceptRequest", "", "request", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceRequest;", "handleResourceRequest", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceResponse;", "(Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Resource", "ResourceRequest", "ResourceResponse", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static interface ResourceHandler {
        public boolean shouldInterceptRequest(@NotNull ResourceRequest var1);

        @Nullable
        public Object handleResourceRequest(@NotNull ResourceRequest var1, @NotNull Continuation<? super ResourceResponse> var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00a6@\u00a2\u0006\u0002\u0010\bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$Resource;", "", "mimeType", "", "getMimeType", "()Ljava/lang/String;", "getResourceStream", "Ljava/io/InputStream;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
        public static interface Resource {
            @NotNull
            public String getMimeType();

            @Nullable
            public Object getResourceStream(@NotNull Continuation<? super InputStream> var1);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceRequest;", "", "uri", "Ljava/net/URI;", "<init>", "(Ljava/net/URI;)V", "getUri", "()Ljava/net/URI;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
        public static final class ResourceRequest {
            @NotNull
            private final URI uri;

            public ResourceRequest(@NotNull URI uri) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                this.uri = uri;
            }

            @NotNull
            public final URI getUri() {
                return this.uri;
            }

            @NotNull
            public final URI component1() {
                return this.uri;
            }

            @NotNull
            public final ResourceRequest copy(@NotNull URI uri) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                return new ResourceRequest(uri);
            }

            public static /* synthetic */ ResourceRequest copy$default(ResourceRequest resourceRequest, URI uRI, int n, Object object) {
                if ((n & 1) != 0) {
                    uRI = resourceRequest.uri;
                }
                return resourceRequest.copy(uRI);
            }

            @NotNull
            public String toString() {
                return "ResourceRequest(uri=" + this.uri + ")";
            }

            public int hashCode() {
                return this.uri.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ResourceRequest)) {
                    return false;
                }
                ResourceRequest resourceRequest = (ResourceRequest)other;
                return Intrinsics.areEqual((Object)this.uri, (Object)resourceRequest.uri);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceResponse;", "", "<init>", "()V", "NotFound", "HandleResource", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceResponse$HandleResource;", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceResponse$NotFound;", "intellij.platform.ide.impl"})
        public static abstract sealed class ResourceResponse {
            private ResourceResponse() {
            }

            public /* synthetic */ ResourceResponse(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceResponse$HandleResource;", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceResponse;", "resource", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$Resource;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$Resource;)V", "getResource", "()Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$Resource;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
            public static final class HandleResource
            extends ResourceResponse {
                @NotNull
                private final Resource resource;

                public HandleResource(@NotNull Resource resource) {
                    Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                    super(null);
                    this.resource = resource;
                }

                @NotNull
                public final Resource getResource() {
                    return this.resource;
                }

                @NotNull
                public final Resource component1() {
                    return this.resource;
                }

                @NotNull
                public final HandleResource copy(@NotNull Resource resource) {
                    Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                    return new HandleResource(resource);
                }

                public static /* synthetic */ HandleResource copy$default(HandleResource handleResource, Resource resource, int n, Object object) {
                    if ((n & 1) != 0) {
                        resource = handleResource.resource;
                    }
                    return handleResource.copy(resource);
                }

                @NotNull
                public String toString() {
                    return "HandleResource(resource=" + this.resource + ")";
                }

                public int hashCode() {
                    return this.resource.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof HandleResource)) {
                        return false;
                    }
                    HandleResource handleResource = (HandleResource)other;
                    return Intrinsics.areEqual((Object)this.resource, (Object)handleResource.resource);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceResponse$NotFound;", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceResponse;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
            public static final class NotFound
            extends ResourceResponse {
                @NotNull
                public static final NotFound INSTANCE = new NotFound();

                private NotFound() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "NotFound";
                }

                public int hashCode() {
                    return 2114463784;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof NotFound)) {
                        return false;
                    }
                    NotFound cfr_ignored_0 = (NotFound)other;
                    return true;
                }
            }
        }
    }
}

