/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.UnlockOption;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.IdeScriptEngineUsageCollector;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class IdeUiServiceImpl
extends IdeUiService {
    public void revealFile(Path file2) {
        RevealFileAction.openFile(file2);
    }

    public UnlockOption askForUnlock(@NotNull Project project2, List<? extends VirtualFile> files2) {
        NonProjectFileWritingAccessDialog dialog2;
        if (project2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(0);
        }
        if (!(dialog2 = new NonProjectFileWritingAccessDialog(project2, files2)).showAndGet()) {
            return null;
        }
        return dialog2.getUnlockOption();
    }

    public boolean isFileRecentlyChanged(Project project2, VirtualFile file2) {
        IdeDocumentHistory documentHistory = IdeDocumentHistory.getInstance(project2);
        return documentHistory instanceof IdeDocumentHistoryImpl && ((IdeDocumentHistoryImpl)documentHistory).isRecentlyChanged(file2);
    }

    public void logIdeScriptUsageEvent(Class<?> clazz) {
        IdeScriptEngineUsageCollector.logUsageEvent(clazz);
    }

    public void systemNotify(@NlsContexts.SystemNotificationTitle String title2, @NlsContexts.SystemNotificationText String text2) {
        SystemNotifications.getInstance().notify("SessionLogger", title2, StringUtil.stripHtml((String)text2, (boolean)true));
    }

    @NotNull
    public DataContext createUiDataContext(Component component2) {
        DataContext dataContext2 = Utils.createAsyncDataContext(component2);
        if (dataContext2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(1);
        }
        return dataContext2;
    }

    @NotNull
    public DataContext createAsyncDataContext(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(2);
        }
        DataContext dataContext3 = Utils.createAsyncDataContext(dataContext2);
        if (dataContext3 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(3);
        }
        return dataContext3;
    }

    @NotNull
    public DataContext createCustomizedDataContext(@NotNull DataContext dataContext2, @NotNull DataProvider dataProvider) {
        if (dataContext2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(4);
        }
        if (dataProvider == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(5);
        }
        DataContext dataContext3 = Utils.createAsyncDataContext(dataContext2, dataProvider);
        if (dataContext3 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(6);
        }
        return dataContext3;
    }

    public void initUpdateSession(@NotNull AnActionEvent event) {
        if (event == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(7);
        }
        Utils.initUpdateSession(event);
    }

    public Component getComponentFromRecentMouseEvent() {
        return SwingHelper.getComponentFromRecentMouseEvent();
    }

    public void browse(URL url) {
        BrowserUtil.browse((URL)url);
    }

    public void browse(String url) {
        BrowserUtil.browse((String)url);
    }

    public void performAction(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        if (action2 == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(8);
        }
        if (event == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(9);
        }
        ActionUtil.performAction((AnAction)action2, (AnActionEvent)event);
    }

    public boolean notifyByBalloon(Project project2, String toolWindowId, MessageType messageType, @Nls String fullMessage, Icon icon2, HyperlinkListener listener2) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
        if (toolWindowManager.canShowNotification(toolWindowId)) {
            toolWindowManager.notifyByBalloon(toolWindowId, messageType, fullMessage, icon2, listener2);
            return true;
        }
        return false;
    }

    public URLConnection openHttpConnection(String url) throws IOException {
        return HttpConfigurable.getInstance().openConnection(url);
    }

    public SSLSocketFactory getSslSocketFactory() {
        return CertificateManager.getInstance().getSslContext().getSocketFactory();
    }

    public boolean isUseSafeWrite() {
        return GeneralSettings.getInstance().isUseSafeWrite();
    }

    public VirtualFile[] chooseFiles(FileChooserDescriptor descriptor, Project project2, VirtualFile toSelect) {
        return FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project2, (VirtualFile)toSelect);
    }

    public VirtualFile chooseFile(FileChooserDescriptor descriptor, JComponent component2, Project project2, VirtualFile dir) {
        return FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)component2, (Project)project2, (VirtualFile)dir);
    }

    public SSLContext getSslContext() {
        return CertificateManager.getInstance().getSslContext();
    }

    public String getProxyLogin() {
        return HttpConfigurable.getInstance().getProxyLogin();
    }

    public String getPlainProxyPassword() {
        return HttpConfigurable.getInstance().getPlainProxyPassword();
    }

    public boolean isProxyAuth() {
        return HttpConfigurable.getInstance().PROXY_AUTHENTICATION;
    }

    public List<Proxy> getProxyList(URL url) {
        return CommonProxy.getInstance().select(url);
    }

    public void prepareURL(String url) throws IOException {
        HttpConfigurable.getInstance().prepareURL(url);
    }

    public boolean showErrorDialog(@NlsContexts.DialogTitle String title2, @NlsContexts.DetailedDescription String message) {
        return IOExceptionDialog.showErrorDialog((String)title2, (String)message);
    }

    public void showRefactoringMessageDialog(String title2, String message, String helpTopic, String iconId, boolean showCancelButton, Project project2) {
        RefactoringMessageDialog dialog2 = new RefactoringMessageDialog(title2, message, helpTopic, iconId, showCancelButton, project2);
        dialog2.show();
    }

    public void showErrorHint(Editor editor2, String message) {
        HintManager.getInstance().showErrorHint(editor2, message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/IdeUiServiceImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/IdeUiServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUiDataContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAsyncDataContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomizedDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "askForUnlock";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAsyncDataContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomizedDataContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initUpdateSession";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6 -> new IllegalStateException(string);
        };
    }
}

