/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.zoomIndicator;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.zoomIndicator.ZoomIndicatorView;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001cJ\f\u0010\u001e\u001a\u00020\u001f*\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/Alarm;", "popupActions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "getBalloon", "()Lcom/intellij/openapi/ui/popup/Balloon;", "setBalloon", "(Lcom/intellij/openapi/ui/popup/Balloon;)V", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "setEditor", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "createOrGetBalloon", "editorEx", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cancelBalloonAlarmRequest", "", "cancelCurrentPopup", "getView", "Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorView;", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nZoomIndicatorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZoomIndicatorManager.kt\ncom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class ZoomIndicatorManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final ArrayList<String> popupActions;
    @Nullable
    private Balloon balloon;
    @Nullable
    private EditorEx editor;
    @JvmField
    @NotNull
    public static final Key<Boolean> SUPPRESS_ZOOM_INDICATOR;
    @JvmField
    @NotNull
    public static final Key<Boolean> SUPPRESS_ZOOM_INDICATOR_ONCE;

    public ZoomIndicatorManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.alarm = new Alarm((Disposable)project2);
        Object[] objectArray = new String[]{"ResetFontSizeAction", "com.intellij.openapi.fileEditor.impl.zoomIndicator.ZoomIndicatorView$settingsAction$1"};
        this.popupActions = CollectionsKt.arrayListOf((Object[])objectArray);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect();
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new AnActionListener(){

            public void afterActionPerformed(AnAction action2, AnActionEvent event, AnActionResult result2) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (Intrinsics.areEqual((Object)event.getPlace(), (Object)"popup") && (popupActions.contains(action2.getClass().getName()) || popupActions.contains(action2.getClass().getSimpleName()))) {
                    this.cancelCurrentPopup();
                }
            }
        });
    }

    @Nullable
    public final Balloon getBalloon() {
        return this.balloon;
    }

    public final void setBalloon(@Nullable Balloon balloon2) {
        this.balloon = balloon2;
    }

    @Nullable
    public final EditorEx getEditor() {
        return this.editor;
    }

    public final void setEditor(@Nullable EditorEx editorEx) {
        this.editor = editorEx;
    }

    @Nullable
    public final Balloon createOrGetBalloon(@NotNull EditorImpl editorEx) {
        Balloon balloon2;
        Intrinsics.checkNotNullParameter((Object)editorEx, (String)"editorEx");
        ZoomIndicatorView view2 = new ZoomIndicatorView(editorEx);
        Balloon b = this.balloon;
        if (Intrinsics.areEqual((Object)editorEx, (Object)this.editor)) {
            BalloonImpl balloonImpl = b instanceof BalloonImpl ? (BalloonImpl)b : null;
            boolean bl = balloonImpl != null ? balloonImpl.isVisible() : false;
            if (bl) {
                this.getView(b).updateFontSize();
                return null;
            }
        }
        this.cancelCurrentPopup();
        boolean newUI = ExperimentalUI.Companion.isNewUI();
        Balloon $this$createOrGetBalloon_u24lambda_u240 = balloon2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)view2).setRequestFocus(false).setShadow(true).setFillColor(newUI ? (Color)JBColor.namedColor((String)"Toolbar.Floating.background", (Color)((Color)new JBColor(0xEDEDED, 4541005))) : view2.getBackground()).setBorderColor(newUI ? (Color)JBColor.namedColor((String)"Toolbar.Floating.borderColor", (Color)((Color)new JBColor(15461616, 4408650))) : JBColor.border()).setShowCallout(false).setFadeoutTime(0L).createBalloon();
        boolean bl = false;
        $this$createOrGetBalloon_u24lambda_u240.setAnimationEnabled(false);
        Balloon balloon3 = balloon2;
        Intrinsics.checkNotNullExpressionValue((Object)balloon3, (String)"apply(...)");
        Balloon b2 = balloon3;
        this.alarm.addRequest(() -> ZoomIndicatorManager.createOrGetBalloon$lambda$1(this), 5000);
        this.balloon = b2;
        this.editor = editorEx;
        return b2;
    }

    private final void cancelBalloonAlarmRequest() {
        this.alarm.cancelAllRequests();
        Balloon balloon2 = this.balloon;
        if (balloon2 == null) {
            return;
        }
        Balloon b = balloon2;
        if (!this.getView(b).isHovered()) {
            this.cancelCurrentPopup();
        } else {
            this.alarm.addRequest(() -> ZoomIndicatorManager.cancelBalloonAlarmRequest$lambda$0(this), 5000);
        }
    }

    public final void cancelCurrentPopup() {
        Balloon balloon2 = this.balloon;
        if (balloon2 != null) {
            balloon2.hide();
        }
        this.balloon = null;
        this.editor = null;
    }

    private final ZoomIndicatorView getView(Balloon $this$getView) {
        Intrinsics.checkNotNull((Object)$this$getView, (String)"null cannot be cast to non-null type com.intellij.ui.BalloonImpl");
        JComponent jComponent = ((BalloonImpl)$this$getView).getContent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.zoomIndicator.ZoomIndicatorView");
        return (ZoomIndicatorView)jComponent;
    }

    private static final void createOrGetBalloon$lambda$1(ZoomIndicatorManager this$0) {
        this$0.cancelBalloonAlarmRequest();
    }

    private static final void cancelBalloonAlarmRequest$lambda$0(ZoomIndicatorManager this$0) {
        this$0.cancelBalloonAlarmRequest();
    }

    static {
        Key key = Key.create((String)"SUPPRESS_ZOOM_INDICATOR");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SUPPRESS_ZOOM_INDICATOR = key;
        Key key2 = Key.create((String)"SUPPRESS_ZOOM_INDICATOR_ONCE");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        SUPPRESS_ZOOM_INDICATOR_ONCE = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorManager$Companion;", "", "<init>", "()V", "SUPPRESS_ZOOM_INDICATOR", "Lcom/intellij/openapi/util/Key;", "", "SUPPRESS_ZOOM_INDICATOR_ONCE", "isEditorZoomIndicatorEnabled", "isEditorZoomIndicatorEnabled$intellij_platform_ide_impl", "()Z", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEditorZoomIndicatorEnabled$intellij_platform_ide_impl() {
            return AdvancedSettings.Companion.getBoolean("editor.show.zoom.indicator");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

