/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.util.CurrentJavaVersion;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.system.CpuArch;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class NativeFileWatcherImpl
extends PluggableFileWatcher {
    private static final Logger LOG = Logger.getInstance(NativeFileWatcherImpl.class);
    private static final String PROPERTY_WATCHER_DISABLED = "idea.filewatcher.disabled";
    private static final String PROPERTY_WATCHER_EXECUTABLE_PATH = "idea.filewatcher.executable.path";
    private static final String ROOTS_COMMAND = "ROOTS";
    private static final String EXIT_COMMAND = "EXIT";
    private static final int MAX_PROCESS_LAUNCH_ATTEMPT_COUNT = 10;
    private static final int EXIT_TIMEOUT_MS = 500;
    private FileWatcherNotificationSink myNotificationSink;
    private Path myExecutable;
    private volatile MyProcessHandler myProcessHandler;
    private final AtomicInteger myStartAttemptCount = new AtomicInteger(0);
    private volatile boolean myIsShuttingDown;
    private final AtomicInteger mySettingRoots = new AtomicInteger(0);
    private volatile List<String> myRecursiveWatchRoots = Collections.emptyList();
    private volatile List<String> myFlatWatchRoots = Collections.emptyList();
    private volatile List<String> myIgnoredRoots = Collections.emptyList();
    private final String[] myLastChangedPaths = new String[2];
    private int myLastChangedPathIndex;
    private static final Charset CHARSET = SystemInfo.isWindows || SystemInfo.isMac ? StandardCharsets.UTF_8 : CharsetToolkit.getPlatformCharset();
    private static final BaseOutputReader.Options READER_OPTIONS = new BaseOutputReader.Options(){

        public BaseDataReader.SleepingPolicy policy() {
            return BaseDataReader.SleepingPolicy.BLOCKING;
        }

        public boolean sendIncompleteLines() {
            return false;
        }

        public boolean withSeparators() {
            return false;
        }
    };

    public void initialize(@NotNull FileWatcherNotificationSink notificationSink) {
        if (notificationSink == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(0);
        }
        this.myNotificationSink = notificationSink;
        boolean disabled = this.isDisabled();
        this.myExecutable = this.getExecutable();
        if (disabled) {
            LOG.info("Native file watcher is disabled");
        } else if (this.myExecutable == null) {
            if (SystemInfo.isWindows || SystemInfo.isMac || SystemInfo.isLinux && (CpuArch.isIntel64() || CpuArch.isArm64())) {
                this.notifyOnFailure(IdeCoreBundle.message((String)"watcher.exe.not.found", (Object[])new Object[0]), null);
            } else if (SystemInfo.isLinux) {
                this.notifyOnFailure(IdeCoreBundle.message((String)"watcher.exe.compile", (Object[])new Object[0]), NotificationListener.URL_OPENING_LISTENER);
            } else {
                this.notifyOnFailure(IdeCoreBundle.message((String)"watcher.exe.not.exists", (Object[])new Object[0]), null);
            }
        } else if (!Files.isExecutable(this.myExecutable)) {
            String message = IdeCoreBundle.message((String)"watcher.exe.not.exe", (Object[])new Object[]{this.myExecutable});
            this.notifyOnFailure(message, (notification2, event) -> IdeUiService.getInstance().revealFile(this.myExecutable));
        } else {
            try {
                this.startupProcess(false);
                LOG.info("Native file watcher is operational.");
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
                this.notifyOnFailure(IdeCoreBundle.message((String)"watcher.failed.to.start", (Object[])new Object[0]), null);
            }
        }
    }

    public void dispose() {
        this.myIsShuttingDown = true;
        this.shutdownProcess(true);
    }

    public boolean isOperational() {
        return this.myProcessHandler != null;
    }

    public boolean isSettingRoots() {
        return this.isOperational() && this.mySettingRoots.get() > 0;
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat, boolean shuttingDown) {
        if (recursive == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(1);
        }
        if (flat == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(2);
        }
        if (shuttingDown) {
            this.myIsShuttingDown = true;
            this.shutdownProcess(false);
        } else {
            this.doSetWatchRoots(recursive, flat, false);
        }
    }

    protected boolean isDisabled() {
        if (Boolean.getBoolean(PROPERTY_WATCHER_DISABLED)) {
            return true;
        }
        Application app = ApplicationManager.getApplication();
        return app.isCommandLine() || app.isUnitTestMode();
    }

    @Nullable
    protected Path getExecutable() {
        Path file2;
        String customPath = System.getProperty(PROPERTY_WATCHER_EXECUTABLE_PATH);
        if (customPath != null) {
            Path customFile = PathManager.findBinFile((String)customPath);
            return customFile == null ? Path.of(customPath, new String[0]) : customFile;
        }
        String name2 = null;
        if (SystemInfo.isWindows && (CpuArch.isIntel64() || CpuArch.isArm64())) {
            name2 = "fsnotifier.exe";
        } else if (SystemInfo.isMac) {
            name2 = "fsnotifier";
        } else if (SystemInfo.isLinux && (CpuArch.isIntel64() || CpuArch.isArm64())) {
            name2 = "fsnotifier";
        }
        if (name2 != null && (file2 = PathManager.findBinFile((String)name2)) != null) {
            return file2;
        }
        return null;
    }

    private void notifyOnFailure(@NlsContexts.NotificationContent String cause, @Nullable NotificationListener listener2) {
        this.myNotificationSink.notifyUserOnFailure(cause, listener2);
    }

    private void startupProcess(boolean restart) throws IOException {
        if (this.myIsShuttingDown) {
            return;
        }
        if (ShutDownTracker.isShutdownStarted()) {
            this.myIsShuttingDown = true;
            return;
        }
        if (this.myStartAttemptCount.incrementAndGet() > 10) {
            this.notifyOnFailure(IdeCoreBundle.message((String)"watcher.bailed.out.10x", (Object[])new Object[0]), null);
            return;
        }
        if (restart) {
            this.shutdownProcess(true);
        }
        LOG.info("Starting file watcher: " + String.valueOf(this.myExecutable));
        Process process2 = new ProcessBuilder(this.myExecutable.toAbsolutePath().toString()).start();
        this.myProcessHandler = new MyProcessHandler(process2, this.myExecutable.getFileName().toString());
        this.myProcessHandler.startNotify();
        if (restart) {
            List<String> recursive = this.myRecursiveWatchRoots;
            List<String> flat = this.myFlatWatchRoots;
            if (recursive.size() + flat.size() > 0) {
                this.doSetWatchRoots(recursive, flat, true);
            }
        }
    }

    private void shutdownProcess(boolean await) {
        MyProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null || processHandler.isProcessTerminated()) {
            this.myProcessHandler = null;
            return;
        }
        try {
            this.writeLine(EXIT_COMMAND);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (await) {
            long timeout = TimeUnit.MILLISECONDS.toNanos(500L) + System.nanoTime();
            while (!processHandler.isProcessTerminated()) {
                if (System.nanoTime() > timeout) {
                    LOG.warn("File watcher is still alive, doing a force quit.");
                    processHandler.destroyProcess();
                    break;
                }
                processHandler.waitFor(10L);
            }
            this.myProcessHandler = null;
        }
    }

    private void doSetWatchRoots(List<String> recursive, List<String> flat, boolean restart) {
        if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated() || this.myIsShuttingDown) {
            return;
        }
        if (!restart && this.myRecursiveWatchRoots.equals(recursive) && this.myFlatWatchRoots.equals(flat)) {
            this.myNotificationSink.notifyManualWatchRoots((PluggableFileWatcher)this, this.myIgnoredRoots);
            return;
        }
        this.mySettingRoots.incrementAndGet();
        this.myRecursiveWatchRoots = recursive;
        this.myFlatWatchRoots = flat;
        SmartList ignored = new SmartList();
        if (SystemInfo.isWindows) {
            recursive = NativeFileWatcherImpl.screenUncRoots(recursive, (List<? super String>)ignored);
            flat = NativeFileWatcherImpl.screenUncRoots(flat, (List<? super String>)ignored);
        }
        this.myIgnoredRoots = new CopyOnWriteArrayList<String>((Collection<String>)ignored);
        this.myNotificationSink.notifyManualWatchRoots((PluggableFileWatcher)this, (Collection)ignored);
        try {
            this.writeLine(ROOTS_COMMAND);
            for (String path : recursive) {
                this.writeLine(path);
            }
            for (String path : flat) {
                this.writeLine("|" + path);
            }
            this.writeLine("#");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static List<String> screenUncRoots(List<String> roots, List<? super String> ignored) {
        List<String> filtered = null;
        for (int i2 = 0; i2 < roots.size(); ++i2) {
            String root = roots.get(i2);
            if (OSAgnosticPathUtil.isUncPath((String)root)) {
                if (filtered == null) {
                    filtered = new ArrayList<String>(roots.subList(0, i2));
                }
                ignored.add(root);
                continue;
            }
            if (filtered == null) continue;
            filtered.add(root);
        }
        return filtered != null ? filtered : roots;
    }

    private void writeLine(String line) throws IOException {
        MyProcessHandler processHandler;
        if (LOG.isTraceEnabled()) {
            LOG.trace("<< " + line);
        }
        if ((processHandler = this.myProcessHandler) != null) {
            processHandler.writeLine(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChangedPaths() {
        String[] stringArray = this.myLastChangedPaths;
        synchronized (this.myLastChangedPaths) {
            this.myLastChangedPathIndex = 0;
            Arrays.fill(this.myLastChangedPaths, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRepetition(String path) {
        String[] stringArray = this.myLastChangedPaths;
        synchronized (this.myLastChangedPaths) {
            for (int i2 = 0; i2 < this.myLastChangedPaths.length; ++i2) {
                String lastChangedPath;
                int last = this.myLastChangedPathIndex - i2 - 1;
                if (last < 0) {
                    last += this.myLastChangedPaths.length;
                }
                if ((lastChangedPath = this.myLastChangedPaths[last]) == null || !lastChangedPath.equals(path)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            this.myLastChangedPaths[this.myLastChangedPathIndex++] = path;
            if (this.myLastChangedPathIndex == this.myLastChangedPaths.length) {
                this.myLastChangedPathIndex = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    @TestOnly
    public void startup() throws IOException {
        Application app = ApplicationManager.getApplication();
        if (app == null || !app.isUnitTestMode()) {
            throw new IllegalStateException();
        }
        this.myIsShuttingDown = false;
        this.myStartAttemptCount.set(0);
        this.startupProcess(false);
    }

    @TestOnly
    public void shutdown() throws InterruptedException {
        Application app = ApplicationManager.getApplication();
        if (app == null || !app.isUnitTestMode()) {
            throw new IllegalStateException();
        }
        MyProcessHandler processHandler = this.myProcessHandler;
        if (processHandler != null) {
            this.myIsShuttingDown = true;
            this.shutdownProcess(true);
            long t = System.currentTimeMillis();
            while (!processHandler.isProcessTerminated()) {
                if (System.currentTimeMillis() - t > 15000L) {
                    throw new InterruptedException("Timed out waiting watcher process to terminate");
                }
                TimeoutUtil.sleep((long)100L);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationSink";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursive";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initialize";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setWatchRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyProcessHandler
    extends OSProcessHandler {
        private final BufferedWriter myWriter;
        private final boolean myNormalizePaths;
        private WatcherOp myLastOp;
        private final List<String> myLines;

        MyProcessHandler(Process process2, String commandLine) {
            super(process2, commandLine, CHARSET);
            this.myNormalizePaths = SystemInfo.isMac && !CurrentJavaVersion.currentJavaVersion().isAtLeast(21);
            this.myLines = new ArrayList<String>();
            this.myWriter = new BufferedWriter(new OutputStreamWriter(process2.getOutputStream(), CHARSET));
        }

        void writeLine(String line) throws IOException {
            this.myWriter.write(line);
            this.myWriter.newLine();
            this.myWriter.flush();
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options2 = READER_OPTIONS;
            if (options2 == null) {
                MyProcessHandler.$$$reportNull$$$0(0);
            }
            return options2;
        }

        protected void notifyProcessTerminated(int exitCode2) {
            super.notifyProcessTerminated(exitCode2);
            String message = "Watcher terminated with exit code " + exitCode2;
            if (NativeFileWatcherImpl.this.myIsShuttingDown) {
                LOG.info(message);
            } else {
                LOG.warn(message);
            }
            NativeFileWatcherImpl.this.myProcessHandler = null;
            try {
                NativeFileWatcherImpl.this.startupProcess(true);
            }
            catch (IOException e) {
                NativeFileWatcherImpl.this.shutdownProcess(true);
                LOG.warn("Watcher terminated and attempt to restart has failed. Exiting watching thread.", (Throwable)e);
            }
        }

        public void notifyTextAvailable(@NotNull String line, @NotNull Key outputType) {
            if (line == null) {
                MyProcessHandler.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                MyProcessHandler.$$$reportNull$$$0(2);
            }
            if (outputType == ProcessOutputTypes.STDERR) {
                LOG.warn(line);
            }
            if (outputType != ProcessOutputTypes.STDOUT || NativeFileWatcherImpl.this.myIsShuttingDown) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(">> " + line);
            }
            if (this.myLastOp == null) {
                WatcherOp watcherOp;
                try {
                    watcherOp = WatcherOp.valueOf(line);
                }
                catch (IllegalArgumentException e) {
                    String message = "Illegal watcher command: '" + line + "'";
                    if (line.length() <= 20) {
                        message = message + " " + Arrays.toString(line.chars().toArray());
                    }
                    LOG.error(message);
                    return;
                }
                if (watcherOp == WatcherOp.GIVEUP) {
                    NativeFileWatcherImpl.this.notifyOnFailure(IdeCoreBundle.message((String)"watcher.gave.up", (Object[])new Object[0]), null);
                    NativeFileWatcherImpl.this.myIsShuttingDown = true;
                } else if (watcherOp == WatcherOp.RESET) {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyReset(null);
                } else {
                    this.myLastOp = watcherOp;
                }
            } else if (this.myLastOp == WatcherOp.MESSAGE) {
                String localized = Objects.requireNonNullElse(IdeCoreBundle.messageOrNull((String)line, (Object[])new Object[0]), line);
                LOG.warn(localized);
                NativeFileWatcherImpl.this.notifyOnFailure(localized, NotificationListener.URL_OPENING_LISTENER);
                this.myLastOp = null;
            } else if (this.myLastOp == WatcherOp.REMAP || this.myLastOp == WatcherOp.UNWATCHEABLE) {
                if ("#".equals(line)) {
                    if (this.myLastOp == WatcherOp.REMAP) {
                        this.processRemap();
                    } else {
                        NativeFileWatcherImpl.this.mySettingRoots.decrementAndGet();
                        this.processUnwatchable();
                    }
                    this.myLines.clear();
                    this.myLastOp = null;
                } else {
                    this.myLines.add(line);
                }
            } else {
                String path = StringUtil.trimEnd((String)line.replace('\u0000', '\n'), (String)File.separator);
                this.processChange(path, this.myLastOp);
                this.myLastOp = null;
            }
        }

        private void processRemap() {
            HashSet<Pair> pairs = new HashSet<Pair>();
            for (int i2 = 0; i2 < this.myLines.size() - 1; i2 += 2) {
                pairs.add(Pair.create((Object)this.myLines.get(i2), (Object)this.myLines.get(i2 + 1)));
            }
            NativeFileWatcherImpl.this.myNotificationSink.notifyMapping(pairs);
        }

        private void processUnwatchable() {
            NativeFileWatcherImpl.this.myIgnoredRoots.addAll(this.myLines);
            NativeFileWatcherImpl.this.myNotificationSink.notifyManualWatchRoots((PluggableFileWatcher)NativeFileWatcherImpl.this, this.myLines);
        }

        private void processChange(String path, WatcherOp op) {
            if (SystemInfo.isWindows && op == WatcherOp.RECDIRTY) {
                NativeFileWatcherImpl.this.myNotificationSink.notifyReset(path);
                return;
            }
            if ((op == WatcherOp.CHANGE || op == WatcherOp.STATS) && NativeFileWatcherImpl.this.isRepetition(path)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("repetition: " + path);
                }
                return;
            }
            if (this.myNormalizePaths) {
                path = Normalizer.normalize(path, Normalizer.Form.NFC);
            }
            switch (op.ordinal()) {
                case 7: 
                case 8: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPath(path);
                    break;
                }
                case 5: 
                case 6: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyPathCreatedOrDeleted(path);
                    break;
                }
                case 9: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyDirectory(path);
                    break;
                }
                case 10: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPathRecursive(path);
                    break;
                }
                default: {
                    LOG.error("Unexpected op: " + String.valueOf((Object)op));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$MyProcessHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$MyProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyTextAvailable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static enum WatcherOp {
        GIVEUP,
        RESET,
        UNWATCHEABLE,
        REMAP,
        MESSAGE,
        CREATE,
        DELETE,
        STATS,
        CHANGE,
        DIRTY,
        RECDIRTY;

    }
}

