/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"$\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getAnchorWeight", "", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "windowInfoComparator", "Ljava/util/Comparator;", "Lcom/intellij/openapi/wm/WindowInfo;", "Lkotlin/Comparator;", "getWindowInfoComparator", "()Ljava/util/Comparator;", "normalizeOrder", "", "list", "", "Lcom/intellij/openapi/wm/impl/WindowInfoImpl;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nDesktopLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopLayout.kt\ncom/intellij/openapi/wm/impl/DesktopLayoutKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,211:1\n13#2:212\n*S KotlinDebug\n*F\n+ 1 DesktopLayout.kt\ncom/intellij/openapi/wm/impl/DesktopLayoutKt\n*L\n174#1:212\n*E\n"})
public final class DesktopLayoutKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Comparator<WindowInfo> windowInfoComparator;

    private static final int getAnchorWeight(ToolWindowAnchor anchor) {
        ToolWindowAnchor toolWindowAnchor = anchor;
        return Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP) ? 1 : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT) ? 2 : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM) ? 3 : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT) ? 4 : 0)));
    }

    @NotNull
    public static final Comparator<WindowInfo> getWindowInfoComparator() {
        return windowInfoComparator;
    }

    public static final void normalizeOrder(@NotNull List<WindowInfoImpl> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        CollectionsKt.sortWith(list2, windowInfoComparator);
        int order = 0;
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.TOP;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"TOP");
        ToolWindowAnchor lastAnchor = toolWindowAnchor;
        for (WindowInfoImpl info : list2) {
            if (info.getOrder() == -1) continue;
            if (!Intrinsics.areEqual((Object)lastAnchor, (Object)info.getAnchor())) {
                lastAnchor = info.getAnchor();
                order = 0;
            }
            info.setOrder(order++);
        }
    }

    private static final int windowInfoComparator$lambda$0(WindowInfo o1, WindowInfo o2) {
        int weightDiff = DesktopLayoutKt.getAnchorWeight(o1.getAnchor()) - DesktopLayoutKt.getAnchorWeight(o2.getAnchor());
        return weightDiff != 0 ? weightDiff : o1.getOrder() - o2.getOrder();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DesktopLayout.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        windowInfoComparator = DesktopLayoutKt::windowInfoComparator$lambda$0;
    }
}

