/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.PainterHelper;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeBackgroundUtil {
    public static final String EDITOR_PROP = "idea.background.editor";
    public static final String FRAME_PROP = "idea.background.frame";
    public static final Key<Boolean> NO_BACKGROUND = Key.create((String)"SUPPRESS_BACKGROUND");
    @ApiStatus.Internal
    public static final RenderingHints.Key ADJUST_ALPHA;
    @ApiStatus.Internal
    public static final RenderingHints.Key NO_BACKGROUND_HINT;

    @NotNull
    public static Graphics2D withEditorBackground(@NotNull Graphics g, @NotNull JComponent component2) {
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(0);
        }
        if (component2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(1);
        }
        return IdeBackgroundUtil.withNamedPainters(g, EDITOR_PROP, component2);
    }

    @NotNull
    public static Graphics2D withFrameBackground(@NotNull Graphics g, @NotNull JComponent component2) {
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(2);
        }
        if (component2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(3);
        }
        return IdeBackgroundUtil.withNamedPainters(g, FRAME_PROP, component2);
    }

    @NotNull
    public static Graphics2D getOriginalGraphics(@NotNull Graphics g) {
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(4);
        }
        Graphics2D graphics2D = g instanceof MyGraphics ? ((MyGraphics)((Object)g)).getDelegate() : (Graphics2D)g;
        if (graphics2D == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(5);
        }
        return graphics2D;
    }

    @NotNull
    private static Graphics2D withNamedPainters(@NotNull Graphics g, @NotNull String paintersName, @NotNull JComponent component2) {
        PainterHelper helper;
        Boolean noBackground;
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(6);
        }
        if (paintersName == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(7);
        }
        if (component2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(8);
        }
        if (Boolean.TRUE.equals(noBackground = (Boolean)ClientProperty.get((Component)component2, NO_BACKGROUND))) {
            Graphics2D graphics2D = MyGraphics.unwrap(g);
            if (graphics2D == null) {
                IdeBackgroundUtil.$$$reportNull$$$0(9);
            }
            return graphics2D;
        }
        boolean checkLayer = !Boolean.FALSE.equals(noBackground);
        JRootPane rootPane = null;
        JComponent p = null;
        for (Container c = component2; c != null && rootPane == null; c = c.getParent()) {
            if (c instanceof JRootPane) {
                rootPane = (JRootPane)c;
            }
            if (checkLayer && c instanceof JLayeredPane && p != null && ((JLayeredPane)c).getLayer(p) == JLayeredPane.POPUP_LAYER.intValue()) break;
            p = c;
        }
        Component glassPane = rootPane == null ? null : rootPane.getGlassPane();
        PainterHelper painterHelper = helper = glassPane instanceof IdeGlassPaneImpl ? ((IdeGlassPaneImpl)glassPane).getNamedPainters(paintersName) : null;
        if (helper == null || !helper.needsRepaint()) {
            Graphics2D graphics2D = MyGraphics.unwrap(g);
            if (graphics2D == null) {
                IdeBackgroundUtil.$$$reportNull$$$0(10);
            }
            return graphics2D;
        }
        Graphics2D graphics2D = MyGraphics.wrap(g, helper, component2);
        if (graphics2D == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(11);
        }
        return graphics2D;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    static void addFallbackBackgroundPainter(IdeGlassPaneImpl glassPane, @NotNull Painter fallbackBackgroundPainter) {
        if (fallbackBackgroundPainter == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(12);
        }
        PainterHelper painters = glassPane.getNamedPainters(EDITOR_PROP);
        painters.addFallbackBackgroundPainter(fallbackBackgroundPainter);
        painters = glassPane.getNamedPainters(FRAME_PROP);
        painters.addFallbackBackgroundPainter(fallbackBackgroundPainter);
    }

    static void initEditorPainters(@NotNull IdeGlassPaneImpl glassPane) {
        if (glassPane == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(13);
        }
        PainterHelper.initWallpaperPainter(EDITOR_PROP, glassPane.getNamedPainters(EDITOR_PROP));
    }

    static void initFramePainters(@NotNull IdeGlassPaneImpl glassPane) {
        if (glassPane == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(14);
        }
        PainterHelper painters = glassPane.getNamedPainters(FRAME_PROP);
        PainterHelper.initWallpaperPainter(FRAME_PROP, painters);
        painters.addPainter((Painter)new AbstractPainter(){
            EditorEmptyTextPainter p = null;

            public boolean needsRepaint() {
                return true;
            }

            public void executePaint(@NotNull Component component2, @NotNull Graphics2D g) {
                if (component2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (g == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.p == null) {
                    this.p = (EditorEmptyTextPainter)ApplicationManager.getApplication().getService(EditorEmptyTextPainter.class);
                }
                this.p.paintEmptyText((JComponent)component2, g);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "g";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil$1";
                objectArray[2] = "executePaint";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    public static void resetBackgroundImagePainters() {
        PainterHelper.resetWallpaperPainterCache();
        IdeBackgroundUtil.repaintAllWindows();
    }

    @NotNull
    public static Color getIdeBackgroundColor() {
        JBColor jBColor = JBColor.lazy(() -> StartupUiUtil.isUnderDarcula() ? Gray._40 : ColorUtil.darker((Color)JBColor.PanelBackground, (int)3));
        if (jBColor == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(15);
        }
        return jBColor;
    }

    public static void createTemporaryBackgroundTransform(@NotNull JPanel root, String tmp, @NotNull Disposable disposable) {
        if (root == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(16);
        }
        if (disposable == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(17);
        }
        PainterHelper paintersHelper = new PainterHelper(root);
        PainterHelper.initWallpaperPainter(tmp, paintersHelper);
        IdeBackgroundUtil.createTemporaryBackgroundTransform((JComponent)root, paintersHelper, disposable);
    }

    public static void createTemporaryBackgroundTransform(JComponent root, Image image2, Fill fill, Anchor anchor, float alpha, Insets insets, Disposable disposable) {
        PainterHelper paintersHelper = new PainterHelper(root);
        paintersHelper.addPainter((Painter)PainterHelper.newImagePainter(image2, fill, anchor, alpha, insets), root);
        IdeBackgroundUtil.createTemporaryBackgroundTransform(root, paintersHelper, disposable);
    }

    @ApiStatus.Experimental
    public static void createTemporaryBackgroundTransform(JComponent root, final Painter painter, Disposable disposable) {
        PainterHelper paintersHelper = new PainterHelper(root);
        paintersHelper.addPainter(new Painter(){

            public boolean needsRepaint() {
                return painter.needsRepaint();
            }

            public void paint(@NotNull Component component2, @NotNull Graphics2D g) {
                if (component2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (g == null) {
                    2.$$$reportNull$$$0(1);
                }
                painter.paint(component2, MyGraphics.unwrap(g));
            }

            public void addListener(@NotNull Painter.Listener listener2) {
                if (listener2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                painter.addListener(listener2);
            }

            public void removeListener(Painter.Listener listener2) {
                painter.removeListener(listener2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listener";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addListener";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, root);
        IdeBackgroundUtil.createTemporaryBackgroundTransform(root, paintersHelper, disposable);
    }

    private static void createTemporaryBackgroundTransform(JComponent root, PainterHelper painterHelper, Disposable disposable) {
        Disposer.register((Disposable)disposable, (Disposable)JBSwingUtilities.addGlobalCGTransform((c, g) -> {
            if (!UIUtil.isAncestor((Component)root, (Component)c)) {
                return g;
            }
            Boolean noBackground = (Boolean)ClientProperty.get((Component)c, NO_BACKGROUND);
            if (Boolean.TRUE.equals(noBackground)) {
                return MyGraphics.unwrap(g);
            }
            return MyGraphics.wrap(g, painterHelper, c);
        }));
    }

    @NotNull
    public static String getBackgroundSpec(@Nullable Project project2, @NotNull String propertyName) {
        String spec;
        if (propertyName == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(18);
        }
        String string = spec = project2 == null || project2.isDisposed() ? null : PropertiesComponent.getInstance((Project)project2).getValue(propertyName);
        if (spec == null) {
            spec = PropertiesComponent.getInstance().getValue(propertyName);
        }
        String string2 = spec == null ? System.getProperty(propertyName, "") : spec;
        if (string2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(19);
        }
        return string2;
    }

    public static boolean isEditorBackgroundImageSet(@Nullable Project project2) {
        return Strings.isNotEmpty((String)IdeBackgroundUtil.getBackgroundSpec(project2, EDITOR_PROP));
    }

    public static void repaintAllWindows() {
        UISettings.getInstance().fireUISettingsChanged();
        for (Window window : Window.getWindows()) {
            window.repaint();
        }
    }

    static {
        JBSwingUtilities.addGlobalCGTransform((BiFunction)new MyTransform());
        ADJUST_ALPHA = new RenderingHints.Key(1){

            @Override
            public boolean isCompatibleValue(Object val) {
                return val instanceof Boolean;
            }
        };
        NO_BACKGROUND_HINT = new RenderingHints.Key(2){

            @Override
            public boolean isCompatibleValue(Object val) {
                return val instanceof Boolean;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 10, 11, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paintersName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackBackgroundPainter";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "glassPane";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalGraphics";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withNamedPainters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeBackgroundColor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withEditorBackground";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withFrameBackground";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalGraphics";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withNamedPainters";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFallbackBackgroundPainter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initEditorPainters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initFramePainters";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryBackgroundTransform";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundSpec";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 10, 11, 15, 19 -> new IllegalStateException(string);
        };
    }

    private static final class MyGraphics
    extends Graphics2DDelegate {
        final PainterHelper helper;
        final PainterHelper.Offsets offsets;
        Predicate<? super Color> preserved;

        static Graphics2D wrap(Graphics g, PainterHelper helper, JComponent component2) {
            MyGraphics gg = g instanceof MyGraphics ? (MyGraphics)((Object)g) : null;
            return new MyGraphics(gg != null ? gg.myDelegate : g, helper, helper.computeOffsets(g, component2), gg != null ? gg.preserved : null);
        }

        static Graphics2D unwrap(Graphics g) {
            return g instanceof MyGraphics ? ((MyGraphics)((Object)g)).getDelegate() : (Graphics2D)g;
        }

        MyGraphics(Graphics g, PainterHelper helper, PainterHelper.Offsets offsets, Predicate<? super Color> preserved) {
            super((Graphics2D)g);
            this.helper = helper;
            this.offsets = offsets;
            this.preserved = preserved;
        }

        @NotNull
        public Graphics create() {
            return new MyGraphics(this.getDelegate().create(), this.helper, this.offsets, this.preserved);
        }

        private Boolean isNoBackground() {
            Object obj = this.getRenderingHint(NO_BACKGROUND_HINT);
            return obj != null && Boolean.TRUE.equals(obj);
        }

        public void clearRect(int x, int y, int width, int height) {
            super.clearRect(x, y, width, height);
            this.runAllPainters(x, y, width, height, null, this.getColor());
        }

        public void fillRect(int x, int y, int width, int height) {
            super.fillRect(x, y, width, height);
            this.runAllPainters(x, y, width, height, null, this.getColor());
        }

        public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            super.fillArc(x, y, width, height, startAngle, arcAngle);
            this.runAllPainters(x, y, width, height, new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2), this.getColor());
        }

        public void fillOval(int x, int y, int width, int height) {
            super.fillOval(x, y, width, height);
            this.runAllPainters(x, y, width, height, new Ellipse2D.Double(x, y, width, height), this.getColor());
        }

        public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            super.fillPolygon(xPoints, yPoints, nPoints);
            Polygon s = new Polygon(xPoints, yPoints, nPoints);
            Rectangle r = s.getBounds();
            this.runAllPainters(r.x, r.y, r.width, r.height, s, this.getColor());
        }

        public void fillPolygon(Polygon s) {
            super.fillPolygon(s);
            Rectangle r = s.getBounds();
            this.runAllPainters(r.x, r.y, r.width, r.height, s, this.getColor());
        }

        public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            super.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
            this.runAllPainters(x, y, width, height, new RoundRectangle2D.Double(x, y, width, height, arcHeight, arcHeight), this.getColor());
        }

        public void fill(Shape s) {
            super.fill(s);
            Rectangle r = s.getBounds();
            this.runAllPainters(r.x, r.y, r.width, r.height, s, this.getColor());
        }

        public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
            super.drawImage(img, op, x, y);
            this.runAllPainters(x, y, img.getWidth(), img.getHeight(), null, img);
        }

        public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, width, height, observer);
            this.runAllPainters(x, y, width, height, null, img);
            return b;
        }

        public boolean drawImage(Image img, int x, int y, int width, int height, Color c, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, width, height, c, observer);
            this.runAllPainters(x, y, width, height, null, img);
            return b;
        }

        public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, observer);
            this.runAllPainters(x, y, img.getWidth(null), img.getHeight(null), null, img);
            return b;
        }

        public boolean drawImage(Image img, int x, int y, Color c, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, c, observer);
            this.runAllPainters(x, y, img.getWidth(null), img.getHeight(null), null, img);
            return b;
        }

        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
            boolean b = super.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
            this.runAllPainters(dx1, dy1, dx2 - dx1, dy2 - dy1, null, img);
            return b;
        }

        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color c, ImageObserver observer) {
            boolean b = super.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, c, observer);
            this.runAllPainters(dx1, dy1, dx2 - dx1, dy2 - dy1, null, img);
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runAllPainters(int x, int y, int width, int height, @Nullable Shape sourceShape, @Nullable Object reason) {
            boolean preserve;
            boolean hasAlpha;
            if (width <= 1 || height <= 1 || this.isNoBackground().booleanValue()) {
                return;
            }
            if (reason instanceof Color) {
                hasAlpha = ((Color)reason).getAlpha() < 255;
            } else if (reason instanceof BufferedImage) {
                hasAlpha = ((BufferedImage)reason).getColorModel().hasAlpha();
            } else {
                boolean bl = hasAlpha = !(reason instanceof VolatileImage) || ((VolatileImage)reason).getTransparency() != 1;
            }
            if (hasAlpha) {
                return;
            }
            boolean bl = preserve = this.preserved != null && reason instanceof Color && this.preserved.test((Color)reason);
            if (preserve) {
                this.myDelegate.setRenderingHint(ADJUST_ALPHA, Boolean.TRUE);
            }
            Graphics2D clipped = (Graphics2D)this.create();
            try {
                clipped.clip(sourceShape != null ? sourceShape : new Rectangle(x, y, width, height));
                this.helper.runAllPainters(clipped, this.offsets);
            }
            finally {
                clipped.dispose();
            }
            if (preserve) {
                this.myDelegate.setRenderingHint(ADJUST_ALPHA, Boolean.FALSE);
            }
        }
    }

    public static enum Fill {
        PLAIN,
        SCALE,
        TILE;

    }

    public static enum Anchor {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_LEFT,
        CENTER,
        MIDDLE_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }

    private static final class MyTransform
    implements BiFunction<JComponent, Graphics2D, Graphics2D> {
        private MyTransform() {
        }

        @Override
        public Graphics2D apply(@NotNull JComponent c, @NotNull Graphics2D g) {
            Graphics2D gg;
            if (c == null) {
                MyTransform.$$$reportNull$$$0(0);
            }
            if (g == null) {
                MyTransform.$$$reportNull$$$0(1);
            }
            Graphics2D original = MyGraphics.unwrap(g);
            if (c instanceof EditorsSplitters) {
                return IdeBackgroundUtil.withFrameBackground(original, c);
            }
            Editor editor2 = MyTransform.obtainEditor(c);
            if (editor2 instanceof EditorImpl) {
                EditorImpl editorImpl = (EditorImpl)editor2;
                if (c instanceof EditorComponentImpl && (editorImpl.isDumb() || editorImpl.isStickyLinePainting())) {
                    return original;
                }
                if (c instanceof EditorGutterComponentEx && editorImpl.isStickyLinePainting()) {
                    return original;
                }
            }
            if ((gg = IdeBackgroundUtil.withEditorBackground(original, c)) instanceof MyGraphics) {
                ((MyGraphics)((Object)gg)).preserved = editor2 != null ? MyTransform.getEditorPreserveColorCondition((EditorEx)editor2) : MyTransform.getGeneralPreserveColorCondition(c);
            }
            return gg;
        }

        @Nullable
        private static Editor obtainEditor(@Nullable JComponent c) {
            EditorEx editorEx;
            JComponent view2;
            Component component2 = view2 = c instanceof JViewport ? ((JViewport)c).getView() : c;
            if (view2 instanceof EditorComponentImpl) {
                EditorComponentImpl o = (EditorComponentImpl)view2;
                editorEx = o.getEditor();
            } else if (view2 instanceof EditorGutterComponentEx) {
                EditorGutterComponentEx o = (EditorGutterComponentEx)view2;
                editorEx = o.getEditor();
            } else {
                editorEx = null;
            }
            return editorEx;
        }

        @NotNull
        private static Predicate<Color> getEditorPreserveColorCondition(@NotNull EditorEx editor2) {
            if (editor2 == null) {
                MyTransform.$$$reportNull$$$0(2);
            }
            Color background1 = editor2.getBackgroundColor();
            Color background2 = editor2.getGutterComponentEx().getBackground();
            Predicate<Color> predicate = color -> color != background1 && color != background2;
            if (predicate == null) {
                MyTransform.$$$reportNull$$$0(3);
            }
            return predicate;
        }

        @NotNull
        private static Predicate<Color> getGeneralPreserveColorCondition(JComponent c) {
            Color selection1;
            JComponent view2;
            Component component2 = view2 = c instanceof JViewport ? ((JViewport)c).getView() : c;
            Color color2 = view2 instanceof JTree ? UIUtil.getTreeSelectionBackground((boolean)true) : (view2 instanceof JList ? UIUtil.getListSelectionBackground((boolean)true) : (view2 instanceof JTable ? UIUtil.getTableSelectionBackground((boolean)true) : (view2 instanceof JTextComponent ? ((JTextComponent)view2).getSelectionColor() : (selection1 = view2 instanceof JMenuBar || view2 instanceof JMenu ? UIManager.getColor("Menu.selectionBackground") : null))));
            Color selection2 = view2 instanceof JTree ? UIUtil.getTreeSelectionBackground((boolean)false) : (view2 instanceof JList ? UIUtil.getListSelectionBackground((boolean)false) : (view2 instanceof JTable ? UIUtil.getTableSelectionBackground((boolean)false) : null));
            Predicate<Color> predicate = color -> color == selection1 || color == selection2;
            if (predicate == null) {
                MyTransform.$$$reportNull$$$0(4);
            }
            return predicate;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil$MyTransform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil$MyTransform";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorPreserveColorCondition";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGeneralPreserveColorCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditorPreserveColorCondition";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

