/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0005H\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/wm/impl/status/CounterLabel;", "Ljavax/swing/JPanel;", "<init>", "()V", "label", "Lcom/intellij/ui/components/JBLabel;", "numberOfProgresses", "", "isProgressVisible", "", "lastDigitNumber", "textsForMinimumSize", "Lkotlin/ranges/IntRange;", "minimumSize", "Ljava/awt/Dimension;", "createLabel", "setNumber", "", "isPopupShowing", "refreshTextForMinimumSizeIfNeeded", "numberToShow", "getPreferredSize", "getMinimumSize", "intellij.platform.ide.impl"})
final class CounterLabel
extends JPanel {
    @NotNull
    private final JBLabel label = this.createLabel();
    private int numberOfProgresses;
    private boolean isProgressVisible;
    private int lastDigitNumber;
    @Nullable
    private IntRange textsForMinimumSize;
    @Nullable
    private Dimension minimumSize;

    public CounterLabel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.setNumber(0, false, false);
    }

    private final JBLabel createLabel() {
        JBLabel label2 = new JBLabel();
        label2.setFont(TextPanel.Companion.getFont());
        label2.setForeground(JBUI.CurrentTheme.StatusBar.Widget.FOREGROUND);
        return label2;
    }

    public final void setNumber(int numberOfProgresses, boolean isProgressVisible, boolean isPopupShowing) {
        this.numberOfProgresses = numberOfProgresses;
        this.isProgressVisible = isProgressVisible;
        int numberToShow = isProgressVisible ? numberOfProgresses - 1 : numberOfProgresses;
        this.refreshTextForMinimumSizeIfNeeded(numberToShow);
        String labelText = isPopupShowing ? "" : (numberToShow <= 0 ? "" : (!isProgressVisible && numberToShow == 1 ? "" : (isProgressVisible ? "+" + numberToShow : String.valueOf(numberToShow))));
        this.label.setText(labelText);
    }

    private final void refreshTextForMinimumSizeIfNeeded(int numberToShow) {
        String numberToShowString = String.valueOf(numberToShow);
        if (numberToShowString.length() != this.lastDigitNumber) {
            this.lastDigitNumber = numberToShowString.length();
            this.textsForMinimumSize = switch (this.lastDigitNumber) {
                case 1 -> new IntRange(0, 9);
                case 2 -> new IntRange(10, 99);
                case 3 -> new IntRange(100, 999);
                default -> null;
            };
            this.minimumSize = null;
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension precalculated;
        Dimension dimension = precalculated = this.minimumSize;
        if (dimension != null) {
            return dimension;
        }
        IntRange texts = this.textsForMinimumSize;
        if (texts == null || texts.isEmpty()) {
            Dimension dimension2 = super.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
            return dimension2;
        }
        JBLabel probe = this.createLabel();
        Dimension minSize = new Dimension(0, 0);
        IntRange intRange = texts;
        int text2 = intRange.getFirst();
        int n = intRange.getLast();
        int n2 = intRange.getStep();
        if (n2 > 0 && text2 <= n || n2 < 0 && n <= text2) {
            while (true) {
                probe.setText("+" + text2);
                Dimension size2 = probe.getPreferredSize();
                minSize = new Dimension(Math.max(minSize.width, size2.width), Math.max(minSize.height, size2.height));
                if (text2 == n) break;
                text2 += n2;
            }
        }
        this.minimumSize = minSize;
        return minSize;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

