/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Obsolete
public class InlineProgressIndicator
extends ProgressIndicatorBase
implements Disposable {
    protected final TextPanel text;
    protected final TextPanel text2;
    @NotNull
    private final List<ProgressButton> eastButtons;
    @NotNull
    protected final JProgressBar progress;
    protected final JPanel component;
    private final boolean isCompact;
    private final TaskInfo info;
    private final TextPanel processName;
    private boolean isDisposed;

    public InlineProgressIndicator(boolean compact, @NotNull TaskInfo processInfo) {
        if (processInfo == null) {
            InlineProgressIndicator.$$$reportNull$$$0(0);
        }
        this.isCompact = compact;
        this.info = processInfo;
        this.progress = new JProgressBar(0);
        this.progress.setOpaque(false);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.progress);
        this.text = new TextPanel();
        this.text2 = new TextPanel();
        this.processName = new TextPanel();
        this.eastButtons = this.createEastButtons();
        this.component = this.createComponent();
    }

    @NotNull
    protected JPanel createComponent() {
        MyComponent component2 = new MyComponent(this.isCompact, this.processName);
        if (this.isCompact) {
            component2.setLayout(new BorderLayout(2, 0));
            this.createCompactTextAndProgress(component2);
            component2.add((Component)InlineProgressIndicator.createButtonPanel(ContainerUtil.map(this.eastButtons, b -> b.button)), "East");
            component2.setToolTipText(this.info.getTitle() + ". " + IdeBundle.message((String)"progress.text.clickToViewProgressWindow", (Object[])new Object[0]));
        } else {
            component2.setLayout(new BorderLayout());
            this.processName.setText(this.info.getTitle());
            component2.add((Component)this.processName, "North");
            this.processName.setForeground(UIUtil.getPanelBackground().brighter().brighter());
            this.processName.setBorder(JBUI.Borders.empty((int)2));
            NonOpaquePanel content2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            content2.setBorder((Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)(this.info.isCancellable() ? 2 : 4)));
            component2.add((Component)content2, "Center");
            content2.add((Component)InlineProgressIndicator.createButtonPanel(ContainerUtil.map(this.eastButtons, b -> InlineProgressIndicator.withBorder(b.button))), (Object)"East");
            content2.add((Component)this.text, (Object)"North");
            content2.add((Component)this.progress, (Object)"Center");
            content2.add((Component)this.text2, (Object)"South");
            component2.setBorder(JBUI.Borders.empty((int)2));
        }
        UIUtil.uiTraverser((Component)component2).forEach(o -> ((JComponent)o).setOpaque(false));
        if (!this.isCompact) {
            this.processName.recomputeSize();
            this.text.recomputeSize();
            this.text2.recomputeSize();
        }
        MyComponent myComponent = component2;
        if (myComponent == null) {
            InlineProgressIndicator.$$$reportNull$$$0(1);
        }
        return myComponent;
    }

    protected void createCompactTextAndProgress(@NotNull JPanel component2) {
        if (component2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(2);
        }
        NonOpaquePanel textAndProgress = new NonOpaquePanel((LayoutManager)new BorderLayout());
        textAndProgress.add((Component)this.text, "Center");
        NonOpaquePanel progressWrapper2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        progressWrapper2.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        progressWrapper2.add((Component)this.progress, (Object)"Center");
        textAndProgress.add((Component)progressWrapper2, "East");
        component2.add((Component)textAndProgress, "Center");
    }

    static JPanel createButtonPanel(Iterable<? extends JComponent> components) {
        NonOpaquePanel iconsPanel = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        GridBag gb = new GridBag().setDefaultFill(1);
        for (JComponent jComponent : components) {
            iconsPanel.add((Component)jComponent, gb.next());
        }
        return iconsPanel;
    }

    @NotNull
    private static Wrapper withBorder(@NotNull InplaceButton button2) {
        if (button2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(3);
        }
        Wrapper wrapper2 = new Wrapper((JComponent)button2);
        wrapper2.setBorder((Border)JBUI.Borders.empty((int)0, (int)3, (int)0, (int)2));
        Wrapper wrapper3 = wrapper2;
        if (wrapper3 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(4);
        }
        return wrapper3;
    }

    @NotNull
    protected List<ProgressButton> createEastButtons() {
        List<ProgressButton> list2 = List.of(this.createCancelButton());
        if (list2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    protected final ProgressButton createCancelButton() {
        InplaceButton cancelButton = new InplaceButton(new IconButton(this.info.getCancelTooltipText(), this.isCompact ? AllIcons.Process.StopSmall : AllIcons.Process.Stop, this.isCompact ? AllIcons.Process.StopSmallHovered : AllIcons.Process.StopHovered), __ -> this.cancelRequest()).setFillBg(false);
        cancelButton.setVisible(this.info.isCancellable());
        return new ProgressButton(cancelButton, () -> cancelButton.setPainting(!this.isStopping()));
    }

    protected void cancelRequest() {
        this.cancel();
    }

    protected final void updateAndRepaint() {
        if (this.isDisposed()) {
            return;
        }
        this.updateProgressNow();
        this.component.repaint();
    }

    public void updateProgressNow() {
        if (this.isPaintingIndeterminate()) {
            this.progress.setIndeterminate(true);
        } else {
            this.progress.setIndeterminate(false);
            this.progress.setMinimum(0);
            this.progress.setMaximum(100);
        }
        if (this.getFraction() > 0.0) {
            this.progress.setValue((int)(this.getFraction() * 99.0 + 1.0));
        }
        String text2 = this.getText();
        String text22 = this.getText2();
        this.setTextValue(text2 != null ? text2 : "");
        this.setText2Value(text22 != null ? text22 : "");
        if (this.isCompact && StringUtil.isEmpty((String)this.getTextValue())) {
            this.setTextValue(this.info.getTitle());
        }
        if (this.isStopping()) {
            if (this.isCompact) {
                this.setTextValue(IdeBundle.message((String)"progress.text.stopping", (Object[])new Object[]{this.getTextValue()}));
            } else {
                this.setProcessNameValue(IdeBundle.message((String)"progress.text.stopping", (Object[])new Object[]{this.info.getTitle()}));
                this.setTextEnabled(false);
                this.setText2Enabled(false);
            }
            this.progress.setEnabled(false);
        } else {
            this.setTextEnabled(true);
            this.setText2Enabled(true);
            this.progress.setEnabled(true);
        }
        for (ProgressButton button2 : this.eastButtons) {
            button2.updateAction.run();
        }
    }

    @Nullable
    protected String getTextValue() {
        return this.text.getText();
    }

    protected void setTextValue(@NlsContexts.ProgressText @NotNull String text2) {
        if (text2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(6);
        }
        this.text.setText(text2);
    }

    protected void setTextEnabled(boolean value) {
        this.text.setEnabled(value);
    }

    @Nullable
    protected String getText2Value() {
        return this.text2.getText();
    }

    protected void setText2Value(@NlsContexts.ProgressDetails @NotNull String text2) {
        if (text2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(7);
        }
        this.text2.setText(text2);
    }

    protected void setText2Enabled(boolean value) {
        this.text2.setEnabled(value);
    }

    protected void setProcessNameValue(@NlsContexts.ProgressTitle @NotNull String text2) {
        if (text2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(8);
        }
        this.processName.setText(text2);
    }

    @NlsContexts.ProgressTitle
    protected String getProcessNameValue() {
        return this.processName.getText();
    }

    protected boolean isPaintingIndeterminate() {
        return this.isIndeterminate() || this.getFraction() == 0.0;
    }

    protected boolean isStopping() {
        return this.wasStarted() && (this.isCanceled() || !this.isRunning()) && !this.isFinished();
    }

    protected boolean isFinished() {
        return false;
    }

    protected void queueProgressUpdate() {
        this.updateAndRepaint();
    }

    protected void onProgressChange() {
        this.queueProgressUpdate();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.component;
        if (jPanel == null) {
            InlineProgressIndicator.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    boolean isCompact() {
        return this.isCompact;
    }

    TaskInfo getInfo() {
        return this.info;
    }

    public void dispose() {
        this.isDisposed = true;
    }

    private boolean isDisposed() {
        return this.isDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/InlineProgressIndicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/InlineProgressIndicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withBorder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEastButtons";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCompactTextAndProgress";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withBorder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTextValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setText2Value";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setProcessNameValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 9 -> new IllegalStateException(string);
        };
    }

    private final class MyComponent
    extends JPanel {
        private final boolean isCompact;
        private final JComponent myProcessName;

        private MyComponent(@NotNull boolean compact, JComponent processName) {
            if (processName == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            this.isCompact = compact;
            this.myProcessName = processName;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (UIUtil.isCloseClick((MouseEvent)e) && MyComponent.this.getBounds().contains(e.getX(), e.getY())) {
                        InlineProgressIndicator.this.cancelRequest();
                    }
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.isCompact) {
                super.paintComponent(g);
                return;
            }
            GraphicsConfig c = GraphicsUtil.setupAAPainting((Graphics)g);
            UISettings.setupAntialiasing((Graphics)g);
            int arc = 8;
            Color bg = this.getBackground();
            Rectangle bounds = this.myProcessName.getBounds();
            Rectangle label2 = SwingUtilities.convertRectangle(this.myProcessName.getParent(), bounds, this);
            g.setColor(UIUtil.getPanelBackground());
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            if (!StartupUiUtil.isUnderDarcula()) {
                bg = ColorUtil.toAlpha((Color)bg.darker().darker(), (int)230);
                g.setColor(bg);
                g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
                g.setColor(UIUtil.getPanelBackground());
                g.fillRoundRect(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2, arc, arc);
                g.fillRect(0, (int)label2.getMaxY() + 1, this.getWidth() - 1, this.getHeight() / 2);
            } else {
                bg = bg.brighter();
                g.setColor(bg);
                g.drawLine(0, (int)label2.getMaxY() + 1, this.getWidth() - 1, (int)label2.getMaxY() + 1);
            }
            g.setColor(bg);
            g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            c.restore();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processName", "com/intellij/openapi/wm/impl/status/InlineProgressIndicator$MyComponent", "<init>"));
        }
    }

    static final class ProgressButton {
        @NotNull
        final InplaceButton button;
        @NotNull
        final Runnable updateAction;

        ProgressButton(@NotNull InplaceButton button2, @NotNull Runnable updateAction2) {
            if (button2 == null) {
                ProgressButton.$$$reportNull$$$0(0);
            }
            if (updateAction2 == null) {
                ProgressButton.$$$reportNull$$$0(1);
            }
            this.button = button2;
            this.updateAction = updateAction2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "button";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "updateAction";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/status/InlineProgressIndicator$ProgressButton";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

