/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.ProgressComponent;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.TransparentPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PresentationModeProgressPanel {
    private final InfoAndProgressPanel.MyProgressComponent progress;
    private final JBIterable<ProgressComponent.ProgressButton> myEastButtons;
    private JLabel textLabel;
    private JProgressBar myProgressBar;
    private JLabel additionalTextLabel;
    private JPanel myRootPanel;
    private JPanel myButtonPanel;

    public PresentationModeProgressPanel(@NotNull InfoAndProgressPanel.MyProgressComponent progress) {
        if (progress == null) {
            PresentationModeProgressPanel.$$$reportNull$$$0(0);
        }
        this.progress = progress;
        this.$$$setupUI$$$();
        JBFont font = JBUI.Fonts.label((float)11.0f);
        this.textLabel.setFont((Font)font);
        this.additionalTextLabel.setFont((Font)font);
        this.textLabel.setText(" ");
        this.additionalTextLabel.setText(" ");
        this.myEastButtons = this.progress.createPresentationButtons();
        this.myButtonPanel.add(ProgressComponent.createButtonPanel((Iterable<? extends JComponent>)this.myEastButtons.map(progressButton -> {
            InplaceButton button2 = progressButton.button;
            button2.setMinimumSize(button2.getPreferredSize());
            return button2;
        })));
        this.myRootPanel.setPreferredSize((Dimension)new JBDimension(250, 60));
        this.myProgressBar.setPreferredSize(new Dimension(JBUIScale.scale((int)250), this.myProgressBar.getPreferredSize().height));
    }

    @NotNull
    private static Color getTextForeground() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground();
        if (color == null) {
            PresentationModeProgressPanel.$$$reportNull$$$0(1);
        }
        return color;
    }

    void update() {
        Color color = PresentationModeProgressPanel.getTextForeground();
        this.textLabel.setForeground(color);
        this.additionalTextLabel.setForeground(color);
        this.myProgressBar.setForeground(color);
        if (!StringUtil.equals((CharSequence)this.textLabel.getText(), (CharSequence)this.progress.getText())) {
            this.textLabel.setText(StringUtil.defaultIfEmpty((String)this.progress.getText(), (String)" "));
        }
        if (!StringUtil.equals((CharSequence)this.additionalTextLabel.getText(), (CharSequence)this.progress.getText2())) {
            this.additionalTextLabel.setText(StringUtil.defaultIfEmpty((String)this.progress.getText2(), (String)" "));
        }
        if ((this.progress.isIndeterminate() || this.progress.getFraction() == 0.0) != this.myProgressBar.isIndeterminate()) {
            this.myProgressBar.setIndeterminate(this.progress.isIndeterminate() || this.progress.getFraction() == 0.0);
            this.myProgressBar.revalidate();
        }
        if (!this.myProgressBar.isIndeterminate()) {
            this.myProgressBar.setValue((int)(this.progress.getFraction() * 99.0) + 1);
        }
        this.myEastButtons.forEach(b -> b.updateAction.run());
    }

    @NotNull
    public JComponent getProgressPanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            PresentationModeProgressPanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myRootPanel = new TransparentPanel(0.5f){

            public boolean isVisible() {
                if (!PresentationModeProgressPanel.this.progress.showInPresentationMode()) {
                    return false;
                }
                UISettings ui = UISettings.getInstance();
                return ui.getPresentationMode() || !ui.getShowStatusBar() && Registry.is((String)"ide.show.progress.without.status.bar");
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/PresentationModeProgressPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/PresentationModeProgressPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForeground";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JProgressBar jProgressBar;
        this.createUIComponents();
        JPanel jPanel2 = this.myRootPanel;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(false);
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.setOpaque(false);
        jPanel2.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myButtonPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.textLabel = jLabel2 = new JLabel();
        jLabel2.setAutoscrolls(true);
        jLabel2.setText("");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(209, -1), new Dimension(209, -1), new Dimension(209, -1)));
        this.additionalTextLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, new Dimension(209, -1), new Dimension(209, -1), new Dimension(209, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

