/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupWrapper;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WelcomeScreenCustomization;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionGroupPanelWrapper;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionsWithPanelProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.EmptyStateProjectsPanelKt;
import com.intellij.openapi.wm.impl.welcomeScreen.PanelState;
import com.intellij.openapi.wm.impl.welcomeScreen.ProjectsTabFactoryKt;
import com.intellij.openapi.wm.impl.welcomeScreen.TabbedWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenActionsUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenEventCollector;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenSettingsKt;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.ProjectCollectors;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectFilteringTree;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectPanelComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.statistics.WelcomeScreenCounterUsageCollector;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Placeholder;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.layout.ValueComponentPredicate;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/ProjectsTab;", "Lcom/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen$DefaultWelcomeScreenTab;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "isPanelEmptyPredicate", "Lcom/intellij/ui/layout/ValueComponentPredicate;", "notificationPanel", "Ljavax/swing/JComponent;", "buildComponent", "checkState", "", "updateComponent", "createRecentProjectsPanel", "createEmptyStatePanel", "initDnD", "component", "createActionsToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nProjectsTabFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectsTabFactory.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/ProjectsTab\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,306:1\n1#2:307\n*E\n"})
public final class ProjectsTab
extends TabbedWelcomeScreen.DefaultWelcomeScreenTab {
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private ValueComponentPredicate isPanelEmptyPredicate;
    @Nullable
    private JComponent notificationPanel;

    public ProjectsTab(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(IdeBundle.message((String)"welcome.screen.projects.title", (Object[])new Object[0]), WelcomeScreenEventCollector.TabType.TabNavProject);
        this.parentDisposable = parentDisposable;
        this.isPanelEmptyPredicate = new ValueComponentPredicate(true);
        MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect(this.parentDisposable);
        connect.subscribe(CloneableProjectsService.Companion.getTOPIC(), (Object)new CloneableProjectsService.CloneProjectListener(){

            @Override
            public void onCloneCanceled() {
            }

            @Override
            public void onCloneFailed() {
            }

            @Override
            public void onCloneSuccess() {
            }

            @Override
            public void onCloneAdded(ProgressIndicatorEx progressIndicator, TaskInfo taskInfo2) {
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                Intrinsics.checkNotNullParameter((Object)taskInfo2, (String)"taskInfo");
                this.checkState();
            }

            @Override
            public void onCloneRemoved() {
                this.checkState();
            }
        });
        connect.subscribe(RecentProjectsManager.Companion.getRECENT_PROJECTS_CHANGE_TOPIC(), (Object)new RecentProjectsManager.RecentProjectsChange(){

            public void change() {
                this.checkState();
            }
        });
        this.checkState();
    }

    @Override
    @NotNull
    protected JComponent buildComponent() {
        DialogPanel dialogPanel;
        int recentProjectsCount = RecentProjectListActionProvider.Companion.getInstance().countLocalProjects();
        int providerRecentProjectsCount = RecentProjectListActionProvider.Companion.getInstance().countProjectsFromProviders();
        WelcomeScreenCounterUsageCollector.INSTANCE.reportWelcomeScreenShowed(recentProjectsCount, providerRecentProjectsCount);
        JComponent promo = WelcomeScreenComponentFactory.getSinglePromotion(recentProjectsCount == 0);
        DialogPanel $this$buildComponent_u24lambda_u241 = dialogPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> ProjectsTab.buildComponent$lambda$0(promo, this, arg_0)));
        boolean bl = false;
        $this$buildComponent_u24lambda_u241.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        return (JComponent)dialogPanel;
    }

    private final void checkState() {
        this.isPanelEmptyPredicate.set(ProjectsTabFactoryKt.access$getCurrentState() == PanelState.EMPTY);
    }

    public void updateComponent() {
        ActionsKt.invokeLater$default(null, () -> ProjectsTab.updateComponent$lambda$0(this), (int)1, null);
    }

    private final JComponent createRecentProjectsPanel() {
        RecentProjectFilteringTree recentProjectTree = RecentProjectPanelComponentFactory.createComponent$default(this.parentDisposable, ProjectCollectors.all, null, 4, null);
        recentProjectTree.selectLastOpenedProject();
        JComponent jComponent = recentProjectTree.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent treeComponent = jComponent;
        SearchTextField projectSearch = recentProjectTree.installSearchField();
        if (ExperimentalUI.Companion.isNewUI()) {
            projectSearch.getTextEditor().putClientProperty((Object)"JTextField.Search.Icon", (Object)AllIcons.Actions.Search);
        }
        ActionToolbar actionsToolbar = this.createActionsToolbar();
        actionsToolbar.setTargetComponent(treeComponent);
        JBPanel jBPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> ProjectsTab.createRecentProjectsPanel$lambda$0(actionsToolbar, projectSearch, treeComponent, arg_0))).andTransparent();
        DialogPanel $this$createRecentProjectsPanel_u24lambda_u241 = (DialogPanel)jBPanel;
        boolean bl = false;
        $this$createRecentProjectsPanel_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)13, (int)12));
        Intrinsics.checkNotNull((Object)$this$createRecentProjectsPanel_u24lambda_u241);
        this.initDnD((JComponent)$this$createRecentProjectsPanel_u24lambda_u241);
        JBPanel jBPanel2 = jBPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel2, (String)"apply(...)");
        return (JComponent)jBPanel2;
    }

    private final JComponent createEmptyStatePanel() {
        JComponent jComponent;
        JComponent jComponent2;
        block2: {
            for (WelcomeScreenCustomization it : (Iterable)WelcomeScreenCustomization.WELCOME_SCREEN_CUSTOMIZATION.getExtensionList()) {
                boolean bl = false;
                JComponent jComponent3 = it.createMainEmptyState(this.parentDisposable);
                if (jComponent3 == null) continue;
                jComponent2 = jComponent3;
                break block2;
            }
            jComponent2 = jComponent = null;
        }
        if (jComponent2 == null) {
            jComponent = EmptyStateProjectsPanelKt.emptyStateProjectPanel(this.parentDisposable);
        }
        JComponent emptyStateProjectsPanel = jComponent;
        this.initDnD(emptyStateProjectsPanel);
        return emptyStateProjectsPanel;
    }

    private final void initDnD(JComponent component2) {
        DnDNativeTarget target = ProjectsTabFactoryKt.access$createDropFileTarget();
        DnDSupport.createBuilder((JComponent)component2).enableAsNativeTarget().setTargetChecker((DnDTargetChecker)target).setDropHandler((DnDDropHandler)target).setDisposableParent(this.parentDisposable).install();
    }

    private final ActionToolbar createActionsToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("WelcomeScreen.QuickStart.ProjectsState");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup baseGroup = (ActionGroup)anAction;
        ActionGroupWrapper toolbarGroup2 = new ActionGroupWrapper(baseGroup, this){
            private final ConcurrentHashMap<AnAction, AnAction> wrappers;
            final /* synthetic */ ProjectsTab this$0;
            {
                this.this$0 = $receiver;
                super($baseGroup);
                this.wrappers = new ConcurrentHashMap<K, V>();
            }

            public final ConcurrentHashMap<AnAction, AnAction> getWrappers() {
                return this.wrappers;
            }

            /*
             * WARNING - void declaration
             */
            public List<AnAction> postProcessVisibleChildren(AnActionEvent e, List<? extends AnAction> visibleChildren) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter(visibleChildren, (String)"visibleChildren");
                Iterable iterable = visibleChildren;
                ProjectsTab projectsTab = this.this$0;
                boolean $i$f$mapIndexed = false;
                void var7_8 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    AnAction anAction;
                    void action2;
                    void index;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    AnAction anAction2 = (AnAction)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    if (index >= WelcomeScreenSettingsKt.getWelcomeScreenPrimaryButtonsNum()) {
                        anAction = action2;
                    } else if (action2 instanceof ActionGroup && action2 instanceof ActionsWithPanelProvider) {
                        void $this$getOrPut$iv;
                        ConcurrentMap concurrentMap = this.wrappers;
                        void key$iv = action2;
                        boolean $i$f$getOrPut = false;
                        Object object = $this$getOrPut$iv.get(key$iv);
                        if (object == null) {
                            boolean bl2 = false;
                            AnAction default$iv = ActionGroupPanelWrapper.wrapGroups((ActionGroup)action2, ProjectsTab.access$getParentDisposable$p(projectsTab));
                            boolean bl3 = false;
                            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                            if (object == null) {
                                object = default$iv;
                            }
                        }
                        AnAction wrapper2 = (AnAction)object;
                        e.getUpdateSession().presentation(wrapper2);
                        anAction = wrapper2;
                    } else if (action2 instanceof ActionGroup) {
                        List list2 = e.getUpdateSession().children((ActionGroup)action2);
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"children(...)");
                        List children2 = CollectionsKt.toList((Iterable)list2);
                        if (children2.isEmpty()) {
                            anAction = action2;
                        } else {
                            AnAction anAction3;
                            AnAction first = (AnAction)CollectionsKt.first((List)children2);
                            if (first instanceof ActionGroup && first instanceof ActionsWithPanelProvider) {
                                void $this$getOrPut$iv;
                                ConcurrentMap $i$f$getOrPut = this.wrappers;
                                AnAction key$iv = first;
                                boolean $i$f$getOrPut2 = false;
                                Object object = $this$getOrPut$iv.get(key$iv);
                                if (object == null) {
                                    boolean bl4 = false;
                                    AnAction default$iv = ActionGroupPanelWrapper.wrapGroups((ActionGroup)first, ProjectsTab.access$getParentDisposable$p(projectsTab));
                                    boolean bl5 = false;
                                    object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                                    if (object == null) {
                                        object = default$iv;
                                    }
                                }
                                anAction3 = (AnAction)object;
                            } else {
                                anAction3 = first;
                            }
                            AnAction wrapper3 = anAction3;
                            e.getUpdateSession().presentation(wrapper3).putClientProperty(ActionUtil.INLINE_ACTIONS, children2.subList(1, children2.size()));
                            anAction = wrapper3;
                        }
                    } else {
                        anAction = action2;
                    }
                    collection.add(anAction);
                }
                List mapped = (List)destination$iv$iv;
                Iterable $this$forEach$iv = mapped;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    AnAction action3 = (AnAction)element$iv;
                    boolean bl = false;
                    e.getUpdateSession().presentation(action3).putClientProperty(ActionUtil.COMPONENT_PROVIDER, (Object)WelcomeScreenActionsUtil.createToolbarTextButtonAction(action3));
                }
                return mapped;
            }
        };
        ActionToolbarImpl toolbar2 = new ActionToolbarImpl(toolbarGroup2){

            protected boolean isSecondaryAction(AnAction action2, int actionIndex) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                return actionIndex >= WelcomeScreenSettingsKt.getWelcomeScreenPrimaryButtonsNum();
            }

            protected ActionButton createToolbarButton(AnAction action2, ActionButtonLook look, String place, Presentation presentation2, Supplier<? extends Dimension> minimumSize) {
                ActionButton actionButton;
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter(minimumSize, (String)"minimumSize");
                ActionButton $this$createToolbarButton_u24lambda_u240 = actionButton = super.createToolbarButton(action2, look, place, presentation2, minimumSize);
                boolean bl = false;
                $this$createToolbarButton_u24lambda_u240.setFocusable(true);
                return actionButton;
            }
        };
        toolbar2.setOpaque(false);
        toolbar2.setReservePlaceAutoPopupIcon(false);
        toolbar2.setSecondaryActionsIcon(AllIcons.Actions.More, true);
        String string = IdeBundle.message((String)"welcome.screen.more.actions.link.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        toolbar2.setSecondaryActionsTooltip(string);
        return toolbar2;
    }

    private static final Unit buildComponent$lambda$0(JComponent $promo, ProjectsTab this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new EmptySpacingConfiguration(), (Function1<? super Panel, Unit>)((Function1)arg_0 -> ProjectsTab.buildComponent$lambda$0$0($promo, this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit buildComponent$lambda$0$0(JComponent $promo, ProjectsTab this$0, Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        Panel.row$default($this$customizeSpacingConfiguration, null, arg_0 -> ProjectsTab.buildComponent$lambda$0$0$0(this$0, arg_0), 1, null).resizableRow();
        Panel.row$default($this$customizeSpacingConfiguration, null, arg_0 -> ProjectsTab.buildComponent$lambda$0$0$1(this$0, arg_0), 1, null);
        if ($promo != null) {
            Panel.row$default($this$customizeSpacingConfiguration, null, arg_0 -> ProjectsTab.buildComponent$lambda$0$0$2($promo, arg_0), 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildComponent$lambda$0$0$0(ProjectsTab this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Placeholder placeholder = $this$row.placeholder().align(Align.FILL);
        JComponent recentProjectsPanel = this$0.createRecentProjectsPanel();
        JComponent emptyStatePanel = this$0.createEmptyStatePanel();
        this$0.isPanelEmptyPredicate.addListener(arg_0 -> ProjectsTab.buildComponent$lambda$0$0$0$0(placeholder, emptyStatePanel, recentProjectsPanel, arg_0));
        placeholder.setComponent(this$0.isPanelEmptyPredicate.invoke() != false ? emptyStatePanel : recentProjectsPanel);
        return Unit.INSTANCE;
    }

    private static final Unit buildComponent$lambda$0$0$0$0(Placeholder $placeholder, JComponent $emptyStatePanel, JComponent $recentProjectsPanel, boolean isEmpty) {
        $placeholder.setComponent(isEmpty ? $emptyStatePanel : $recentProjectsPanel);
        return Unit.INSTANCE;
    }

    private static final Unit buildComponent$lambda$0$0$1(ProjectsTab this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = WelcomeScreenComponentFactory.createNotificationToolbar(this$0.parentDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createNotificationToolbar(...)");
        this$0.notificationPanel = $this$row.cell(jComponent).align(AlignX.RIGHT.INSTANCE).applyToComponent((Function1<JComponent, Unit>)((Function1)ProjectsTab::buildComponent$lambda$0$0$1$0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit buildComponent$lambda$0$0$1$0(JComponent $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
        return Unit.INSTANCE;
    }

    private static final Unit buildComponent$lambda$0$0$2(JComponent $promo, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($promo).customize(UnscaledGapsKt.UnscaledGaps((int)0, (int)16, (int)16, (int)16)).align(AlignX.FILL.INSTANCE).applyToComponent((Function1<JComponent, Unit>)((Function1)ProjectsTab::buildComponent$lambda$0$0$2$0));
        return Unit.INSTANCE;
    }

    private static final Unit buildComponent$lambda$0$0$2$0(JComponent $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
        return Unit.INSTANCE;
    }

    private static final Unit updateComponent$lambda$0(ProjectsTab this$0) {
        BalloonLayout balloonLayout;
        IdeFrame ideFrame = WelcomeFrame.Companion.getInstance();
        Object object = balloonLayout = ideFrame != null ? ideFrame.getBalloonLayout() : null;
        if (balloonLayout instanceof WelcomeBalloonLayoutImpl) {
            ((WelcomeBalloonLayoutImpl)balloonLayout).setLocationComponent(this$0.notificationPanel);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createRecentProjectsPanel$lambda$0(ActionToolbar $actionsToolbar, SearchTextField $projectSearch, JComponent $treeComponent, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, arg_0 -> ProjectsTab.createRecentProjectsPanel$lambda$0$0($actionsToolbar, arg_0), 1, null);
        Panel.row$default($this$panel, null, arg_0 -> ProjectsTab.createRecentProjectsPanel$lambda$0$1($projectSearch, arg_0), 1, null);
        Panel.separator$default($this$panel, null, 1, null);
        Panel.row$default($this$panel, null, arg_0 -> ProjectsTab.createRecentProjectsPanel$lambda$0$2($treeComponent, arg_0), 1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createRecentProjectsPanel$lambda$0$0(ActionToolbar $actionsToolbar, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = $actionsToolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent);
        return Unit.INSTANCE;
    }

    private static final Unit createRecentProjectsPanel$lambda$0$1(SearchTextField $projectSearch, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$projectSearch);
        return Unit.INSTANCE;
    }

    private static final Unit createRecentProjectsPanel$lambda$0$2(JComponent $treeComponent, Row $this$row) {
        JScrollPane jScrollPane;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JScrollPane $this$createRecentProjectsPanel_u24lambda_u240_u242_u240 = jScrollPane = ScrollPaneFactory.createScrollPane((Component)$treeComponent, (boolean)true);
        boolean bl = false;
        $this$createRecentProjectsPanel_u24lambda_u240_u242_u240.setHorizontalScrollBarPolicy(31);
        $this$createRecentProjectsPanel_u24lambda_u240_u242_u240.setOpaque(false);
        JScrollPane jScrollPane2 = jScrollPane;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"apply(...)");
        JScrollPane scrollPane = jScrollPane2;
        $this$row.cell((JComponent)scrollPane).align(Align.FILL);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Disposable access$getParentDisposable$p(ProjectsTab $this) {
        return $this.parentDisposable;
    }
}

