/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.impl.toolkit;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bg\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&J\b\u0010\u0007\u001a\u00020\bH&J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH&\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\bH&J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u0003*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/impl/toolkit/ClientGraphicsEnvironment;", "", "getNumScreens", "", "makeScreenDevice", "Ljava/awt/GraphicsDevice;", "id", "isDisplayLocal", "", "getScreenDevices", "", "()[Ljava/awt/GraphicsDevice;", "isInitialized", "findGraphicsConfigurationFor", "Ljava/awt/GraphicsConfiguration;", "bounds", "Ljava/awt/Rectangle;", "distanceTo", "pointX", "pointY", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClientGraphicsEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientGraphicsEnvironment.kt\ncom/intellij/platform/impl/toolkit/ClientGraphicsEnvironment\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n11561#2:40\n11896#2,3:41\n2393#3,14:44\n*S KotlinDebug\n*F\n+ 1 ClientGraphicsEnvironment.kt\ncom/intellij/platform/impl/toolkit/ClientGraphicsEnvironment\n*L\n26#1:40\n26#1:41,3\n26#1:44,14\n*E\n"})
public interface ClientGraphicsEnvironment {
    @NotNull
    public static final Companion Companion = com.intellij.platform.impl.toolkit.ClientGraphicsEnvironment$Companion.$$INSTANCE;

    public int getNumScreens();

    @NotNull
    public GraphicsDevice makeScreenDevice(int var1);

    public boolean isDisplayLocal();

    @NotNull
    public GraphicsDevice[] getScreenDevices();

    public boolean isInitialized();

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public GraphicsConfiguration findGraphicsConfigurationFor(@NotNull Rectangle bounds) {
        Object t;
        void $this$minBy$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        Object $this$map$iv = this.getScreenDevices();
        boolean $i$f$map = false;
        GraphicsDevice[] graphicsDeviceArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((GraphicsDevice[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var12_15 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDefaultConfiguration());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = minElem$iv;
        } else {
            GraphicsConfiguration it = (GraphicsConfiguration)minElem$iv;
            boolean bl = false;
            Rectangle rectangle = it.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
            int minValue$iv = this.distanceTo(rectangle, centerX, centerY);
            do {
                Object e$iv = iterator$iv.next();
                GraphicsConfiguration it2 = (GraphicsConfiguration)e$iv;
                $i$a$-minByOrThrow-ClientGraphicsEnvironment$findGraphicsConfigurationFor$2 = false;
                Rectangle rectangle2 = it2.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"getBounds(...)");
                int v$iv = this.distanceTo(rectangle2, centerX, centerY);
                if (minValue$iv <= v$iv) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = minElem$iv;
        }
        Intrinsics.checkNotNullExpressionValue(t, (String)"minBy(...)");
        return (GraphicsConfiguration)t;
    }

    private int distanceTo(Rectangle $this$distanceTo, int pointX, int pointY) {
        int distance = 0;
        if (pointX < $this$distanceTo.x) {
            distance += $this$distanceTo.x - pointX;
        }
        if (pointY < $this$distanceTo.y) {
            distance += $this$distanceTo.y - pointY;
        }
        if (pointX > $this$distanceTo.x + $this$distanceTo.width) {
            distance += pointX - $this$distanceTo.x - $this$distanceTo.width;
        }
        if (pointY > $this$distanceTo.y + $this$distanceTo.height) {
            distance += pointY - $this$distanceTo.y - $this$distanceTo.height;
        }
        return distance;
    }

    @JvmStatic
    @NotNull
    public static ClientGraphicsEnvironment getInstance(@NotNull ClientAppSession session) {
        return Companion.getInstance(session);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/impl/toolkit/ClientGraphicsEnvironment$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/impl/toolkit/ClientGraphicsEnvironment;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nClientGraphicsEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientGraphicsEnvironment.kt\ncom/intellij/platform/impl/toolkit/ClientGraphicsEnvironment$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,39:1\n30#2,2:40\n*S KotlinDebug\n*F\n+ 1 ClientGraphicsEnvironment.kt\ncom/intellij/platform/impl/toolkit/ClientGraphicsEnvironment$Companion\n*L\n15#1:40,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ClientGraphicsEnvironment getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<ClientGraphicsEnvironment> serviceClass$iv = ClientGraphicsEnvironment.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ClientGraphicsEnvironment)object;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

