/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextIcon
implements Icon {
    private static final Logger LOG = Logger.getInstance(TextIcon.class);
    private final Insets myInsets = new Insets(0, 0, 0, 0);
    private Integer myRound;
    private Boolean withBorders;
    private Color myBackground;
    private Color myForeground;
    private Color myBorderColor;
    private Font myFont;
    private String myText;
    private Rectangle myStabilizedTextBounds;
    private FontRenderContext myContext;
    private AffineTransform myFontTransform;
    private List<String> myTextsForMinimumBounds;
    private Rectangle myMinimumTextBounds;
    private Rectangle myCurrentTextBounds;
    private int myFontSize;
    private int myFontStyle;

    private Rectangle getTextBounds() {
        if (this.myStabilizedTextBounds != null && this.myFont != null && (this.myFontSize != this.myFont.getSize() || this.myFontStyle != this.myFont.getStyle())) {
            this.myMinimumTextBounds = null;
            this.myCurrentTextBounds = null;
            this.myStabilizedTextBounds = null;
        }
        if (this.myStabilizedTextBounds == null && this.myFont != null && this.myText != null && !this.myText.isEmpty()) {
            this.myFontSize = this.myFont.getSize();
            this.myFontStyle = this.myFont.getStyle();
            this.myContext = TextIcon.createContext();
            Font fnt = this.myFontTransform == null ? this.myFont : this.myFont.deriveFont(this.myFontTransform);
            this.myStabilizedTextBounds = this.myCurrentTextBounds = TextIcon.getPixelBoundsWithPadding(fnt, this.myText, this.myContext);
            if (this.myTextsForMinimumBounds != null) {
                boolean debug = LOG.isDebugEnabled();
                if (this.myMinimumTextBounds == null) {
                    for (String text2 : this.myTextsForMinimumBounds) {
                        Rectangle bounds = TextIcon.getPixelBoundsWithPadding(fnt, text2, this.myContext);
                        if (debug) {
                            LOG.debug("Bounds for text \"" + text2 + "\" are: " + String.valueOf(bounds));
                        }
                        this.myMinimumTextBounds = TextIcon.max(this.myMinimumTextBounds, bounds);
                    }
                }
                this.myStabilizedTextBounds = TextIcon.max(this.myMinimumTextBounds, this.myStabilizedTextBounds);
                if (debug) {
                    LOG.debug("StabilizedTextBounds for text \"" + this.myText + "\" are: " + String.valueOf(this.myStabilizedTextBounds));
                }
            }
            if (this.myFontTransform != null) {
                try {
                    AffineTransform reverseTransform = this.myFontTransform.createInverse();
                    this.myStabilizedTextBounds = TextIcon.applyTransform(this.myStabilizedTextBounds, reverseTransform);
                    this.myCurrentTextBounds = TextIcon.applyTransform(this.myCurrentTextBounds, reverseTransform);
                }
                catch (NoninvertibleTransformException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return this.myStabilizedTextBounds;
    }

    @NotNull
    private static Rectangle max(@Nullable Rectangle one, @NotNull Rectangle other) {
        if (other == null) {
            TextIcon.$$$reportNull$$$0(0);
        }
        if (one == null) {
            Rectangle rectangle = other;
            if (rectangle == null) {
                TextIcon.$$$reportNull$$$0(1);
            }
            return rectangle;
        }
        if (LOG.isDebugEnabled() && (one.x != other.x || one.y != other.y)) {
            LOG.debug("Attention. Unequal starting points: " + String.valueOf(one) + ", other = " + String.valueOf(other));
        }
        return new Rectangle(Math.min(one.x, other.x), Math.min(one.y, other.y), Math.max(one.width, other.width), Math.max(one.height, other.height));
    }

    public TextIcon(String text2, Color foreground, Color background, int margin) {
        this(text2, foreground, background, margin, false);
    }

    public TextIcon(String text2, Color foreground, Color background, int margin, boolean withBorders) {
        this(text2, foreground, background, margin, withBorders, withBorders ? 255 : 0);
    }

    public TextIcon(String text2, Color foreground, Color background, int margin, boolean withBorders, int borderAlpha) {
        this(text2, foreground, background, ColorUtil.toAlpha((Color)background, (int)borderAlpha), margin, withBorders);
    }

    public TextIcon(String text2, Color foreground, Color background, Color borderColor, int margin, boolean withBorders) {
        this.setWithBorders(withBorders);
        this.setBackground(background);
        this.setForeground(foreground);
        this.setBorderColor(borderColor);
        this.setInsets(margin, margin, margin, margin);
        this.setRound(margin * 4);
        this.setText(text2);
    }

    public AffineTransform getFontTransform() {
        return this.myFontTransform;
    }

    public void setFontTransform(AffineTransform fontTransform) {
        this.myFontTransform = fontTransform;
        this.myMinimumTextBounds = null;
        this.myStabilizedTextBounds = null;
        this.myCurrentTextBounds = null;
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.myInsets.set(top, left, bottom, right);
    }

    public void setInsets(Insets insets) {
        this.myInsets.set(insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setRound(int round) {
        this.myRound = round;
    }

    public void setWithBorders(boolean withBorders) {
        this.withBorders = withBorders;
    }

    public void setBackground(Color background) {
        this.myBackground = background;
    }

    public void setForeground(Color foreground) {
        this.myForeground = foreground;
    }

    public void setBorderColor(Color borderColor) {
        this.myBorderColor = borderColor;
    }

    public void setText(String text2) {
        this.myStabilizedTextBounds = null;
        this.myText = text2;
        this.myCurrentTextBounds = null;
    }

    public void setFont(Font font) {
        this.myFont = font;
        this.myStabilizedTextBounds = null;
        this.myMinimumTextBounds = null;
        this.myCurrentTextBounds = null;
    }

    public void setTextsForMinimumBounds(List<String> textsForMinimumBounds) {
        this.myTextsForMinimumBounds = textsForMinimumBounds;
        this.myStabilizedTextBounds = null;
        this.myMinimumTextBounds = null;
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    public Integer getRound() {
        return this.myRound;
    }

    public Boolean getWithBorders() {
        return this.withBorders;
    }

    public Color getBackground() {
        return this.myBackground;
    }

    public Color getForeground() {
        return this.myForeground;
    }

    public Color getBorderColor() {
        return this.myBorderColor;
    }

    public Font getFont() {
        return this.myFont;
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public int getIconWidth() {
        Rectangle bounds = this.getTextBounds();
        return bounds == null ? 0 : this.myInsets.left + bounds.width + this.myInsets.right;
    }

    @Override
    public int getIconHeight() {
        Rectangle bounds = this.getTextBounds();
        return bounds == null ? 0 : this.myInsets.top + bounds.height + this.myInsets.bottom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        InternalUICustomization customization = InternalUICustomization.getInstance();
        if (customization != null) {
            g = customization.preserveGraphics(g);
        }
        if (g instanceof Graphics2D) {
            if (this.myBackground != null) {
                g.setColor(this.myBackground);
                RectanglePainter.FILL.paint((Graphics2D)g, x, y, this.getIconWidth(), this.getIconHeight(), (Object)this.myRound);
            }
            if (this.withBorders.booleanValue() && this.myBorderColor != null) {
                g.setColor(this.myBorderColor);
                RectanglePainter.DRAW.paint((Graphics2D)g, x, y, this.getIconWidth(), this.getIconHeight(), (Object)this.myRound);
            }
        }
        Rectangle bounds = this.getTextBounds();
        Rectangle currentTextBounds = this.myCurrentTextBounds;
        if (this.myForeground != null && bounds != null) {
            int widthDelta = (bounds.width - currentTextBounds.width) / 2;
            int heightDelta = (bounds.height - currentTextBounds.height) / 2;
            Graphics2D g2d = (Graphics2D)g.create(this.myInsets.left + x + widthDelta, this.myInsets.top + y + heightDelta, currentTextBounds.width, currentTextBounds.height);
            try {
                Object textLcdContrast = UIManager.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                if (textLcdContrast == null) {
                    textLcdContrast = UIUtil.getLcdContrastValue();
                }
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.myContext.getAntiAliasingHint());
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, textLcdContrast);
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.myContext.getFractionalMetricsHint());
                g2d.setColor(this.myForeground);
                g2d.setFont(this.myFont);
                g2d.drawString(this.myText, -bounds.x, -bounds.y);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Drawing \"" + this.myText + "\" at " + x + ", " + y + ", insets " + String.valueOf(this.myInsets) + ", with bounds " + String.valueOf(bounds) + " and currentTextBounds " + String.valueOf(currentTextBounds));
                }
            }
            finally {
                g2d.dispose();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextIcon icon2 = (TextIcon)o;
        return this.myInsets.equals(icon2.myInsets) && Objects.equals(this.myRound, icon2.myRound) && Objects.equals(this.myBackground, icon2.myBackground) && Objects.equals(this.myForeground, icon2.myForeground) && Objects.equals(this.myFont, icon2.myFont) && Objects.equals(this.myText, icon2.myText) && Objects.equals(this.myStabilizedTextBounds, icon2.myStabilizedTextBounds) && Objects.equals(this.myTextsForMinimumBounds, icon2.myTextsForMinimumBounds) && Objects.equals(this.withBorders, icon2.withBorders) && Objects.equals(this.myBorderColor, icon2.myBorderColor);
    }

    public int hashCode() {
        return Objects.hash(this.myInsets, this.myRound, this.myBackground, this.myForeground, this.myFont, this.myText, this.myStabilizedTextBounds, this.myTextsForMinimumBounds, this.withBorders, this.myBorderColor);
    }

    private static Rectangle applyTransform(Rectangle srcRect, AffineTransform at) {
        Point2D leftTop = at.transform(new Point(srcRect.x, srcRect.y), null);
        Point2D rightBottom = at.transform(new Point(srcRect.x + srcRect.width, srcRect.y + srcRect.height), null);
        int left = (int)Math.floor(leftTop.getX());
        int top = (int)Math.floor(leftTop.getY());
        int right = (int)Math.ceil(rightBottom.getX());
        int bottom = (int)Math.ceil(rightBottom.getY());
        return new Rectangle(left, top, right - left, bottom - top);
    }

    private static Rectangle getPixelBoundsWithPadding(Font font, String text2, FontRenderContext context) {
        Rectangle rectangle = font.hasLayoutAttributes() ? new TextLayout(text2, font, context).getPixelBounds(context, 0.0f, 0.0f) : font.createGlyphVector(context, text2).getPixelBounds(context, 0.0f, 0.0f);
        return new Rectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
    }

    private static FontRenderContext createContext() {
        Object fmHint;
        Object aaHint = UIManager.get(RenderingHints.KEY_TEXT_ANTIALIASING);
        if (aaHint == null) {
            aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
        }
        if ((fmHint = UIManager.get(RenderingHints.KEY_FRACTIONALMETRICS)) == null) {
            fmHint = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
        }
        return new FontRenderContext(null, aaHint, fmHint);
    }

    public void uiSettingsChanged() {
        this.myStabilizedTextBounds = null;
        this.myMinimumTextBounds = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/TextIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/TextIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "max";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "max";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

