/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImplKt;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.platform.jbr.JdkEx;
import com.intellij.ui.mac.MacWinTabsHandler;
import com.intellij.ui.mac.WindowTabsComponent;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MacWinTabsHandlerV2
extends MacWinTabsHandler {
    private static final String WINDOW_TABS_CONTAINER = "WINDOW_TABS_CONTAINER_KEY";

    @NotNull
    static JComponent _createAndInstallHandlerComponent(@NotNull JRootPane rootPane) {
        if (rootPane == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(0);
        }
        JPanel tabsContainer = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                InternalUICustomization customization = InternalUICustomization.getInstance();
                if (customization != null && customization.paintProjectTabsContainer(this, g)) {
                    return;
                }
                super.paintComponent(g);
            }
        };
        tabsContainer.setVisible(false);
        rootPane.putClientProperty(WINDOW_TABS_CONTAINER, tabsContainer);
        rootPane.putClientProperty("Window.transparentTitleBarHeight", 28);
        JPanel jPanel = tabsContainer;
        if (jPanel == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    static void _fastInit(@NotNull IdeFrameImpl frame) {
        if (frame == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(2);
        }
        if (JdkEx.setTabbingMode((Window)frame, (String)MacWinTabsHandlerV2.getWindowId(), null)) {
            Foundation.invoke((String)"NSWindow", (String)"setAllowsAutomaticWindowTabbing:", (Object[])new Object[]{true});
        }
    }

    public MacWinTabsHandlerV2(@NotNull IdeFrameImpl frame, @NotNull CoroutineScope coroutineScope) {
        if (frame == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(3);
        }
        if (coroutineScope == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(4);
        }
        super(frame, coroutineScope);
    }

    @Override
    protected boolean initFrame(@NotNull IdeFrameImpl frame, @NotNull CoroutineScope coroutineScope) {
        boolean allowed;
        if (frame == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(5);
        }
        if (coroutineScope == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(6);
        }
        if (allowed = JdkEx.setTabbingMode((Window)frame, (String)MacWinTabsHandlerV2.getWindowId(), null)) {
            Foundation.invoke((String)"NSWindow", (String)"setAllowsAutomaticWindowTabbing:", (Object[])new Object[]{true});
            IdeGlassPaneImplKt.executeOnCancelInEdt(coroutineScope, (Function0<Unit>)((Function0)() -> {
                this.updateTabBars(false);
                return Unit.INSTANCE;
            }));
            WindowTabsComponent.registerFrameDockContainer(frame, coroutineScope);
        }
        return allowed;
    }

    @Override
    public void setProject() {
        ApplicationManager.getApplication().invokeLater(() -> this.updateTabBars(true));
    }

    @Override
    public void enteringFullScreen() {
    }

    @Override
    public void enterFullScreen() {
        if (!this.myFrame.isDisplayable() || !this.myFrame.isShowing()) {
            return;
        }
        Point locationOnScreen = this.myFrame.getLocationOnScreen();
        if (this.myFrame.getWidth() == 0 || this.myFrame.getHeight() == 0 || locationOnScreen.x > 0 || locationOnScreen.y > 0) {
            MacWinTabsHandlerV2.handleFullScreenResize(this.myFrame);
        }
    }

    @Override
    public void exitFullScreen() {
    }

    @Nullable
    private static TabsInfo getTabsInfo(IdeFrame @NotNull [] helpers, @NotNull IdeFrameImpl window) {
        int allLength;
        if (window == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(7);
        }
        if (helpers == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(8);
        }
        if ((allLength = helpers.length) < 2) {
            return null;
        }
        ID tabs = Foundation.invoke((ID)MacUtil.getWindowFromJavaWindow((Window)window), (String)"tabbedWindows", (Object[])new Object[0]);
        int length = Foundation.invoke((ID)tabs, (String)"count", (Object[])new Object[0]).intValue();
        if (length < 2) {
            return null;
        }
        if (allLength < length) {
            return null;
        }
        HashMap<IdeFrameImpl, ProjectFrameHelper> helpersMap = new HashMap<IdeFrameImpl, ProjectFrameHelper>();
        ID[] allWindows = new ID[allLength];
        IdeFrameImpl[] allFrames = new IdeFrameImpl[allLength];
        for (int i2 = 0; i2 < allLength; ++i2) {
            ProjectFrameHelper helper = (ProjectFrameHelper)helpers[i2];
            IdeFrameImpl frame = helper.getFrame();
            helpersMap.put(frame, helper);
            allFrames[i2] = frame;
            allWindows[i2] = MacUtil.getWindowFromJavaWindow((Window)frame);
        }
        IdeFrameImpl[] frames = new IdeFrameImpl[length];
        int founded = 0;
        for (int i3 = 0; i3 < allLength && founded < length; ++i3) {
            int index = Foundation.invoke((ID)tabs, (String)"indexOfObject:", (Object[])new Object[]{allWindows[i3]}).intValue();
            if (index == -1) continue;
            frames[index] = allFrames[i3];
            ++founded;
        }
        return new TabsInfo(frames, helpersMap);
    }

    private void updateTabBars(boolean create2) {
        IdeFrame[] helpers = WindowManager.getInstance().getAllProjectFrames();
        if (create2) {
            TabsInfo info = MacWinTabsHandlerV2.getTabsInfo(helpers, this.myFrame);
            if (info == null) {
                return;
            }
            int index = ArrayUtil.indexOfIdentity((Object[])info.frames, (Object)this.myFrame);
            for (IdeFrameImpl frame : info.frames) {
                if (frame == this.myFrame || MacWinTabsHandlerV2.isTabsNotVisible(frame)) {
                    MacWinTabsHandlerV2.createTabBarsForFrame(frame, info.helpersMap.get(frame), info.frames);
                    continue;
                }
                MacWinTabsHandlerV2.insertTabForFrame(frame, this.myFrame, index);
            }
        } else {
            for (IdeFrame _helper : helpers) {
                IdeFrameImpl frame;
                ProjectFrameHelper helper = (ProjectFrameHelper)_helper;
                if (helper.isDisposed() || (frame = helper.getFrame()) == this.myFrame) continue;
                MacWinTabsHandlerV2.removeFromFrame(frame, this.myFrame);
            }
        }
    }

    private static void createTabBarsForFrame(@NotNull IdeFrameImpl frame, @NotNull ProjectFrameHelper helper, IdeFrameImpl @NotNull [] tabFrames) {
        if (frame == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(9);
        }
        if (helper == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(10);
        }
        if (tabFrames == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(11);
        }
        WindowTabsComponent tabs = new WindowTabsComponent(frame, helper.getProject(), helper.createDisposable());
        JPanel parentComponent = MacWinTabsHandlerV2.getTabsContainer(frame);
        parentComponent.add((Component)((Object)tabs));
        tabs.createTabsForFrame(tabFrames);
        boolean oldVisible = parentComponent.isVisible();
        parentComponent.setVisible(true);
        Container parent = parentComponent.getParent();
        if (parent == null || oldVisible) {
            return;
        }
        parent.doLayout();
        parent.revalidate();
        parent.repaint();
        InternalUICustomization customization = InternalUICustomization.getInstance();
        if (customization != null) {
            customization.createProjectTab(frame, tabs);
        }
    }

    private static void insertTabForFrame(@NotNull IdeFrameImpl frame, @NotNull IdeFrameImpl tab, int index) {
        if (frame == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(12);
        }
        if (tab == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(13);
        }
        Objects.requireNonNull(MacWinTabsHandlerV2.getTabsComponent(MacWinTabsHandlerV2.getTabsContainer(frame))).insertTabForFrame(tab, index);
    }

    private static void removeFromFrame(@NotNull IdeFrameImpl frame, @Nullable IdeFrameImpl tab) {
        JPanel parentComponent;
        WindowTabsComponent tabs;
        if (frame == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(14);
        }
        if ((tabs = MacWinTabsHandlerV2.getTabsComponent(parentComponent = MacWinTabsHandlerV2.getTabsContainer(frame))) == null) {
            return;
        }
        if (tab == null || tabs.removeTabFromFrame(tab)) {
            parentComponent.remove((Component)((Object)tabs));
            parentComponent.setVisible(false);
            tabs.selfDispose();
            Container parent = parentComponent.getParent();
            if (parent != null) {
                parent.doLayout();
                parent.revalidate();
                parent.repaint();
            }
        }
    }

    static boolean isTabsNotVisible(IdeFrameImpl frame) {
        return MacWinTabsHandlerV2.getTabsComponent(MacWinTabsHandlerV2.getTabsContainer(frame)) == null;
    }

    @NotNull
    static JPanel getTabsContainer(@NotNull IdeFrameImpl frame) {
        if (frame == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(15);
        }
        JPanel jPanel = (JPanel)frame.getRootPane().getClientProperty(WINDOW_TABS_CONTAINER);
        if (jPanel == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(16);
        }
        return jPanel;
    }

    @Nullable
    static WindowTabsComponent getTabsComponent(JPanel parentComponent) {
        return parentComponent.getComponentCount() != 1 ? null : (WindowTabsComponent)((Object)parentComponent.getComponent(0));
    }

    static void updateTabBarsAfterMerge() {
        IdeFrame[] helpers = WindowManager.getInstance().getAllProjectFrames();
        if (helpers.length == 0) {
            return;
        }
        for (IdeFrame helper : helpers) {
            MacWinTabsHandlerV2.removeFromFrame(((ProjectFrameHelper)helper).getFrame(), null);
        }
        TabsInfo info = Objects.requireNonNull(MacWinTabsHandlerV2.getTabsInfo(helpers, ((ProjectFrameHelper)helpers[0]).getFrame()));
        for (IdeFrameImpl frame : info.frames) {
            MacWinTabsHandlerV2.createTabBarsForFrame(frame, info.helpersMap.get(frame), info.frames);
        }
    }

    static void updateTabBarsAfterMove(@NotNull IdeFrameImpl movedFrame, @Nullable IdeFrameImpl target, int index) {
        IdeFrame[] helpers;
        if (movedFrame == null) {
            MacWinTabsHandlerV2.$$$reportNull$$$0(17);
        }
        for (IdeFrame helper : helpers = WindowManager.getInstance().getAllProjectFrames()) {
            IdeFrameImpl frame = ((ProjectFrameHelper)helper).getFrame();
            if (frame == movedFrame || frame == target) continue;
            MacWinTabsHandlerV2.removeFromFrame(frame, movedFrame);
        }
        MacWinTabsHandlerV2.removeFromFrame(movedFrame, null);
        if (target == null) {
            return;
        }
        TabsInfo info = Objects.requireNonNull(MacWinTabsHandlerV2.getTabsInfo(helpers, target));
        for (IdeFrameImpl frame : info.frames) {
            if (frame == movedFrame || index == -1) {
                MacWinTabsHandlerV2.createTabBarsForFrame(frame, info.helpersMap.get(frame), info.frames);
                continue;
            }
            MacWinTabsHandlerV2.insertTabForFrame(frame, movedFrame, index);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPane";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/MacWinTabsHandlerV2";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpers";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabFrames";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/MacWinTabsHandlerV2";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "_createAndInstallHandlerComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabsContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "_createAndInstallHandlerComponent";
                break;
            }
            case 1: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_fastInit";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initFrame";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTabsInfo";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTabBarsForFrame";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertTabForFrame";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeFromFrame";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTabsContainer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateTabBarsAfterMove";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 16 -> new IllegalStateException(string);
        };
    }

    private static final class TabsInfo {
        final IdeFrameImpl @NotNull [] frames;
        @NotNull
        final Map<IdeFrameImpl, ProjectFrameHelper> helpersMap;

        private TabsInfo(IdeFrameImpl @NotNull [] frames, @NotNull Map<IdeFrameImpl, ProjectFrameHelper> helpersMap) {
            if (helpersMap == null) {
                TabsInfo.$$$reportNull$$$0(0);
            }
            if (frames == null) {
                TabsInfo.$$$reportNull$$$0(1);
            }
            this.frames = frames;
            this.helpersMap = helpersMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helpersMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "frames";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/mac/MacWinTabsHandlerV2$TabsInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

