/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Future;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class Helpers {
    private static final Logger LOG = Logger.getInstance(Helpers.class);
    private static final String MODEL_ID_PREFIX = "Model Identifier:";
    @NonNls
    private static final String TB_SERVER_PROCESS = "TouchBarServer";
    private static final boolean FORCE_PHYSICAL_ESC = Boolean.getBoolean("touchbar.physical.esc");
    private static Boolean ourIsPhysicalEsc = null;
    private static Future<?> ourIsPhysicalEscFuture = null;

    static void emulateKeyPress(int javaKeyEventCode) {
        EventQueue systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        systemEventQueue.postEvent(new KeyEvent(new JPanel(), 401, System.currentTimeMillis(), 0, javaKeyEventCode, '\uffff'));
        systemEventQueue.postEvent(new KeyEvent(new JPanel(), 402, System.currentTimeMillis(), 0, javaKeyEventCode, '\uffff'));
    }

    @VisibleForTesting
    public static boolean isTouchBarServerRunning() {
        GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"pgrep", TB_SERVER_PROCESS}).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.SYSTEM);
        try {
            ProcessOutput out2 = ExecUtil.execAndGetOutput((GeneralCommandLine)cmdLine);
            return !out2.getStdout().isEmpty();
        }
        catch (ExecutionException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public static boolean restartTouchBarServer() {
        try {
            GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"pkill", TB_SERVER_PROCESS}).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.SYSTEM);
            ProcessOutput out2 = ExecUtil.sudoAndGetOutput((GeneralCommandLine)cmdLine, (String)"");
            return out2.getStderr().isEmpty();
        }
        catch (ExecutionException | IOException e) {
            LOG.debug(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppId() {
        String appId;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        ID nativePool = Foundation.invoke((String)"NSAutoreleasePool", (String)"new", (Object[])new Object[0]);
        try {
            ID bundle = Foundation.invoke((String)"NSBundle", (String)"mainBundle", (Object[])new Object[0]);
            ID dict = Foundation.invoke((ID)bundle, (String)"infoDictionary", (Object[])new Object[0]);
            ID nsAppID = Foundation.invoke((ID)dict, (String)"objectForKey:", (Object[])new Object[]{Foundation.nsString((String)"CFBundleIdentifier")});
            appId = Foundation.toStringViaUTF8((ID)nsAppID);
        }
        finally {
            Foundation.invoke((ID)nativePool, (String)"release", (Object[])new Object[0]);
        }
        if (appId == null || appId.isEmpty()) {
            LOG.error("can't obtain application id from NSBundle.mainBundle");
        }
        return appId;
    }

    public static boolean isPhisycalEsc() {
        if (FORCE_PHYSICAL_ESC) {
            return true;
        }
        if (ourIsPhysicalEsc != null) {
            return ourIsPhysicalEsc;
        }
        if (ourIsPhysicalEscFuture != null) {
            if (!ourIsPhysicalEscFuture.isDone()) {
                return false;
            }
            ourIsPhysicalEscFuture = null;
            return ourIsPhysicalEsc;
        }
        ourIsPhysicalEsc = false;
        @NotNull Application app = ApplicationManager.getApplication();
        ourIsPhysicalEscFuture = app.executeOnPooledThread(() -> {
            GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"system_profiler", TB_SERVER_PROCESS});
            cmdLine.addParameter("SPHardwareDataType");
            try {
                ProcessOutput out2 = ExecUtil.execAndGetOutput((GeneralCommandLine)cmdLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.SYSTEM));
                LOG.debug("SPHardwareDataType output:");
                for (String line : out2.getStdoutLines(true)) {
                    LOG.debug("\t" + line);
                    String tline = line.trim();
                    if (!tline.startsWith(MODEL_ID_PREFIX)) continue;
                    String model2 = tline.substring(MODEL_ID_PREFIX.length()).trim();
                    ourIsPhysicalEsc = model2.contains("16") || model2.equals("MacBookPro17,1");
                }
                LOG.debug("\tourIsPhysicalEsc=" + ourIsPhysicalEsc);
            }
            catch (ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            return ourIsPhysicalEsc;
        });
        return false;
    }

    @Nullable
    static Component getCurrentFocusComponent() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        if (focusOwner == null) {
            focusOwner = focusManager.getPermanentFocusOwner();
        }
        if (focusOwner == null) {
            return focusManager.getFocusedWindow();
        }
        return focusOwner;
    }

    @NotNull
    static String getActionId(@NotNull AnAction action2) {
        AnAction anAction;
        if (action2 == null) {
            Helpers.$$$reportNull$$$0(0);
        }
        ActionManager actionManager = ActionManager.getInstance();
        if (action2 instanceof CustomisedActionGroup) {
            CustomisedActionGroup o = (CustomisedActionGroup)action2;
            anAction = o.getDelegate();
        } else {
            anAction = action2;
        }
        String actionId = actionManager.getId(anAction);
        String string = actionId == null ? action2.toString() : actionId;
        if (string == null) {
            Helpers.$$$reportNull$$$0(1);
        }
        return string;
    }

    static void collectLeafActions(@NotNull ActionGroup actionGroup, @NotNull Collection<? super AnAction> out2) {
        AnAction[] actions;
        if (actionGroup == null) {
            Helpers.$$$reportNull$$$0(2);
        }
        if (out2 == null) {
            Helpers.$$$reportNull$$$0(3);
        }
        for (AnAction childAction : actions = actionGroup.getChildren(null)) {
            if (childAction == null) continue;
            if (childAction instanceof ActionGroup) {
                ActionGroup childGroup = (ActionGroup)childAction;
                Helpers.collectLeafActions(childGroup, out2);
                continue;
            }
            if (childAction instanceof Separator) continue;
            out2.add((AnAction)childAction);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/Helpers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/Helpers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectLeafActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

