/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.buildData.productInfo.ProductInfoLaunchData;
import com.intellij.platform.ide.productInfo.IdeProductInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.system.OS;
import com.intellij.util.ui.StartupUiUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Restarter {
    private static final String SPECIAL_EXIT_CODE_FOR_RESTART_ENV_VAR = "IDEA_RESTART_VIA_EXIT_CODE";
    private static volatile boolean copyRestarterFiles = false;
    private static volatile List<String> mainAppArgs = List.of();
    private static volatile Map<String, String> restarterEnv = Map.of();
    private static final NullableLazyValue<Path> ourLauncherWithoutRemoteDevOverride = NullableLazyValue.lazyNullable(() -> {
        String baseName = ApplicationNamesInfo.getInstance().getScriptName();
        Path launcher = switch (OS.CURRENT) {
            case OS.Windows -> PathManager.getBinDir().resolve(baseName + (Boolean.getBoolean("ide.native.launcher") ? "64.exe" : ".bat"));
            case OS.macOS -> PathManager.getHomeDir().resolve("MacOS").resolve(baseName);
            case OS.Linux -> PathManager.getBinDir().resolve(baseName + (Boolean.getBoolean("ide.native.launcher") ? "" : ".sh"));
            default -> null;
        };
        return launcher != null && Files.exists(launcher, new LinkOption[0]) ? launcher : null;
    });
    private static final NullableLazyValue<Path> ourLauncher = NullableLazyValue.lazyNullable(() -> {
        Path launcher;
        if (Boolean.getBoolean("ide.started.from.remote.dev.launcher")) {
            launcher = PathManager.getBinDir().resolve("remote-dev-server" + (OS.CURRENT == OS.Windows ? ".exe" : ""));
            if (Files.exists(launcher, new LinkOption[0])) {
                return launcher;
            }
            Logger.getInstance(Restarter.class).error("RemDev starter property is set, but launcher file at " + String.valueOf(launcher) + " was not found? Will restart using default entry point");
        }
        if ((launcher = (Path)ourLauncherWithoutRemoteDevOverride.getValue()) != null) {
            return launcher;
        }
        if (PlatformUtils.isJetBrainsClient()) {
            Path hostLauncher;
            List launchData = IdeProductInfo.getInstance().getCurrentProductInfo().getLaunch();
            if (launchData.size() == 1 && Files.exists(hostLauncher = PathManager.getHomeDir().resolve(OS.CURRENT == OS.macOS ? "Resources/product-info.json" : "product-info.json").getParent().resolve(((ProductInfoLaunchData)launchData.getFirst()).getLauncherPath()).normalize(), new LinkOption[0])) {
                return hostLauncher;
            }
            Logger.getInstance(Restarter.class).error("Cannot find an actual launcher for the frontend");
        }
        return null;
    });
    private static final Supplier<Boolean> ourRestartSupported = new SynchronizedClearableLazy(() -> {
        Object problem;
        String restartExitCode = EnvironmentUtil.getValue((String)SPECIAL_EXIT_CODE_FOR_RESTART_ENV_VAR);
        if (restartExitCode != null) {
            try {
                int code = Integer.parseInt(restartExitCode);
                if (code >= 0 && code <= 255) {
                    return true;
                }
                problem = "Requested exit code out of range (" + code + ")";
            }
            catch (NumberFormatException ex) {
                problem = "IDEA_RESTART_VIA_EXIT_CODE contains a value that can't be parsed as an integer (" + restartExitCode + ")";
            }
        } else {
            problem = OS.CURRENT == OS.Windows ? (ourLauncher.getValue() == null ? "cannot find the launcher executable in " + String.valueOf(PathManager.getBinDir()) : Restarter.checkRestarter("restarter.exe")) : (OS.CURRENT == OS.macOS ? (ourLauncher.getValue() == null ? "cannot find the launcher executable in " + String.valueOf(PathManager.getHomeDir().resolve("MacOS")) : Restarter.checkRestarter("restarter")) : (OS.CURRENT == OS.Linux ? (ourLauncher.getValue() == null ? "cannot find the launcher executable in " + String.valueOf(PathManager.getBinDir()) : Restarter.checkRestarter("restarter")) : String.valueOf(OS.CURRENT) + " (" + System.getProperty("os.name") + ")"));
        }
        if (problem == null) {
            return true;
        }
        Logger.getInstance(Restarter.class).info("not supported: " + (String)problem);
        return false;
    });

    private Restarter() {
    }

    public static boolean isSupported() {
        return ourRestartSupported.get();
    }

    private static String checkRestarter(String restarterName) {
        Path restarter = PathManager.getBinDir().resolve(restarterName);
        return Files.isExecutable(restarter) ? null : "not an executable file: " + String.valueOf(restarter);
    }

    @ApiStatus.Internal
    public static void scheduleRestart(boolean elevate, String ... beforeRestart) throws IOException {
        String exitCodeVariable;
        if (beforeRestart == null) {
            Restarter.$$$reportNull$$$0(0);
        }
        if ((exitCodeVariable = EnvironmentUtil.getValue((String)SPECIAL_EXIT_CODE_FOR_RESTART_ENV_VAR)) != null) {
            if (beforeRestart.length > 0) {
                throw new IOException("Cannot restart application: specific exit code restart mode does not support executing additional commands");
            }
            try {
                System.exit(Integer.parseInt(exitCodeVariable));
            }
            catch (NumberFormatException ex) {
                throw new IOException("Cannot restart application: can't parse required exit code", ex);
            }
        } else if (OS.CURRENT == OS.Windows) {
            Restarter.restartOnWindows(elevate, List.of(beforeRestart), mainAppArgs);
        } else if (OS.CURRENT == OS.macOS) {
            Restarter.restartOnMac(List.of(beforeRestart), mainAppArgs);
        } else if (OS.CURRENT == OS.Linux) {
            Restarter.restartOnLinux(List.of(beforeRestart), mainAppArgs);
        } else {
            throw new IOException("Cannot restart application: not supported.");
        }
    }

    @Nullable
    public static Path getIdeStarter() {
        return (Path)ourLauncherWithoutRemoteDevOverride.getValue();
    }

    private static void restartOnWindows(boolean elevate, List<String> beforeRestart, List<String> args) throws IOException {
        Path starter = (Path)ourLauncher.getValue();
        if (starter == null) {
            throw new IOException("Starter executable not found in " + String.valueOf(PathManager.getBinDir()));
        }
        List<String> command = Restarter.prepareCommand("restarter.exe", beforeRestart);
        command.add(String.valueOf((elevate ? 2 : 1) + args.size()));
        if (elevate) {
            command.add(PathManager.getBinDir().resolve("launcher.exe").toString());
        }
        command.add(starter.toString());
        command.addAll(args);
        Restarter.runRestarter(command);
    }

    private static void restartOnMac(List<String> beforeRestart, List<String> args) throws IOException {
        Path starter = (Path)ourLauncher.getValue();
        if (starter == null) {
            throw new IOException("Starter executable not found in: " + String.valueOf(PathManager.getHomeDir()));
        }
        List<String> command = Restarter.prepareCommand("restarter", beforeRestart);
        command.add(String.valueOf(args.size() + 1));
        command.add(starter.toString());
        command.addAll(args);
        Restarter.runRestarter(command);
    }

    private static void restartOnLinux(List<String> beforeRestart, List<String> args) throws IOException {
        Path starterScript = (Path)ourLauncher.getValue();
        if (starterScript == null) {
            throw new IOException("Starter script not found in " + String.valueOf(PathManager.getBinDir()));
        }
        List<String> command = Restarter.prepareCommand("restarter", beforeRestart);
        command.add(String.valueOf(args.size() + 1));
        command.add(starterScript.toString());
        command.addAll(args);
        Restarter.runRestarter(command);
    }

    @ApiStatus.Internal
    public static void setCopyRestarterFiles() {
        copyRestarterFiles = true;
    }

    @ApiStatus.Internal
    public static void setMainAppArgs(@NotNull List<String> args) {
        if (args == null) {
            Restarter.$$$reportNull$$$0(1);
        }
        mainAppArgs = new ArrayList<String>(args);
    }

    @ApiStatus.Internal
    public static void setRestarterEnv(@NotNull Map<String, String> env) {
        if (env == null) {
            Restarter.$$$reportNull$$$0(2);
        }
        restarterEnv = new HashMap<String, String>(env);
    }

    private static List<String> prepareCommand(String restarterName, List<String> beforeRestart) throws IOException {
        Path restarter = PathManager.getBinDir().resolve(restarterName);
        ArrayList<String> command = new ArrayList<String>();
        command.add(Restarter.copyWhenNeeded(restarter, beforeRestart).toString());
        command.add(String.valueOf(ProcessHandle.current().pid()));
        if (!beforeRestart.isEmpty()) {
            command.add(String.valueOf(beforeRestart.size()));
            command.addAll(beforeRestart);
        }
        return command;
    }

    private static Path copyWhenNeeded(Path binFile, List<String> args) throws IOException {
        if (copyRestarterFiles || args.contains("com.intellij.updater.Runner")) {
            Path tempDir = Files.createDirectories(PathManager.getSystemDir().resolve("restart"), new FileAttribute[0]);
            return Files.copy(binFile, tempDir.resolve(binFile.getFileName()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        return binFile;
    }

    private static void runRestarter(List<String> command) throws IOException {
        Logger.getInstance(Restarter.class).info("run restarter: " + String.valueOf(command));
        ProcessBuilder processBuilder = new ProcessBuilder(command).directory(Path.of(SystemProperties.getUserHome(), new String[0]).toFile()).redirectOutput(ProcessBuilder.Redirect.DISCARD).redirectError(ProcessBuilder.Redirect.DISCARD);
        processBuilder.environment().put("IJ_RESTARTER_LOG", PathManager.getLogDir().resolve("restarter.log").toString());
        processBuilder.environment().putAll(restarterEnv);
        if (OS.isGenericUnix()) {
            Restarter.setDesktopStartupId(processBuilder);
        }
        processBuilder.environment().remove("IJ_LAUNCHER_DEBUG");
        processBuilder.start();
    }

    private static void setDesktopStartupId(ProcessBuilder processBuilder) {
        if (SystemInfo.isJetBrainsJvm && StartupUiUtil.isXToolkit()) {
            try {
                Long lastUserActionTime = (Long)ReflectionUtil.getStaticFieldValue(Class.forName("sun.awt.X11.XBaseWindow"), Long.TYPE, (String)"globalUserTime");
                if (lastUserActionTime == null) {
                    Logger.getInstance(Restarter.class).warn("Couldn't obtain last user action's timestamp");
                } else {
                    String restartId = ApplicationNamesInfo.getInstance().getProductName() + "-restart_TIME" + lastUserActionTime;
                    processBuilder.environment().put("DESKTOP_STARTUP_ID", restartId);
                }
            }
            catch (Exception e) {
                Logger.getInstance(Restarter.class).warn("Couldn't set DESKTOP_STARTUP_ID", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRestart";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/Restarter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleRestart";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setMainAppArgs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setRestarterEnv";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

