/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.core.nio.fs.BasicFileAttributesHolder2;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.nio.fs.BasicFileAttributesHolder;

@ApiStatus.Internal
public final class PlatformNioHelper {
    private PlatformNioHelper() {
    }

    public static void visitDirectory(@NotNull Path directory, @Nullable Set<String> filter2, @NotNull BiPredicate<Path, Result<BasicFileAttributes>> consumer) throws IOException, SecurityException {
        if (directory == null) {
            PlatformNioHelper.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PlatformNioHelper.$$$reportNull$$$0(1);
        }
        if (filter2 != null && filter2.isEmpty()) {
            return;
        }
        try (DirectoryStream<Path> dirStream = directory.getFileSystem().provider().newDirectoryStream(directory, (DirectoryStream.Filter<? super Path>)BasicFileAttributesHolder2.FetchAttributesFilter.ACCEPT_ALL);){
            for (Path path : dirStream) {
                Result result2;
                if (filter2 != null && !filter2.contains(path.getFileName().toString())) continue;
                BasicFileAttributes attrs = null;
                if (path instanceof BasicFileAttributesHolder) {
                    attrs = ((BasicFileAttributesHolder)((Object)path)).get();
                }
                if (attrs != null) {
                    result2 = new Result(attrs);
                } else {
                    try {
                        result2 = new Result(NioFiles.readAttributes((Path)path));
                    }
                    catch (IOException | RuntimeException e) {
                        result2 = new Result(e);
                    }
                }
                if (consumer.test(path, result2)) continue;
                break;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "directory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/io/PlatformNioHelper";
        objectArray[2] = "visitDirectory";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Result<V> {
        private final Object value;

        private Result(Object value) {
            this.value = value;
        }

        public V get() throws IOException {
            if (this.value instanceof RuntimeException) {
                throw (RuntimeException)this.value;
            }
            if (this.value instanceof IOException) {
                throw (IOException)this.value;
            }
            return (V)this.value;
        }
    }
}

