/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.storage.EntityStorageSerializer;
import com.intellij.platform.workspace.storage.EntityTypesResolver;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SerializationResult;
import com.intellij.platform.workspace.storage.impl.serialization.EntityStorageSerializerImpl;
import com.intellij.platform.workspace.storage.url.UrlRelativizer;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.io.PathKt;
import com.intellij.workspaceModel.ide.impl.JpsMetricsKt;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelCacheSerializerKt;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0003\u0016\u0017\u0018B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer;", "", "vfuManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "urlRelativizer", "Lcom/intellij/platform/workspace/storage/url/UrlRelativizer;", "<init>", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;Lcom/intellij/platform/workspace/storage/url/UrlRelativizer;)V", "serializer", "Lcom/intellij/platform/workspace/storage/EntityStorageSerializer;", "loadCacheFromFile", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "file", "Ljava/nio/file/Path;", "invalidateGlobalCachesMarkerFile", "invalidateCachesMarkerFile", "loadCacheFromFile$intellij_platform_ide_impl", "saveCacheToFile", "Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer$SaveInfo;", "storage", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "saveCacheToFile$intellij_platform_ide_impl", "SaveInfo", "PluginAwareEntityTypesResolver", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWorkspaceModelCacheSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceModelCacheSerializer.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n44#2,2:174\n46#2:180\n44#2,2:181\n46#2:186\n29#3,2:176\n31#3:179\n29#3,3:183\n1#4:178\n*S KotlinDebug\n*F\n+ 1 WorkspaceModelCacheSerializer.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer\n*L\n42#1:174,2\n42#1:180\n75#1:181,2\n75#1:186\n42#1:176,2\n42#1:179\n75#1:183,3\n*E\n"})
public final class WorkspaceModelCacheSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityStorageSerializer serializer;
    @NotNull
    private static final AtomicLong loadCacheFromFileTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong saveCacheToFileTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);

    public WorkspaceModelCacheSerializer(@NotNull VirtualFileUrlManager vfuManager, @Nullable UrlRelativizer urlRelativizer) {
        Intrinsics.checkNotNullParameter((Object)vfuManager, (String)"vfuManager");
        EntityTypesResolver entityTypesResolver = PluginAwareEntityTypesResolver.INSTANCE;
        String string = ApplicationInfo.getInstance().getBuild().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.serializer = (EntityStorageSerializer)new EntityStorageSerializerImpl(entityTypesResolver, vfuManager, urlRelativizer, string);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final MutableEntityStorage loadCacheFromFile$intellij_platform_ide_impl(@NotNull Path file, @NotNull Path invalidateGlobalCachesMarkerFile, @NotNull Path invalidateCachesMarkerFile) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)invalidateGlobalCachesMarkerFile, (String)"invalidateGlobalCachesMarkerFile");
                Intrinsics.checkNotNullParameter((Object)invalidateCachesMarkerFile, (String)"invalidateCachesMarkerFile");
                $v$c$com-intellij-platform-diagnostic-telemetry-helpers-MillisecondsMeasurer$-this$0$iv = WorkspaceModelCacheSerializer.loadCacheFromFileTimeMs;
                $i$f$addMeasuredTime-impl = false;
                value$iv = null;
                $i$f$measureTimeMillis = false;
                start$iv$iv = System.currentTimeMillis();
                var10_9 = $v$c$com-intellij-platform-diagnostic-telemetry-helpers-MillisecondsMeasurer$-this$0$iv;
                $i$a$-measureTimeMillis-MillisecondsMeasurer$addMeasuredTime$1$iv = false;
                $i$a$-addMeasuredTime-impl-WorkspaceModelCacheSerializer$loadCacheFromFile$1 = false;
                start = System.currentTimeMillis();
                v0 = PathKt.basicAttributesIfExists((Path)file);
                if (v0 != null) break block8;
                v1 = null;
                break block9;
            }
            cacheFileAttributes = v0;
            invalidateCachesMarkerFileAttributes = PathKt.basicAttributesIfExists((Path)invalidateGlobalCachesMarkerFile);
            if (invalidateCachesMarkerFileAttributes != null && cacheFileAttributes.lastModifiedTime().compareTo(invalidateCachesMarkerFileAttributes.lastModifiedTime()) < 0) ** GOTO lbl-1000
            v2 = new LinkOption[]{};
            if (Files.exists(invalidateCachesMarkerFile, Arrays.copyOf(v2, v2.length))) {
                v3 = cacheFileAttributes.lastModifiedTime();
                v4 = new LinkOption[]{};
                v5 = Files.getLastModifiedTime(invalidateCachesMarkerFile, Arrays.copyOf(v4, v4.length));
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getLastModifiedTime(...)");
                ** if (v3.compareTo((FileTime)v5) >= 0) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                WorkspaceModelCacheSerializerKt.access$getLOG$p().info("Skipping cache loading since '" + invalidateGlobalCachesMarkerFile + "' is present and newer than cache file '" + file + "'");
                var17_15 = this;
                try {
                    $this$loadCacheFromFile_u24lambda_u240_u240 = var17_15;
                    $i$a$-runCatching-WorkspaceModelCacheSerializer$loadCacheFromFile$1$1 = false;
                    var18_16 = Result.constructor-impl((Object)Files.deleteIfExists(file));
                }
                catch (Throwable $i$a$-runCatching-WorkspaceModelCacheSerializer$loadCacheFromFile$1$1) {
                    var18_16 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-WorkspaceModelCacheSerializer$loadCacheFromFile$1$1));
                }
                v1 = null;
                ** GOTO lbl59
            }
lbl-1000:
            // 2 sources

            {
                WorkspaceModelCacheSerializerKt.access$getLOG$p().debug("Loading cache from " + file);
                var18_16 = this.serializer.deserializeCache-IoAF18A(file);
                if (Result.isSuccess-impl((Object)var18_16)) {
                    it = (MutableEntityStorage)var18_16;
                    $i$a$-onSuccess-WorkspaceModelCacheSerializer$loadCacheFromFile$1$cache$1 = false;
                    if (it != null) {
                        WorkspaceModelCacheSerializerKt.access$getLOG$p().debug("Loaded cache from " + file + " in " + (System.currentTimeMillis() - start) + "ms");
                    }
                }
                v6 = Result.exceptionOrNull-impl((Object)var18_16);
                if (v6 != null) {
                    it = var19_19 = v6;
                    $i$a$-onFailure-WorkspaceModelCacheSerializer$loadCacheFromFile$1$cache$2 = false;
                    WorkspaceModelCacheSerializerKt.access$getLOG$p().warn("Could not deserialize cache from " + file + ". " + it.getMessage());
                    WorkspaceModelCacheSerializerKt.access$getLOG$p().debug(it);
                }
                v1 = cache = (MutableEntityStorage)(Result.isFailure-impl((Object)var18_16) != false ? null : var18_16);
            }
        }
        value$iv = v1;
        var10_9.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SaveInfo saveCacheToFile$intellij_platform_ide_impl(@NotNull ImmutableEntityStorage storage, @NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        AtomicLong atomicLong = saveCacheToFileTimeMs;
        boolean bl = false;
        SaveInfo value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        long start2 = System.currentTimeMillis();
        WorkspaceModelCacheSerializerKt.access$getLOG$p().debug("Saving Workspace model cache to " + file2);
        Path dir = file2.getParent();
        Files.createDirectories(dir, new FileAttribute[0]);
        Long cacheSize = null;
        Path tmpFile = Files.createTempFile(dir, "cache", ".tmp", new FileAttribute[0]);
        try {
            CopyOption[] serializationResult;
            Intrinsics.checkNotNull((Object)tmpFile);
            Object object = serializationResult = this.serializer.serializeCache(tmpFile, storage);
            if (object instanceof SerializationResult.Fail) {
                WorkspaceModelCacheSerializerKt.access$getLOG$p().warn("Workspace model cache was not serialized", ((SerializationResult.Fail)serializationResult).getProblem());
            } else if (object instanceof SerializationResult.Success) {
                cacheSize = ((SerializationResult.Success)serializationResult).getSize();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            try {
                object = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
                object = Files.move(tmpFile, file2, object);
            }
            catch (AtomicMoveNotSupportedException e) {
                WorkspaceModelCacheSerializerKt.access$getLOG$p().warn((Throwable)e);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                object = Files.move(tmpFile, file2, copyOptionArray);
            }
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
        value$iv = new SaveInfo(System.currentTimeMillis() - start2, cacheSize);
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    static {
        Meter meter = JpsMetricsKt.getJpsMetrics().getMeter();
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        WorkspaceModelCacheSerializer.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer$Companion;", "", "<init>", "()V", "loadCacheFromFileTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "saveCacheToFileTimeMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement loadCacheFromFileTimeCounter = meter.counterBuilder("workspaceModel.load.cache.from.file.ms").buildObserver();
            ObservableLongMeasurement saveCacheToFileTimeCounter = meter.counterBuilder("workspaceModel.save.cache.to.file.ms").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{saveCacheToFileTimeCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(loadCacheFromFileTimeCounter, saveCacheToFileTimeCounter), (ObservableMeasurement)loadCacheFromFileTimeCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $loadCacheFromFileTimeCounter, ObservableLongMeasurement $saveCacheToFileTimeCounter) {
            $loadCacheFromFileTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)loadCacheFromFileTimeMs));
            $saveCacheToFileTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)saveCacheToFileTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J(\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0016J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer$PluginAwareEntityTypesResolver;", "Lcom/intellij/platform/workspace/storage/EntityTypesResolver;", "<init>", "()V", "getPluginIdAndModuleId", "Lkotlin/Pair;", "", "clazz", "Ljava/lang/Class;", "resolveClass", "name", "pluginId", "moduleId", "getClassLoader", "Ljava/lang/ClassLoader;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nWorkspaceModelCacheSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceModelCacheSerializer.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer$PluginAwareEntityTypesResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
    public static final class PluginAwareEntityTypesResolver
    implements EntityTypesResolver {
        @NotNull
        public static final PluginAwareEntityTypesResolver INSTANCE = new PluginAwareEntityTypesResolver();

        private PluginAwareEntityTypesResolver() {
        }

        @NotNull
        public Pair<String, String> getPluginIdAndModuleId(@NotNull Class<?> clazz) {
            PluginAwareClassLoader pluginAwareClassLoader;
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            ClassLoader classLoader = clazz.getClassLoader();
            PluginAwareClassLoader pluginAwareClassLoader2 = pluginAwareClassLoader;
            pluginAwareClassLoader = classLoader instanceof PluginAwareClassLoader ? (PluginAwareClassLoader)classLoader : null;
            PluginAwareClassLoader pluginAwareClassLoader3 = pluginAwareClassLoader;
            return TuplesKt.to((Object)(pluginAwareClassLoader3 != null && (pluginAwareClassLoader3 = pluginAwareClassLoader3.getPluginId()) != null ? pluginAwareClassLoader3.getIdString() : null), (Object)(pluginAwareClassLoader2 != null ? pluginAwareClassLoader2.getModuleId() : null));
        }

        @NotNull
        public Class<?> resolveClass(@NotNull String name2, @Nullable String pluginId, @Nullable String moduleId) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            ClassLoader classLoader = this.getClassLoader(pluginId, moduleId);
            if (classLoader == null) {
                throw new IllegalStateException(("Could not resolve class loader for plugin '" + pluginId + "' with type: " + name2).toString());
            }
            ClassLoader classLoader2 = classLoader;
            if (StringsKt.startsWith$default((String)name2, (String)"[", (boolean)false, (int)2, null)) {
                Class<?> clazz = Class.forName(name2, true, classLoader2);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                return clazz;
            }
            Class<?> clazz = classLoader2.loadClass(name2);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
            return clazz;
        }

        @Nullable
        public ClassLoader getClassLoader(@Nullable String pluginId, @Nullable String moduleId) {
            PluginId id2;
            if (moduleId != null) {
                ContentModuleDescriptor contentModuleDescriptor = PluginManagerCore.getPluginSet().findEnabledModule(PluginModuleId.Companion.invoke(moduleId));
                Intrinsics.checkNotNull((Object)contentModuleDescriptor);
                return contentModuleDescriptor.getClassLoader();
            }
            String string = pluginId;
            if (string != null) {
                String it = string;
                boolean bl = false;
                v2 = PluginId.Companion.getId(it);
            } else {
                v2 = id2 = null;
            }
            if (id2 != null && !PluginManagerCore.isPluginInstalled((PluginId)id2)) {
                return null;
            }
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)id2);
            Object object = plugin;
            if (object == null || (object = object.getPluginClassLoader()) == null) {
                object = ApplicationManager.class.getClassLoader();
            }
            return object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer$SaveInfo;", "", "loadingTime", "", "loadedSize", "<init>", "(JLjava/lang/Long;)V", "Ljava/lang/Long;", "component1", "component2", "()Ljava/lang/Long;", "copy", "(JLjava/lang/Long;)Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer$SaveInfo;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class SaveInfo {
        @JvmField
        public final long loadingTime;
        @JvmField
        @Nullable
        public final Long loadedSize;

        public SaveInfo(long loadingTime, @Nullable Long loadedSize) {
            this.loadingTime = loadingTime;
            this.loadedSize = loadedSize;
        }

        public final long component1() {
            return this.loadingTime;
        }

        @Nullable
        public final Long component2() {
            return this.loadedSize;
        }

        @NotNull
        public final SaveInfo copy(long loadingTime, @Nullable Long loadedSize) {
            return new SaveInfo(loadingTime, loadedSize);
        }

        public static /* synthetic */ SaveInfo copy$default(SaveInfo saveInfo, long l, Long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = saveInfo.loadingTime;
            }
            if ((n & 2) != 0) {
                l2 = saveInfo.loadedSize;
            }
            return saveInfo.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "SaveInfo(loadingTime=" + this.loadingTime + ", loadedSize=" + this.loadedSize + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.loadingTime);
            result2 = result2 * 31 + (this.loadedSize == null ? 0 : ((Object)this.loadedSize).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SaveInfo)) {
                return false;
            }
            SaveInfo saveInfo = (SaveInfo)other;
            if (this.loadingTime != saveInfo.loadingTime) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.loadedSize, (Object)saveInfo.loadedSize);
        }
    }
}

