/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppConsoleFontOptions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ConsoleFontOptions
extends FontOptions {
    public ConsoleFontOptions(ColorAndFontOptions options2) {
        super(options2);
    }

    @Override
    protected String getOverwriteFontTitle() {
        return ApplicationBundle.message((String)"settings.editor.console.font.overwrite", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected Component createOverwriteCheckBox() {
        if (!AppConsoleFontOptions.getInstance().isUseEditorFont()) {
            JPanel overwritePanel = new JPanel(new FlowLayout(3));
            overwritePanel.setBorder((Border)JBUI.Borders.empty());
            overwritePanel.add(new JLabel(ApplicationBundle.message((String)"settings.editor.console.font.overwritten", (Object[])new Object[0])));
            ActionLink consoleSettingsLink = new ActionLink(ApplicationBundle.message((String)"settings.editor.console.font.overwritten.link", (Object[])new Object[0]), e -> this.navigateToParentFontConfigurable());
            overwritePanel.add((Component)consoleSettingsLink);
            return overwritePanel;
        }
        return super.createOverwriteCheckBox();
    }

    @Override
    protected void navigateToParentFontConfigurable() {
        Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.getPanel()));
        if (allSettings != null) {
            if (!AppConsoleFontOptions.getInstance().isUseEditorFont()) {
                Configurable fontConfigurable = allSettings.find("app.console.font");
                if (fontConfigurable != null) {
                    allSettings.select(fontConfigurable);
                }
            } else {
                SearchableConfigurable editorFontConfigurable;
                ColorAndFontOptions colorAndFontOptions = allSettings.find(ColorAndFontOptions.class);
                if (colorAndFontOptions != null && (editorFontConfigurable = colorAndFontOptions.findSubConfigurable(ColorAndFontOptions.getFontConfigurableName())) != null) {
                    allSettings.select((Configurable)editorFontConfigurable);
                }
            }
        }
    }

    @Override
    @NotNull
    protected FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.getCurrentScheme().getConsoleFontPreferences();
        if (fontPreferences == null) {
            ConsoleFontOptions.$$$reportNull$$$0(0);
        }
        return fontPreferences;
    }

    @Override
    protected FontPreferences getBaseFontPreferences() {
        return this.getCurrentScheme().getFontPreferences();
    }

    @Override
    protected void setDelegatingPreferences(boolean isDelegating) {
        FontPreferences currPrefs = this.getCurrentScheme().getConsoleFontPreferences();
        if (currPrefs instanceof DelegatingFontPreferences == isDelegating) {
            return;
        }
        if (isDelegating) {
            this.getCurrentScheme().setUseEditorFontPreferencesInConsole();
        } else {
            this.getCurrentScheme().setConsoleFontPreferences(this.getFontPreferences());
        }
        this.updateOptionsList();
        this.updateDescription(true);
    }

    @Override
    protected void setFontSize(int fontSize) {
        this.setFontSize((float)fontSize);
    }

    @Override
    protected void setFontSize(float fontSize) {
        this.getCurrentScheme().setConsoleFontSize(fontSize);
    }

    @Override
    protected float getLineSpacing() {
        return this.getCurrentScheme().getConsoleLineSpacing();
    }

    @Override
    protected void setCurrentLineSpacing(float lineSpacing) {
        this.getCurrentScheme().setConsoleLineSpacing(lineSpacing);
    }

    @Override
    protected boolean isReadOnly() {
        if (!AppConsoleFontOptions.getInstance().isUseEditorFont()) {
            return true;
        }
        return super.isReadOnly();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ConsoleFontOptions", "getFontPreferences"));
    }
}

