/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.util.EventListener;
import javax.swing.JLabel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemesPanel
extends SimpleSchemesPanel<EditorColorsScheme> {
    private static final Logger LOG = Logger.getInstance(SchemesPanel.class);
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher;
    private boolean myListLoaded;

    public SchemesPanel(@NotNull ColorAndFontOptions options2) {
        if (options2 == null) {
            SchemesPanel.$$$reportNull$$$0(0);
        }
        this(options2, 8);
    }

    @ApiStatus.Internal
    public SchemesPanel(@NotNull ColorAndFontOptions options2, int vGap) {
        if (options2 == null) {
            SchemesPanel.$$$reportNull$$$0(1);
        }
        super(vGap);
        this.myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
        this.myOptions = options2;
        this.setEnabled(options2.isSchemesPanelEnabled());
        this.putClientProperty(SearchUtil.SEARCH_SKIP_COMPONENT_KEY, true);
    }

    public boolean areSchemesLoaded() {
        return this.myListLoaded;
    }

    @Override
    protected ActionLink createActionLink() {
        String text2 = this.isEnabled() ? ApplicationBundle.message((String)"link.editor.scheme.change.ide.theme", (Object[])new Object[0]) : ApplicationBundle.message((String)"link.editor.scheme.configure", (Object[])new Object[0]);
        return new ActionLink(text2, actionEvent -> {
            Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)((ActionLink)actionEvent.getSource())));
            if (settings != null) {
                settings.select(settings.find("preferences.lookFeel"));
            }
        });
    }

    @Override
    @Nullable
    protected JLabel createActionLinkCommentLabel() {
        if (this.isEnabled()) {
            return null;
        }
        JBLabel label2 = new JBLabel(ApplicationBundle.message((String)"link.editor.scheme.configure.description", (Object[])new Object[0]));
        label2.setEnabled(false);
        return label2;
    }

    @Override
    @Nls
    protected String getContextHelpLabelText() {
        return ApplicationBundle.message((String)"editbox.scheme.context.help.label", (Object[])new Object[0]);
    }

    void resetSchemesCombo(Object source) {
        if (this != source) {
            this.setListLoaded(false);
            EditorColorsScheme selectedSchemeBackup = this.myOptions.getSelectedScheme();
            this.resetGroupedSchemes(this.myOptions.getOrderedSchemes());
            this.selectScheme(selectedSchemeBackup);
            this.setListLoaded(true);
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this);
        }
    }

    private void setListLoaded(boolean b) {
        this.myListLoaded = b;
    }

    protected boolean shouldApplyImmediately() {
        return false;
    }

    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            SchemesPanel.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<EditorColorsScheme> createSchemeActions() {
        SchemesPanel panel2 = this;
        return new ColorSchemeActions(panel2){

            @Override
            @NotNull
            protected ColorAndFontOptions getOptions() {
                ColorAndFontOptions colorAndFontOptions = SchemesPanel.this.myOptions;
                if (colorAndFontOptions == null) {
                    1.$$$reportNull$$$0(0);
                }
                return colorAndFontOptions;
            }

            @Override
            protected void onSchemeChanged(@Nullable EditorColorsScheme scheme) {
                SchemesPanel.this.onSchemeChangedFromAction(scheme);
            }

            @Override
            protected void renameScheme(@NotNull EditorColorsScheme scheme, @NotNull String newName) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (newName == null) {
                    1.$$$reportNull$$$0(2);
                }
                SchemesPanel.this.renameSchemeFromAction(scheme, newName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/application/options/colors/SchemesPanel$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOptions";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/application/options/colors/SchemesPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "renameScheme";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    protected void onSchemeChangedFromAction(@Nullable EditorColorsScheme scheme) {
        if (scheme != null && this.areSchemesLoaded()) {
            this.myOptions.selectScheme(scheme.getName());
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this);
            if (this.shouldApplyImmediately() && this.myOptions.isModified()) {
                try {
                    this.myOptions.apply();
                }
                catch (ConfigurationException e) {
                    LOG.warn("Unable to apply compiler resource patterns", (Throwable)e);
                }
            }
        }
    }

    protected void renameSchemeFromAction(@NotNull EditorColorsScheme scheme, @NotNull String newName) {
        if (scheme == null) {
            SchemesPanel.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            SchemesPanel.$$$reportNull$$$0(4);
        }
        if (this.myOptions.saveSchemeAs(scheme, newName)) {
            this.myOptions.removeScheme(scheme);
            this.myOptions.selectScheme(newName);
        }
    }

    @Override
    @NotNull
    public SchemesModel<EditorColorsScheme> getModel() {
        ColorAndFontOptions colorAndFontOptions = this.myOptions;
        if (colorAndFontOptions == null) {
            SchemesPanel.$$$reportNull$$$0(5);
        }
        return colorAndFontOptions;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return false;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return true;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/SchemesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/SchemesPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renameSchemeFromAction";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

