/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof;

import com.intellij.diagnostic.hprof.AnalyzerProgressIndicator;
import com.intellij.diagnostic.hprof.action.SystemTempFilenameSupplier;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.AnalyzeClassloaderReferencesGraph;
import com.intellij.diagnostic.hprof.analysis.AnalyzeGraph;
import com.intellij.diagnostic.hprof.analysis.HProfAnalysis;
import com.intellij.diagnostic.hprof.util.ListProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import kotlin.jvm.functions.Function3;

public final class Analyzer {
    public static void main(String[] args) throws IOException {
        String report;
        Function3 analysisCallback;
        AnalyzerProgressIndicator progress;
        if (args.length == 0 || args.length == 1 && args[0].equals("-v")) {
            System.out.println();
            System.out.println("Usage: " + Analyzer.class.getName() + " [-v] [-plugin <plugin_id>] <hprof file>");
            System.exit(1);
        }
        boolean onlyStrongReferences = false;
        boolean includeClassesAsRoots = true;
        int index = 0;
        if (args[index].equals("-v")) {
            ++index;
            progress = new AnalyzerProgressIndicator();
        } else {
            progress = new EmptyProgressIndicator(ModalityState.nonModal());
        }
        if (args[index].equals("-plugin")) {
            String pluginId = args[++index];
            analysisCallback = (analysisContext, listProvider, progressIndicator) -> new AnalyzeClassloaderReferencesGraph((AnalysisContext)analysisContext, (ListProvider)listProvider, pluginId).analyze((ProgressIndicator)progressIndicator).getMainReport().toString();
            onlyStrongReferences = true;
            includeClassesAsRoots = false;
            ++index;
        } else {
            analysisCallback = (analysisContext, listProvider, progressIndicator) -> new AnalyzeGraph((AnalysisContext)analysisContext, (ListProvider)listProvider).analyze((ProgressIndicator)progressIndicator).getMainReport().toString();
        }
        Path hprofPath = Paths.get(args[index], new String[0]);
        try (FileChannel channel = FileChannel.open(hprofPath, StandardOpenOption.READ);){
            HProfAnalysis analysis = new HProfAnalysis(channel, new SystemTempFilenameSupplier(), (Function3<? super AnalysisContext, ? super ListProvider, ? super ProgressIndicator, String>)analysisCallback);
            analysis.setOnlyStrongReferences(onlyStrongReferences);
            analysis.setIncludeClassesAsRoots(includeClassesAsRoots);
            report = analysis.analyze((ProgressIndicator)progress);
            progress.setText("DONE");
        }
        System.out.println(report);
    }
}

