/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.EditorTextField;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/filters/ShowTextPopupHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "title", "", "text", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ShowTextPopupHyperlinkInfo
implements HyperlinkInfo {
    @NotNull
    private final String title;
    @NotNull
    private final String text;

    public ShowTextPopupHyperlinkInfo(@NlsContexts.PopupTitle @NotNull String title2, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.title = title2;
        this.text = text2;
    }

    public void navigate(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ApplicationManager.getApplication().invokeLater(() -> ShowTextPopupHyperlinkInfo.navigate$lambda$0(this, project2));
    }

    private static final void navigate$lambda$0(ShowTextPopupHyperlinkInfo this$0, Project $project) {
        Document document2 = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)this$0.text));
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"createDocument(...)");
        Document document3 = document2;
        LanguageFileType languageFileType = FileTypes.PLAIN_TEXT;
        EditorTextField textField2 = new EditorTextField(document3, $project, languageFileType){

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                EditorEx editor2 = editorEx;
                editor2.getScrollPane().setVerticalScrollBarPolicy(20);
                editor2.getScrollPane().setHorizontalScrollBarPolicy(30);
                editor2.getSettings().setUseSoftWraps(true);
                return editor2;
            }
        };
        Serializable serializable = WindowManager.getInstance().getFrame($project);
        if (serializable != null && (serializable = serializable.getSize()) != null) {
            Serializable it = serializable;
            boolean bl = false;
            textField2.setPreferredSize(new Dimension(((Dimension)it).width / 2, ((Dimension)it).height / 2));
        }
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)textField2), (JComponent)((Object)textField2)).setTitle(this$0.title).setResizable(true).setMovable(true).setRequestFocus(true).createPopup().showCenteredInCurrentWindow($project);
    }
}

