/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionService;
import com.intellij.execution.wsl.WslDistributionAndVersion;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class WSLUtil {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.wsl");
    private static boolean ourIsSystemCompatible = SystemInfo.isWin10OrNewer;
    private static final NullableLazyValue<WSLToolFlags> WSL_TOOL_FLAGS = NullableLazyValue.lazyNullable(() -> WSLUtil.getWSLToolFlagsInternal());
    private static final Pattern QUIET = Pattern.compile("\\s--quiet,?\\b");
    private static final Pattern VERBOSE = Pattern.compile("\\s--verbose,?\\b");
    static final String DEFAULT_UNC_PREFIX = "\\\\wsl.localhost\\";

    @Deprecated(forRemoval=true)
    @NotNull
    public static List<WSLDistribution> getAvailableDistributions() {
        if (!WSLUtil.isSystemCompatible()) {
            List<WSLDistribution> list2 = Collections.emptyList();
            if (list2 == null) {
                WSLUtil.$$$reportNull$$$0(0);
            }
            return list2;
        }
        Path executableRoot = WSLUtil.getExecutableRootPath();
        if (executableRoot == null) {
            List<WSLDistribution> list3 = Collections.emptyList();
            if (list3 == null) {
                WSLUtil.$$$reportNull$$$0(1);
            }
            return list3;
        }
        Collection<WslDistributionDescriptor> descriptors2 = WSLDistributionService.getInstance().getDescriptors();
        ArrayList<WSLDistribution> result2 = new ArrayList<WSLDistribution>(descriptors2.size() + 1);
        for (WslDistributionDescriptor descriptor : descriptors2) {
            String executablePathStr = descriptor.getExecutablePath();
            if (executablePathStr == null) continue;
            Path executablePath = Paths.get(executablePathStr, new String[0]);
            if (!executablePath.isAbsolute()) {
                executablePath = executableRoot.resolve(executablePath);
            }
            if (!Files.exists(executablePath, LinkOption.NOFOLLOW_LINKS)) continue;
            result2.add(new WSLDistribution(descriptor, executablePath));
        }
        ArrayList<WSLDistribution> arrayList = result2;
        if (arrayList == null) {
            WSLUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    private static Path getExecutableRootPath() {
        String localAppDataPath = System.getenv().get("LOCALAPPDATA");
        return StringUtil.isEmpty((String)localAppDataPath) ? null : Paths.get(localAppDataPath, "Microsoft\\WindowsApps");
    }

    public static boolean isSystemCompatible() {
        return ourIsSystemCompatible;
    }

    @TestOnly
    public static void setSystemCompatible(boolean value) {
        ourIsSystemCompatible = value;
    }

    @Nullable
    public static String getWindowsPath(@NotNull String wslPath, @NotNull String mntRoot) {
        if (wslPath == null) {
            WSLUtil.$$$reportNull$$$0(3);
        }
        if (mntRoot == null) {
            WSLUtil.$$$reportNull$$$0(4);
        }
        if (!wslPath.startsWith(mntRoot)) {
            return null;
        }
        int driveLetterIndex = mntRoot.length();
        if (driveLetterIndex >= wslPath.length() || !Character.isLetter(wslPath.charAt(driveLetterIndex))) {
            return null;
        }
        int slashIndex = driveLetterIndex + 1;
        if (slashIndex < wslPath.length() && wslPath.charAt(slashIndex) != '/') {
            return null;
        }
        return FileUtil.toSystemDependentName((String)(Character.toUpperCase(wslPath.charAt(driveLetterIndex)) + ":" + wslPath.substring(slashIndex)));
    }

    static int getWslVersion(@NotNull WSLDistribution distribution) {
        int version;
        if (distribution == null) {
            WSLUtil.$$$reportNull$$$0(5);
        }
        if ((version = WSLUtil.getVersionFromWslCli(distribution)) < 0) {
            version = WSLUtil.getVersionByUname(distribution);
        }
        return version;
    }

    private static int getVersionFromWslCli(@NotNull WSLDistribution distribution) {
        if (distribution == null) {
            WSLUtil.$$$reportNull$$$0(6);
        }
        try {
            List<WslDistributionAndVersion> versions = WslDistributionManager.getInstance().loadInstalledDistributionsWithVersions();
            WslDistributionAndVersion distributionAndVersion = (WslDistributionAndVersion)ContainerUtil.find(versions, version -> version.getDistributionName().equals(distribution.getMsId()));
            if (distributionAndVersion != null) {
                return distributionAndVersion.getVersion();
            }
            LOG.warn("WSL distribution '" + distribution.getMsId() + "' not found");
        }
        catch (IOException | IllegalStateException e) {
            LOG.warn("Failed to calculate version for " + distribution.getMsId() + ": " + e.getMessage());
        }
        return -1;
    }

    private static int getVersionByUname(@NotNull WSLDistribution distribution) {
        if (distribution == null) {
            WSLUtil.$$$reportNull$$$0(7);
        }
        try {
            ProcessOutput output = distribution.executeOnWsl(Arrays.asList("uname", "-v"), new WSLCommandLineOptions().setLaunchWithWslExe(true), WSLDistribution.DEFAULT_TIMEOUT, null);
            if (output.checkSuccess(LOG)) {
                return output.getStdout().contains("Microsoft") ? 1 : 2;
            }
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        return -1;
    }

    @NotNull
    @NlsSafe
    public static String getMsId(@NotNull @NlsSafe String msOrInternalId) {
        WslDistributionDescriptor descriptor;
        if (msOrInternalId == null) {
            WSLUtil.$$$reportNull$$$0(8);
        }
        String string = (descriptor = (WslDistributionDescriptor)ContainerUtil.find(WSLDistributionService.getInstance().getDescriptors(), d -> d.getId().equals(msOrInternalId))) != null ? descriptor.getMsId() : msOrInternalId;
        if (string == null) {
            WSLUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    static WSLToolFlags getWSLToolFlags() {
        return (WSLToolFlags)WSL_TOOL_FLAGS.getValue();
    }

    @Nullable
    private static WSLToolFlags getWSLToolFlagsInternal() {
        Path wslExe = WSLDistribution.findWslExe();
        if (wslExe == null) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{wslExe.toString(), "--help"}).withCharset(StandardCharsets.UTF_16LE);
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)5000);
            if (output.isTimeout()) {
                return null;
            }
            String stdout = output.getStdout();
            return new WSLToolFlags(QUIET.matcher(stdout).find(), VERBOSE.matcher(stdout).find());
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static String getUncPrefix() {
        return SystemInfo.isWin11OrNewer ? DEFAULT_UNC_PREFIX : "\\\\wsl$\\";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mntRoot";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msOrInternalId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWindowsPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWslVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVersionFromWslCli";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVersionByUname";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMsId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    static final class WSLToolFlags {
        public final boolean isQuietFlagAvailable;
        public final boolean isVerboseFlagAvailable;

        WSLToolFlags(boolean isQuietAvailable, boolean isVerboseAvailable) {
            this.isQuietFlagAvailable = isQuietAvailable;
            this.isVerboseFlagAvailable = isVerboseAvailable;
        }
    }
}

