/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CliResult;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J%\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/CommandLineProcessorResult;", "", "project", "Lcom/intellij/openapi/project/Project;", "future", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/ide/CliResult;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/Deferred;)V", "result", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/CliResult;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFuture", "()Lkotlinx/coroutines/Deferred;", "hasError", "", "getHasError", "()Z", "showError", "", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class CommandLineProcessorResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Deferred<CliResult> future;

    public CommandLineProcessorResult(@Nullable Project project2, @NotNull Deferred<CliResult> future) {
        Intrinsics.checkNotNullParameter(future, (String)"future");
        this.project = project2;
        this.future = future;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Deferred<CliResult> getFuture() {
        return this.future;
    }

    public CommandLineProcessorResult(@Nullable Project project2, @NotNull CliResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this(project2, (Deferred<CliResult>)((Deferred)CompletableDeferredKt.CompletableDeferred((Object)result2)));
    }

    public final boolean getHasError() {
        return this.future.isCompleted() && ((CliResult)this.future.getCompleted()).exitCode() == 1;
    }

    public final void showError() {
        Messages.showErrorDialog((String)((CliResult)this.future.getCompleted()).message(), (String)IdeBundle.message((String)"dialog.title.cannot.execute.command", (Object[])new Object[0]));
    }

    @Nullable
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Deferred<CliResult> component2() {
        return this.future;
    }

    @NotNull
    public final CommandLineProcessorResult copy(@Nullable Project project2, @NotNull Deferred<CliResult> future) {
        Intrinsics.checkNotNullParameter(future, (String)"future");
        return new CommandLineProcessorResult(project2, future);
    }

    public static /* synthetic */ CommandLineProcessorResult copy$default(CommandLineProcessorResult commandLineProcessorResult, Project project2, Deferred deferred2, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = commandLineProcessorResult.project;
        }
        if ((n & 2) != 0) {
            deferred2 = commandLineProcessorResult.future;
        }
        return commandLineProcessorResult.copy(project2, deferred2);
    }

    @NotNull
    public String toString() {
        return "CommandLineProcessorResult(project=" + this.project + ", future=" + this.future + ")";
    }

    public int hashCode() {
        int result2 = this.project == null ? 0 : this.project.hashCode();
        result2 = result2 * 31 + this.future.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommandLineProcessorResult)) {
            return false;
        }
        CommandLineProcessorResult commandLineProcessorResult = (CommandLineProcessorResult)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)commandLineProcessorResult.project)) {
            return false;
        }
        return Intrinsics.areEqual(this.future, commandLineProcessorResult.future);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/CommandLineProcessorResult$Companion;", "", "<init>", "()V", "createError", "Lcom/intellij/ide/CommandLineProcessorResult;", "message", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommandLineProcessorResult createError(@NlsContexts.DialogMessage @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new CommandLineProcessorResult(null, (Deferred<CliResult>)((Deferred)CompletableDeferredKt.CompletableDeferred((Object)new CliResult(1, message))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

