/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.util.SystemInfoRt;
import java.awt.event.KeyEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/MnemonicUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "MNEMONIC_USED", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "logMnemonicUsed", "", "ke", "Ljava/awt/event/KeyEvent;", "intellij.platform.ide.impl"})
public final class MnemonicUsageCollector
extends CounterUsagesCollector {
    @NotNull
    public static final MnemonicUsageCollector INSTANCE = new MnemonicUsageCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("ui.mnemonic", 2, null, 4, null);
    @NotNull
    private static final EventId1<String> MNEMONIC_USED;

    private MnemonicUsageCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void logMnemonicUsed(@Nullable KeyEvent ke) {
        if (ke == null) {
            return;
        }
        int code = ke.getKeyCode();
        if (48 <= code && code <= 90) {
            int modifiers = ke.getModifiersEx();
            String type = null;
            if (modifiers == 512) {
                if (IdeKeyEventDispatcher.Companion.hasMnemonicInWindow(ke.getComponent(), ke)) {
                    type = SystemInfoRt.isMac ? "mac.alt.based" : "regular";
                }
            } else if (SystemInfoRt.isMac && modifiers == 640 && IdeKeyEventDispatcher.Companion.hasMnemonicInWindow(ke.getComponent(), ke)) {
                type = "mac.regular";
            }
            if (type != null) {
                MNEMONIC_USED.log(type);
            }
        }
    }

    static {
        Object[] objectArray = new String[]{"mac.alt.based", "regular", "mac.regular"};
        MNEMONIC_USED = GROUP.registerEvent("mnemonic.used", (EventField)EventFields.String((String)"type", (List)CollectionsKt.listOf((Object[])objectArray)));
    }
}

