/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.ConsentOptionsProvider;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ui.LicensingFacade;
import java.util.Set;

final class ConsentOptionsProviderImpl
implements ConsentOptionsProvider {
    private static final Set<String> productsSupportingForcedConsent = Set.of("QA", "RR", "WS", "RD", "CL", "RM", "DB");
    private volatile long myLastModificationCount = -1L;
    private volatile boolean mySendingAllowed = false;

    ConsentOptionsProviderImpl() {
    }

    public boolean isEAP() {
        return ConsentOptions.getInstance().isEAP();
    }

    public boolean isActivatedWithFreeLicense() {
        LicensingFacade facade2 = LicensingFacade.getInstance();
        if (facade2 == null || !productsSupportingForcedConsent.contains(facade2.platformProductCode)) {
            return false;
        }
        String meta = facade2.metadata;
        return meta != null && meta.length() > 10 && meta.charAt(10) == 'F';
    }

    public void setSendingUsageStatsAllowed(boolean allowed) {
        ConsentOptions.getInstance().setSendingUsageStatsAllowed(allowed);
    }

    public boolean isSendingUsageStatsAllowed() {
        boolean allowedNow;
        long modificationCount = ConsentOptions.getInstance().getModificationCount();
        if (this.myLastModificationCount == modificationCount) {
            return this.mySendingAllowed;
        }
        this.mySendingAllowed = allowedNow = ConsentOptions.getInstance().isSendingUsageStatsAllowed() == ConsentOptions.Permission.YES;
        this.myLastModificationCount = modificationCount;
        return allowedNow;
    }
}

