/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.intentions.openInProject;

import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.intentions.openInProject.GitProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.GradleProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.IntellijProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.ProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.SimpleParentRootFinder;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectRootSearchUtil {
    private static final ProjectRootFinder[] ROOT_FINDERS = new ProjectRootFinder[]{new IntellijProjectRootFinder(), new GradleProjectRootFinder(), new GitProjectRootFinder(), new SimpleParentRootFinder()};

    private ProjectRootSearchUtil() {
    }

    @Nullable
    static VirtualFile findProjectRoot(@NotNull Project project2, @NotNull VirtualFile sourceFile) {
        if (project2 == null) {
            ProjectRootSearchUtil.$$$reportNull$$$0(0);
        }
        if (sourceFile == null) {
            ProjectRootSearchUtil.$$$reportNull$$$0(1);
        }
        Ref result2 = Ref.create();
        Ref requiresConfirmation = Ref.create((Object)false);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            for (ProjectRootFinder finder : ROOT_FINDERS) {
                VirtualFile root = finder.findProjectRoot(sourceFile);
                if (root == null) continue;
                result2.set((Object)root);
                requiresConfirmation.set((Object)finder.requiresConfirmation());
                break;
            }
        }, ApplicationBundle.message((String)"light.edit.open.in.project.progress.message", (Object[])new Object[0]), true, project2);
        if (((Boolean)requiresConfirmation.get()).booleanValue()) {
            VirtualFile newProjectRoot = ProjectRootSearchUtil.confirmOrChooseProjectDir(project2, (VirtualFile)result2.get());
            if (newProjectRoot != null) {
                LightEditFeatureUsagesUtil.logOpenFileInProject(project2, LightEditFeatureUsagesUtil.ProjectStatus.New);
            }
            result2.set((Object)newProjectRoot);
        } else {
            LightEditFeatureUsagesUtil.logOpenFileInProject(project2, LightEditFeatureUsagesUtil.ProjectStatus.Existing);
        }
        return (VirtualFile)result2.get();
    }

    @Nullable
    private static VirtualFile confirmOrChooseProjectDir(@NotNull Project project2, @Nullable VirtualFile suggestedRoot) {
        if (project2 == null) {
            ProjectRootSearchUtil.$$$reportNull$$$0(2);
        }
        if (suggestedRoot != null) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            descriptor.setTitle(ApplicationBundle.message((String)"light.edit.open.in.project.dialog.title", (Object[])new Object[0]));
            return FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project2, (VirtualFile)suggestedRoot);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/lightEdit/intentions/openInProject/ProjectRootSearchUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findProjectRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "confirmOrChooseProjectDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

