/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginReplacement;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.marketplace.statistics.enums.InstallationSourceEnum;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PluginInstallOperation {
    private static final Logger LOG = Logger.getInstance(PluginInstallOperation.class);
    private static final Cache<String, Optional<PluginId>> ourCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    @NotNull
    private final List<PluginUiModel> myPluginsToInstall;
    @NotNull
    private final Collection<PluginUiModel> myCustomReposPlugins;
    @NotNull
    private final PluginEnabler myPluginEnabler;
    @NotNull
    private final ProgressIndicator myIndicator;
    private boolean mySuccess;
    private final Set<PluginInstallCallbackData> myDependant;
    private boolean myAllowInstallWithoutRestart;
    private final List<PendingDynamicPluginInstall> myPendingDynamicPluginInstalls;
    private boolean myRestartRequired;
    private boolean myShownErrors;
    private MarketplacePluginDownloadService myDownloadService;
    private static final Map<PluginId, ActionCallback> ourInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
    private final Map<PluginId, ActionCallback> myLocalInstallCallbacks;
    private final Map<PluginId, ActionCallback> myLocalWaitInstallCallbacks;
    private static final Object ourInstallLock = new Object();

    public PluginInstallOperation(@NotNull List<PluginNode> pluginsToInstall, @NotNull Collection<PluginNode> customReposPlugins, @NotNull PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator2) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(0);
        }
        if (customReposPlugins == null) {
            PluginInstallOperation.$$$reportNull$$$0(1);
        }
        if (pluginEnabler == null) {
            PluginInstallOperation.$$$reportNull$$$0(2);
        }
        if (indicator2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(3);
        }
        this(ContainerUtil.map(pluginsToInstall, PluginUiModelAdapter::new), ContainerUtil.map(customReposPlugins, PluginUiModelAdapter::new), indicator2, pluginEnabler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginInstallOperation(@NotNull List<PluginUiModel> pluginsToInstall, @NotNull Collection<PluginUiModel> customReposPlugins, @NotNull ProgressIndicator indicator2, @NotNull PluginEnabler pluginEnabler) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(4);
        }
        if (customReposPlugins == null) {
            PluginInstallOperation.$$$reportNull$$$0(5);
        }
        if (indicator2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(6);
        }
        if (pluginEnabler == null) {
            PluginInstallOperation.$$$reportNull$$$0(7);
        }
        this.mySuccess = true;
        this.myDependant = new HashSet<PluginInstallCallbackData>();
        this.myAllowInstallWithoutRestart = false;
        this.myPendingDynamicPluginInstalls = new ArrayList<PendingDynamicPluginInstall>();
        this.myRestartRequired = false;
        this.myLocalInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
        this.myLocalWaitInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
        this.myPluginsToInstall = pluginsToInstall;
        this.myCustomReposPlugins = customReposPlugins;
        this.myPluginEnabler = pluginEnabler;
        this.myIndicator = indicator2;
        Object object = ourInstallLock;
        synchronized (object) {
            for (PluginUiModel node : pluginsToInstall) {
                PluginId id2 = node.getPluginId();
                ActionCallback callback = ourInstallCallbacks.get(id2);
                if (callback == null) {
                    this.createInstallCallback(id2);
                    continue;
                }
                this.myLocalWaitInstallCallbacks.put(id2, callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstallCallback(@NotNull PluginId id2, @NotNull ActionCallback callback, boolean isDone) {
        if (id2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            PluginInstallOperation.$$$reportNull$$$0(9);
        }
        Object object = ourInstallLock;
        synchronized (object) {
            ActionCallback oldValue = ourInstallCallbacks.get(id2);
            if (oldValue == callback) {
                ourInstallCallbacks.remove(id2);
            }
        }
        if (isDone) {
            callback.setDone();
        } else {
            callback.setRejected();
        }
    }

    private void createInstallCallback(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(10);
        }
        ActionCallback callback = new ActionCallback();
        ourInstallCallbacks.put(id2, callback);
        this.myLocalInstallCallbacks.put(id2, callback);
    }

    public void setDownloadService(MarketplacePluginDownloadService downloadService) {
        this.myDownloadService = downloadService;
    }

    public void setAllowInstallWithoutRestart(boolean allowInstallWithoutRestart) {
        this.myAllowInstallWithoutRestart = allowInstallWithoutRestart;
    }

    public List<PendingDynamicPluginInstall> getPendingDynamicPluginInstalls() {
        return this.myPendingDynamicPluginInstalls;
    }

    public boolean isRestartRequired() {
        return this.myRestartRequired;
    }

    public void run() {
        this.updateUrls();
        this.mySuccess = this.prepareToInstall(this.myPluginsToInstall);
    }

    public boolean isSuccess() {
        return this.mySuccess;
    }

    public Set<PluginInstallCallbackData> getInstalledDependentPlugins() {
        return this.myDependant;
    }

    public boolean isShownErrors() {
        return this.myShownErrors;
    }

    private void updateUrls() {
        boolean unknownNodes = false;
        for (PluginUiModel node : this.myPluginsToInstall) {
            if (!Strings.areSameInstance((String)node.getRepositoryName(), (String)"__unknown_repository__")) continue;
            unknownNodes = true;
            break;
        }
        if (!unknownNodes) {
            return;
        }
        HashMap<PluginId, PluginUiModel> allPlugins = new HashMap<PluginId, PluginUiModel>();
        for (String host : RepositoryHelper.getCustomPluginRepositoryHosts()) {
            try {
                for (PluginUiModel descriptor : RepositoryHelper.loadPluginModels(host, null, this.myIndicator)) {
                    allPlugins.put(descriptor.getPluginId(), descriptor);
                }
            }
            catch (IOException iOException) {
            }
        }
        for (PluginUiModel node : this.myPluginsToInstall) {
            if (!Strings.areSameInstance((String)node.getRepositoryName(), (String)"__unknown_repository__")) continue;
            PluginUiModel descriptor = (PluginUiModel)allPlugins.get(node.getPluginId());
            node.setRepositoryName(descriptor != null ? descriptor.getRepositoryName() : null);
            String oldUrl = node.getDownloadUrl();
            if (descriptor != null) {
                node.setDownloadUrl(descriptor.getDownloadUrl());
            }
            LOG.info("updateUrls for node: " + String.valueOf(node.getPluginId()) + " | " + node.getVersion() + " | " + oldUrl + " to: " + node.getRepositoryName() + " | " + node.getDownloadUrl());
        }
    }

    private boolean prepareToInstall(@NotNull List<PluginUiModel> pluginsToInstall) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(11);
        }
        SmartList pluginIds = new SmartList();
        for (PluginUiModel pluginNode : pluginsToInstall) {
            pluginIds.add(pluginNode.getPluginId());
        }
        boolean result2 = false;
        for (PluginUiModel pluginNode : pluginsToInstall) {
            this.myIndicator.setText(pluginNode.getName());
            try {
                result2 |= this.prepareToInstallWithCallback(pluginNode, (List<PluginId>)pluginIds);
            }
            catch (IOException e) {
                String title2 = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
                LOG.warn((Throwable)e);
                NotificationGroup group2 = NotificationGroupManager.getInstance().getNotificationGroup("Plugin Error");
                Notifications.Bus.notify((Notification)group2.createNotification(title2, pluginNode.getName() + ": " + e.getMessage(), NotificationType.ERROR));
                return false;
            }
        }
        return result2;
    }

    private boolean prepareToInstallWithCallback(@NotNull PluginUiModel pluginNode, @NotNull List<PluginId> pluginIds) throws IOException {
        PluginId id2;
        ActionCallback localCallback;
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(12);
        }
        if (pluginIds == null) {
            PluginInstallOperation.$$$reportNull$$$0(13);
        }
        if ((localCallback = this.myLocalInstallCallbacks.remove(id2 = pluginNode.getPluginId())) == null) {
            ActionCallback callback = this.myLocalWaitInstallCallbacks.remove(id2);
            if (callback == null) {
                return this.prepareToInstall(pluginNode, pluginIds);
            }
            return callback.waitFor(-1L) && callback.isDone();
        }
        try {
            boolean result2 = this.prepareToInstall(pluginNode, pluginIds);
            PluginInstallOperation.removeInstallCallback(id2, localCallback, result2);
            return result2;
        }
        catch (IOException | RuntimeException e) {
            PluginInstallOperation.removeInstallCallback(id2, localCallback, false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private boolean prepareToInstall(@NotNull PluginUiModel pluginNode, @NotNull List<PluginId> pluginIds) throws IOException {
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(14);
        }
        if (pluginIds == null) {
            PluginInstallOperation.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.assertBackgroundThread();
        if (!this.checkMissingDependencies(pluginNode.getDescriptor(), pluginIds)) {
            return false;
        }
        if (!PluginManagementPolicy.getInstance().canInstallPlugin(pluginNode.getDescriptor())) {
            LOG.warn("The plugin " + String.valueOf(pluginNode.getPluginId()) + " is not allowed to install for the organization");
            return false;
        }
        IdeaPluginDescriptor toDisable = this.checkDependenciesAndReplacements(pluginNode.getDescriptor());
        this.myShownErrors = false;
        PluginDownloader downloader = PluginDownloader.createDownloader(pluginNode, pluginNode.getRepositoryName(), null);
        IdeaPluginDescriptor previousDescriptor = PluginManagerCore.getPlugin((PluginId)pluginNode.getPluginId());
        String previousVersion = previousDescriptor == null ? null : previousDescriptor.getVersion();
        PluginManagerUsageCollector.pluginInstallationStarted(pluginNode.getDescriptor(), downloader.isFromMarketplace() ? InstallationSourceEnum.MARKETPLACE : InstallationSourceEnum.CUSTOM_REPOSITORY, previousVersion);
        boolean prepared = downloader.prepareToInstall(this.myIndicator);
        if (prepared) {
            boolean allowNoRestart;
            IdeaPluginDescriptorImpl descriptor = (IdeaPluginDescriptorImpl)downloader.getDescriptor();
            if (pluginNode.getDependencies().isEmpty() && !descriptor.getDependencies().isEmpty() && !this.checkMissingDependencies((IdeaPluginDescriptor)descriptor, pluginIds)) {
                return false;
            }
            boolean bl = allowNoRestart = this.myAllowInstallWithoutRestart && DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor, null, ContainerUtil.map(this.myPendingDynamicPluginInstalls, pluginInstall -> pluginInstall.getPluginDescriptor()));
            if (allowNoRestart) {
                this.myPendingDynamicPluginInstalls.add(new PendingDynamicPluginInstall(downloader.getFilePath(), descriptor));
                state = InstalledPluginsState.getInstanceIfLoaded();
                if (state != null) {
                    ((InstalledPluginsState)state).onPluginInstall(downloader.getDescriptor(), false, false);
                }
            } else {
                this.myRestartRequired = true;
                state = PluginInstaller.ourLock;
                synchronized (state) {
                    downloader.install();
                }
            }
            this.myDependant.add(new PluginInstallCallbackData(downloader.getFilePath(), (IdeaPluginDescriptor)descriptor, !allowNoRestart));
            IdeaPluginDescriptor ideaPluginDescriptor = pluginNode.getDescriptor();
            if (ideaPluginDescriptor instanceof PluginNode) {
                PluginNode node = (PluginNode)ideaPluginDescriptor;
                node.setStatus(PluginNode.Status.DOWNLOADED);
            }
            if (toDisable != null) {
                this.myPluginEnabler.disable(Set.of(toDisable));
            }
            return true;
        }
        this.myShownErrors = downloader.isShownErrors();
        return false;
    }

    @Nullable
    IdeaPluginDescriptor checkDependenciesAndReplacements(@NotNull IdeaPluginDescriptor pluginNode) {
        PluginReplacement pluginReplacement;
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(16);
        }
        if ((pluginReplacement = (PluginReplacement)ContainerUtil.find((Object[])((PluginReplacement[])PluginReplacement.EP_NAME.getExtensions()), r -> r.getNewPluginId().equals(pluginNode.getPluginId().getIdString()))) == null) {
            return null;
        }
        PluginId oldPluginId = pluginReplacement.getOldPluginDescriptor().getPluginId();
        IdeaPluginDescriptor oldPlugin = PluginManagerCore.getPlugin((PluginId)oldPluginId);
        if (oldPlugin == null) {
            LOG.warn("Plugin with id '" + String.valueOf(oldPluginId) + "' not found");
            return null;
        }
        if (this.myPluginEnabler.isDisabled(oldPlugin.getPluginId())) {
            return null;
        }
        AtomicBoolean toDisable = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            boolean choice = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)pluginReplacement.getReplacementMessage(oldPlugin, pluginNode), (String)IdeBundle.message((String)"plugin.manager.obsolete.plugins.detected.title", (Object[])new Object[0])).yesText(IdeBundle.message((String)"plugins.configurable.disable", (Object[])new Object[0]))).noText(Messages.getNoButton())).icon(Messages.getWarningIcon())).guessWindowAndAsk();
            toDisable.set(choice);
        }, ModalityState.any());
        return toDisable.get() ? oldPlugin : null;
    }

    boolean checkMissingDependencies(@NotNull IdeaPluginDescriptor pluginNode, @Nullable List<PluginId> pluginIds) {
        List dependencies;
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(17);
        }
        if ((dependencies = pluginNode.getDependencies()).isEmpty()) {
            return true;
        }
        ArrayList<PluginUiModel> depends = new ArrayList<PluginUiModel>();
        ArrayList<PluginUiModel> optionalDeps = new ArrayList<PluginUiModel>();
        for (IdeaPluginDependency dependency : dependencies) {
            PluginUiModel depPluginDescriptor;
            PluginId depPluginId = dependency.getPluginId();
            if (PluginManagerCore.looksLikePlatformPluginAlias((PluginId)depPluginId)) {
                PluginId pluginIdByModule;
                IdeaPluginDescriptorImpl descriptorByModule = PluginManagerCore.findPluginByPlatformAlias((PluginId)depPluginId);
                PluginId pluginId = pluginIdByModule = descriptorByModule != null ? descriptorByModule.getPluginId() : PluginInstallOperation.getCachedPluginId(depPluginId.getIdString());
                if (pluginIdByModule == null) continue;
                depPluginId = pluginIdByModule;
            }
            if (PluginManagerCore.isPluginInstalled((PluginId)depPluginId) || InstalledPluginsState.getInstance().wasInstalled(depPluginId) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart(depPluginId) || pluginIds != null && pluginIds.contains(depPluginId) || (depPluginDescriptor = this.findPluginInRepo(depPluginId)) == null) continue;
            (dependency.isOptional() ? optionalDeps : depends).add(depPluginDescriptor);
        }
        if (!this.prepareDependencies(pluginNode, depends, "plugin.manager.dependencies.detected.title", "plugin.manager.dependencies.detected.message", false)) {
            return false;
        }
        return !Registry.is((String)"ide.plugins.suggest.install.optional.dependencies") || this.prepareDependencies(pluginNode, optionalDeps, "plugin.manager.optional.dependencies.detected.title", "plugin.manager.optional.dependencies.detected.message", true);
    }

    private boolean prepareDependencies(@NotNull IdeaPluginDescriptor pluginNode, @NotNull List<PluginUiModel> dependencies, @NotNull @NonNls String titleKey, @NotNull @NonNls String messageKey, boolean askConfirmation) {
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(18);
        }
        if (dependencies == null) {
            PluginInstallOperation.$$$reportNull$$$0(19);
        }
        if (titleKey == null) {
            PluginInstallOperation.$$$reportNull$$$0(20);
        }
        if (messageKey == null) {
            PluginInstallOperation.$$$reportNull$$$0(21);
        }
        if (dependencies.isEmpty()) {
            return true;
        }
        try {
            Ref result2 = new Ref((Object)false);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                Object object = ourInstallLock;
                synchronized (object) {
                    InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
                    LinkedHashSet<PluginId> dependenciesToShow = new LinkedHashSet<PluginId>();
                    Iterator iterator = dependencies.iterator();
                    while (iterator.hasNext()) {
                        PluginId pluginId = ((PluginUiModel)iterator.next()).getPluginId();
                        ActionCallback callback = ourInstallCallbacks.get(pluginId);
                        if (callback == null || callback.isRejected()) {
                            if (pluginsState.wasInstalled(pluginId) || pluginsState.wasInstalledWithoutRestart(pluginId)) {
                                iterator.remove();
                                continue;
                            }
                            dependenciesToShow.add(pluginId);
                            continue;
                        }
                        this.myLocalWaitInstallCallbacks.put(pluginId, callback);
                    }
                    if (dependenciesToShow.isEmpty()) {
                        result2.set((Object)true);
                        return;
                    }
                    if (!askConfirmation) {
                        for (PluginId dependency : dependenciesToShow) {
                            this.createInstallCallback(dependency);
                        }
                        result2.set((Object)true);
                    } else {
                        String deps = PluginInstallOperation.getPluginsText(dependencies);
                        int dialogResult = Messages.showYesNoDialog((String)IdeBundle.message((String)messageKey, (Object[])new Object[]{pluginNode.getName(), deps}), (String)IdeBundle.message((String)titleKey, (Object[])new Object[0]), (String)IdeBundle.message((String)"plugins.configurable.install", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
                        result2.set((Object)(dialogResult == 0 ? 1 : 0));
                        if (((Boolean)result2.get()).booleanValue()) {
                            for (PluginId dependency : dependenciesToShow) {
                                this.createInstallCallback(dependency);
                            }
                        }
                    }
                }
            }, ModalityState.any());
            return dependencies.isEmpty() || (Boolean)result2.get() != false && this.prepareToInstall(dependencies);
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    @Nls
    private static String getPluginsText(@NotNull List<PluginUiModel> nodes) {
        List pluginNames;
        int size2;
        if (nodes == null) {
            PluginInstallOperation.$$$reportNull$$$0(22);
        }
        if ((size2 = (pluginNames = ContainerUtil.map(nodes, node -> StringUtil.wrapWithDoubleQuote((String)node.getName()))).size()) == 1) {
            String string = (String)pluginNames.get(0);
            if (string == null) {
                PluginInstallOperation.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = NlsMessages.formatAndList((Collection)pluginNames);
        if (string == null) {
            PluginInstallOperation.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    private PluginUiModel findPluginInRepo(@NotNull PluginId depPluginId) {
        if (depPluginId == null) {
            PluginInstallOperation.$$$reportNull$$$0(25);
        }
        PluginUiModel pluginFromCustomRepos = ((Stream)this.myCustomReposPlugins.stream().parallel()).filter(p -> p.getPluginId().equals((Object)depPluginId)).findAny().orElse(null);
        PluginUiModel pluginFromMarketplace = MarketplaceRequests.getInstance().getLastCompatiblePluginUpdateModel(depPluginId);
        boolean fromCustomRepos = pluginFromMarketplace == null || pluginFromCustomRepos != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(pluginFromCustomRepos.getVersion(), pluginFromMarketplace.getDescriptor()) > 0;
        return fromCustomRepos ? pluginFromCustomRepos : pluginFromMarketplace;
    }

    @Nullable
    private static PluginId getCachedPluginId(@NotNull String pluginId) {
        Optional cachedModule;
        if (pluginId == null) {
            PluginInstallOperation.$$$reportNull$$$0(26);
        }
        if ((cachedModule = (Optional)ourCache.getIfPresent((Object)pluginId)) != null && cachedModule.isPresent()) {
            return (PluginId)cachedModule.get();
        }
        PluginId result2 = MarketplaceRequests.getInstance().getCompatibleUpdateByModule(pluginId);
        ourCache.put((Object)pluginId, Optional.ofNullable(result2));
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customReposPlugins";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginNode";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleKey";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginInstallOperation";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depPluginId";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginInstallOperation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeInstallCallback";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createInstallCallback";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstallWithCallback";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkDependenciesAndReplacements";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkMissingDependencies";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prepareDependencies";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsText";
                break;
            }
            case 23: 
            case 24: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findPluginInRepo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPluginId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 23, 24 -> new IllegalStateException(string);
        };
    }
}

