/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LicenseExpirationDialog;
import com.intellij.ide.ui.SubscriptionExpirationSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InlineBanner;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0014J\r\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0014J\r\u0010\u0012\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0002J\r\u0010\u0013\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0014J\r\u0010\u0014\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0002J\r\u0010\u0015\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/ui/SubscriptionExpirationDialog;", "Lcom/intellij/ide/ui/LicenseExpirationDialog;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/ide/ui/SubscriptionExpirationSettings;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/ui/SubscriptionExpirationSettings;)V", "selectionButton", "", "configureHeader", "", "header", "Ljavax/swing/JComponent;", "createPanel", "getOKActionText", "", "Lorg/jetbrains/annotations/Nls;", "dialogTitle", "getCancelActionText", "getApplicationName", "getPlatformName", "ResultState", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSubscriptionExpirationDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionExpirationDialog.kt\ncom/intellij/ide/ui/SubscriptionExpirationDialog\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,204:1\n27#2:205\n*S KotlinDebug\n*F\n+ 1 SubscriptionExpirationDialog.kt\ncom/intellij/ide/ui/SubscriptionExpirationDialog\n*L\n125#1:205\n*E\n"})
public final class SubscriptionExpirationDialog
extends LicenseExpirationDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SubscriptionExpirationSettings settings;
    private int selectionButton;

    public SubscriptionExpirationDialog(@Nullable Project project2, @NotNull SubscriptionExpirationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(project2, SubscriptionExpirationDialog.Companion.getImagePath());
        this.settings = settings;
        this.initDialog(this.dialogTitle());
    }

    @Override
    protected void configureHeader(@NotNull JComponent header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        if (this.settings.getErrorMessage() != null) {
            InlineBanner banner = new InlineBanner(this.settings.getErrorMessage(), EditorNotificationPanel.Status.Warning).showCloseButton(false);
            Wrapper errorLabel = new Wrapper((JComponent)banner);
            errorLabel.setBorder((Border)JBUI.Borders.empty((int)20, (int)20, (int)0, (int)20));
            header.setLayout(new BorderLayout());
            header.add((Component)errorLabel, "North");
        }
    }

    @Override
    @NotNull
    protected JComponent createPanel() {
        DialogPanel panel2 = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> SubscriptionExpirationDialog.createPanel$lambda$0(this, arg_0)));
        return (JComponent)panel2;
    }

    @Override
    @NotNull
    protected String getOKActionText() {
        String string;
        switch (this.selectionButton) {
            case 0: {
                Object[] objectArray = new Object[]{this.getPlatformName()};
                String string2 = IdeBundle.message((String)"subscription.dialog.activate.ok.text", (Object[])objectArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                break;
            }
            case 1: {
                String string3 = IdeBundle.message((String)"subscription.dialog.promise.ok.text", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                break;
            }
            case 2: {
                String string4 = IdeBundle.message((String)"subscription.dialog.extend.ok.text", (Object[])new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                break;
            }
            default: {
                String string5 = IdeBundle.message((String)"subscription.dialog.continue.ok.text", (Object[])new Object[0]);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            }
        }
        return string;
    }

    private final String dialogTitle() {
        String key = this.settings.isEvaluation() ? "subscription.dialog.title.evaluation" : "subscription.dialog.title.subscription";
        Object[] objectArray = new Object[]{this.getPlatformName()};
        String string = IdeBundle.message((String)key, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected String getCancelActionText() {
        Object[] objectArray = new Object[]{this.getApplicationName()};
        String string = IdeBundle.message((String)"subscription.dialog.cancel.button", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final String getApplicationName() {
        String string = IdeBundle.message((String)(PlatformUtils.isPyCharm() ? "subscription.dialog.pycharm" : "subscription.dialog.idea"), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final String getPlatformName() {
        String string = IdeBundle.message((String)(PlatformUtils.isPyCharm() ? "subscription.dialog.pro" : "subscription.dialog.ultimate"), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createPanel$lambda$0(SubscriptionExpirationDialog this$0, Panel $this$panel) {
        void getter$iv;
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String platformName = this$0.getPlatformName();
        Panel.row$default($this$panel, null, arg_0 -> SubscriptionExpirationDialog.createPanel$lambda$0$0(this$0, arg_0), 1, null);
        Panel.row$default($this$panel, null, arg_0 -> SubscriptionExpirationDialog.createPanel$lambda$0$1(platformName, arg_0), 1, null);
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default($this$panel, null, false, arg_0 -> SubscriptionExpirationDialog.createPanel$lambda$0$2(this$0, platformName, arg_0), 3, null);
        Function0 function0 = () -> SubscriptionExpirationDialog.createPanel$lambda$0$3(this$0);
        Function1 setter$iv = arg_0 -> SubscriptionExpirationDialog.createPanel$lambda$0$4(this$0, arg_0);
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Integer.class);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(SubscriptionExpirationDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.dialogTitle()).getComponent().setFont((Font)JBFont.h1());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(String $platformName, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{$platformName};
        String string = IdeBundle.message((String)"subscription.dialog.link", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.browserLink(string, "https://www.jetbrains.com/idea/features");
        $this$row.bottomGap(BottomGap.MEDIUM);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(SubscriptionExpirationDialog this$0, String $platformName, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        ActionListener listener2 = arg_0 -> SubscriptionExpirationDialog.createPanel$lambda$0$2$0(this$0, $platformName, arg_0);
        Panel.row$default($this$buttonsGroup, null, arg_0 -> SubscriptionExpirationDialog.createPanel$lambda$0$2$1($platformName, listener2, arg_0), 1, null);
        if (this$0.settings.getShowPromise()) {
            Panel.row$default($this$buttonsGroup, null, arg_0 -> SubscriptionExpirationDialog.createPanel$lambda$0$2$2(listener2, arg_0), 1, null);
        }
        if (this$0.settings.getShowExtendTrial()) {
            Panel.row$default($this$buttonsGroup, null, arg_0 -> SubscriptionExpirationDialog.createPanel$lambda$0$2$3(listener2, arg_0), 1, null);
        }
        if (this$0.settings.getShowContinueWithoutSubscription()) {
            Panel.row$default($this$buttonsGroup, null, arg_0 -> SubscriptionExpirationDialog.createPanel$lambda$0$2$4(listener2, this$0, arg_0), 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final void createPanel$lambda$0$2$0(SubscriptionExpirationDialog this$0, String $platformName, ActionEvent e) {
        Object[] objectArray;
        String string = e.getActionCommand();
        this$0.selectionButton = Intrinsics.areEqual((Object)string, (Object)IdeBundle.message((String)"subscription.dialog.activate.button", (Object[])(objectArray = new Object[]{$platformName}))) ? 0 : (Intrinsics.areEqual((Object)string, (Object)IdeBundle.message((String)"subscription.dialog.promise.button", (Object[])new Object[0])) ? 1 : (Intrinsics.areEqual((Object)string, (Object)IdeBundle.message((String)"subscription.dialog.extend.button", (Object[])new Object[0])) ? 2 : 3));
        this$0.updateOKActionText();
    }

    private static final Unit createPanel$lambda$0$2$1(String $platformName, ActionListener $listener, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{$platformName};
        String string = IdeBundle.message((String)"subscription.dialog.activate.button", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.radioButton(string, 0).getComponent().addActionListener($listener);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$2(ActionListener $listener, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"subscription.dialog.promise.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.radioButton(string, 1).getComponent().addActionListener($listener);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$3(ActionListener $listener, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"subscription.dialog.extend.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.radioButton(string, 2).getComponent().addActionListener($listener);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$4(ActionListener $listener, SubscriptionExpirationDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"subscription.dialog.continue.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell<JBRadioButton> cell = $this$row.radioButton(string, 3);
        cell.getComponent().addActionListener($listener);
        if (this$0.settings.getShowRemDevHint()) {
            Cell.comment$default(cell, IdeBundle.message((String)"subscription.dialog.rd.hint", (Object[])new Object[0]), 0, null, 6, null);
        }
        return Unit.INSTANCE;
    }

    private static final int createPanel$lambda$0$3(SubscriptionExpirationDialog this$0) {
        return this$0.selectionButton;
    }

    private static final Unit createPanel$lambda$0$4(SubscriptionExpirationDialog this$0, int it) {
        this$0.selectionButton = it;
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final ResultState show(@Nullable Project project2, @NotNull SubscriptionExpirationSettings settings) {
        return Companion.show(project2, settings);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/ui/SubscriptionExpirationDialog$Companion;", "", "<init>", "()V", "getImagePath", "", "show", "Lcom/intellij/ide/ui/SubscriptionExpirationDialog$ResultState;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/ide/ui/SubscriptionExpirationSettings;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String getImagePath() {
            if (PlatformUtils.isPyCharm()) {
                return "/images/PyCharmBannerLogo.png";
            }
            return "/images/IdeaBannerLogo.png";
        }

        @JvmStatic
        @NotNull
        public final ResultState show(@Nullable Project project2, @NotNull SubscriptionExpirationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            SubscriptionExpirationDialog dialog2 = new SubscriptionExpirationDialog(project2, settings);
            dialog2.show();
            if (dialog2.getExitCode() != 0) {
                return ResultState.CANCEL;
            }
            return switch (dialog2.selectionButton) {
                case 0 -> ResultState.ACTIVATE;
                case 1 -> ResultState.PROMISE;
                case 2 -> ResultState.EXTEND_TRIAL;
                default -> ResultState.CONTINUE;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/ui/SubscriptionExpirationDialog$ResultState;", "", "<init>", "(Ljava/lang/String;I)V", "CANCEL", "ACTIVATE", "PROMISE", "EXTEND_TRIAL", "CONTINUE", "intellij.platform.ide.impl"})
    public static final class ResultState
    extends Enum<ResultState> {
        public static final /* enum */ ResultState CANCEL = new ResultState();
        public static final /* enum */ ResultState ACTIVATE = new ResultState();
        public static final /* enum */ ResultState PROMISE = new ResultState();
        public static final /* enum */ ResultState EXTEND_TRIAL = new ResultState();
        public static final /* enum */ ResultState CONTINUE = new ResultState();
        private static final /* synthetic */ ResultState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ResultState[] values() {
            return (ResultState[])$VALUES.clone();
        }

        public static ResultState valueOf(String value) {
            return Enum.valueOf(ResultState.class, value);
        }

        @NotNull
        public static EnumEntries<ResultState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resultStateArray = new ResultState[]{ResultState.CANCEL, ResultState.ACTIVATE, ResultState.PROMISE, ResultState.EXTEND_TRIAL, ResultState.CONTINUE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

