/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.experimental.meetNewUi;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.LafReference;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.experimental.ExperimentalUiCollector;
import com.intellij.ide.ui.experimental.meetNewUi.Density;
import com.intellij.ide.ui.experimental.meetNewUi.MeetNewUiButton;
import com.intellij.ide.ui.experimental.meetNewUi.MeetNewUiCustomization;
import com.intellij.ide.ui.experimental.meetNewUi.MeetNewUiToolWindow;
import com.intellij.ide.ui.experimental.meetNewUi.Theme;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.util.IconUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.WrapLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u0010\u0016\u001a\u00020\f*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ide/ui/experimental/meetNewUi/MeetNewUiToolWindow;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "themes", "", "Lcom/intellij/ide/ui/experimental/meetNewUi/Theme;", "cleanDensity", "Lcom/intellij/ide/ui/experimental/meetNewUi/Density;", "compactDensity", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "updateThemeSelection", "", "findLafReference", "Lcom/intellij/ide/ui/LafReference;", "name", "", "density", "Lcom/intellij/ui/dsl/builder/Row;", "icon", "Ljavax/swing/Icon;", "gaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGaps;", "compactMode", "", "updateDensitySelection", "setDensity", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nMeetNewUiToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeetNewUiToolWindow.kt\ncom/intellij/ide/ui/experimental/meetNewUi/MeetNewUiToolWindow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,275:1\n1761#2,3:276\n1#3:279\n13#4:280\n*S KotlinDebug\n*F\n+ 1 MeetNewUiToolWindow.kt\ncom/intellij/ide/ui/experimental/meetNewUi/MeetNewUiToolWindow\n*L\n150#1:276,3\n45#1:280\n*E\n"})
public final class MeetNewUiToolWindow
extends SimpleToolWindowPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final List<Theme> themes;
    private Density cleanDensity;
    private Density compactDensity;
    @NotNull
    private final DialogPanel panel;
    @NotNull
    private static final Logger LOG;
    private static final int CUSTOM_THEME_INDEX = 0;
    @NotNull
    private static final Icon BANNER;
    private static final int BANNER_HEIGHT = 231;

    public MeetNewUiToolWindow(@NotNull Project project2, @NotNull ToolWindow toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        super(true, true);
        this.project = project2;
        this.toolWindow = toolWindow2;
        this.themes = new ArrayList();
        this.panel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> MeetNewUiToolWindow.panel$lambda$0(this, arg_0)));
        JBScrollPane content2 = new JBScrollPane((Component)this.panel);
        content2.setOverlappingScrollBar(true);
        this.setContent((JComponent)content2);
        this.updateThemeSelection();
        this.updateDensitySelection();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Disposable disposable = this.toolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection connection = messageBus.connect(disposable);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> MeetNewUiToolWindow._init_$lambda$0(this, arg_0));
        Topic topic2 = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, arg_0 -> MeetNewUiToolWindow._init_$lambda$1(this, arg_0));
    }

    private final void updateThemeSelection() {
        boolean exist;
        LafReference currentLafReference;
        LafManager lafManager;
        block5: {
            lafManager = LafManager.getInstance();
            currentLafReference = lafManager.getLookAndFeelReference();
            Iterable $this$any$iv = this.themes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Theme it = (Theme)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getLafReference(), (Object)currentLafReference)) continue;
                    v0 = true;
                    break block5;
                }
                v0 = exist = false;
            }
        }
        if (!exist) {
            this.themes.get(0).setLafReference(currentLafReference);
        }
        for (Theme theme : this.themes) {
            boolean selected = lafManager.getAutodetect() ? theme.getSystem() : Intrinsics.areEqual((Object)currentLafReference, (Object)theme.getLafReference());
            theme.getButton().setSelected(selected);
            theme.getButton().setFont(selected ? JBFont.regular().deriveFont(1) : (Font)JBFont.regular());
        }
    }

    private final LafReference findLafReference(String name2) {
        Object v1;
        block1: {
            LafManager lafManager = LafManager.getInstance();
            List list2 = lafManager.getLafComboBoxModel().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
            Iterable iterable = list2;
            for (Object t : iterable) {
                LafReference it = (LafReference)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)name2)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final Density density(Row $this$density, Icon icon2, @Nls String name2, UnscaledGaps gaps, boolean compactMode) {
        JLabel jLabel;
        MeetNewUiButton meetNewUiButton;
        MeetNewUiButton $this$density_u24lambda_u240 = meetNewUiButton = new MeetNewUiButton(null, icon2, icon2);
        boolean bl = false;
        $this$density_u24lambda_u240.setBorder(null);
        $this$density_u24lambda_u240.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
        $this$density_u24lambda_u240.setSelectionArc(JBUI.scale((int)8));
        $this$density_u24lambda_u240.addClickListener(() -> MeetNewUiToolWindow.density$lambda$0$0(this, compactMode));
        MeetNewUiButton button2 = meetNewUiButton;
        Ref.ObjectRef label2 = new Ref.ObjectRef();
        $this$density.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> MeetNewUiToolWindow.density$lambda$1(button2, label2, name2, arg_0))).customize(gaps);
        if (label2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"label");
            jLabel = null;
        } else {
            jLabel = (JLabel)label2.element;
        }
        return new Density(button2, jLabel);
    }

    private final void updateDensitySelection() {
        boolean compactMode = UISettings.Companion.getInstance().getCompactMode();
        Density density = this.cleanDensity;
        if (density == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cleanDensity");
            density = null;
        }
        density.setSelection(!compactMode);
        Density density2 = this.compactDensity;
        if (density2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compactDensity");
            density2 = null;
        }
        density2.setSelection(compactMode);
    }

    private final void setDensity(boolean compactMode) {
        UISettings uiSettings = UISettings.Companion.getInstance();
        if (uiSettings.getCompactMode() != compactMode) {
            ExperimentalUiCollector.MeetNewUiAction densityAction = compactMode ? ExperimentalUiCollector.MeetNewUiAction.DENSITY_COMPACT : ExperimentalUiCollector.MeetNewUiAction.DENSITY_CLEAN;
            ExperimentalUiCollector.logMeetNewUiAction(densityAction);
            uiSettings.setCompactMode(compactMode);
            LafManager.getInstance().applyDensity();
        }
    }

    private static final Unit panel$lambda$0(MeetNewUiToolWindow this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new EmptySpacingConfiguration(), (Function1<? super Panel, Unit>)((Function1)arg_0 -> MeetNewUiToolWindow.panel$lambda$0$0(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0(MeetNewUiToolWindow this$0, Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        Panel.row$default($this$customizeSpacingConfiguration, null, arg_0 -> MeetNewUiToolWindow.panel$lambda$0$0$0(this$0, arg_0), 1, null);
        $this$customizeSpacingConfiguration.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> MeetNewUiToolWindow.panel$lambda$0$0$1(this$0, arg_0))).customize(UnscaledGapsKt.UnscaledGaps((int)32, (int)32, (int)16, (int)32));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$0(MeetNewUiToolWindow this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        float scale = (float)JBUI.scale((int)231) / (float)BANNER.getIconHeight();
        Icon icon2 = IconUtil.scale((Icon)BANNER, (Component)WindowManager.getInstance().getFrame(this$0.project), (float)scale);
        $this$row.cell((JComponent)new JLabel(icon2){

            public Color getBackground() {
                return (Color)new JBColor(JBUI.CurrentTheme.ToolWindow.background(), (Color)Gray.x01);
            }
        }).align(AlignX.FILL.INSTANCE).applyToComponent((Function1<JComponent, Unit>)((Function1)MeetNewUiToolWindow::panel$lambda$0$0$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$0$0(panel.1.1.1.1 $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMinimumSize((Dimension)new JBDimension(1, 231));
        $this$applyToComponent.setPreferredSize((Dimension)new JBDimension(1, 231));
        $this$applyToComponent.setOpaque(true);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$1(MeetNewUiToolWindow this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, MeetNewUiToolWindow::panel$lambda$0$0$1$0, 1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)0, (int)24, (int)1, null));
        Panel.row$default($this$panel, null, MeetNewUiToolWindow::panel$lambda$0$0$1$1, 1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)0, (int)8, (int)1, null));
        Panel.row$default($this$panel, null, arg_0 -> MeetNewUiToolWindow.panel$lambda$0$0$1$2(this$0, arg_0), 1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)0, (int)20, (int)1, null));
        Panel.row$default($this$panel, null, MeetNewUiToolWindow::panel$lambda$0$0$1$3, 1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)0, (int)8, (int)1, null));
        Panel.row$default($this$panel, null, arg_0 -> MeetNewUiToolWindow.panel$lambda$0$0$1$4(this$0, arg_0), 1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)0, (int)20, (int)1, null));
        Panel.row$default($this$panel, null, arg_0 -> MeetNewUiToolWindow.panel$lambda$0$0$1$5(this$0, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$1$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"meetnewui.toolwindow.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).applyToComponent((Function1<JLabel, Unit>)((Function1)MeetNewUiToolWindow::panel$lambda$0$0$1$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$1$0$0(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont(JBFont.regular().biggerOn(7.0f).deriveFont(0));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$1$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"meetnewui.toolwindow.theme", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$1$2(MeetNewUiToolWindow this$0, Row $this$row) {
        String string;
        LafReference lafReference;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ((Collection)this$0.themes).add(new Theme(null, false, null, null));
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String string2 = appInfo.getDefaultLightLaf();
        if (string2 == null) {
            string2 = "Light";
        }
        LafReference lafReference2 = this$0.findLafReference(string2);
        if (lafReference2 != null) {
            lafReference = lafReference2;
            boolean bl = false;
            ((Collection)this$0.themes).add(new Theme(lafReference, false, AllIcons.MeetNewUi.LightTheme, AllIcons.MeetNewUi.LightThemeSelected));
        }
        if ((string = appInfo.getDefaultDarkLaf()) == null) {
            string = "Dark";
        }
        LafReference lafReference3 = this$0.findLafReference(string);
        if (lafReference3 != null) {
            lafReference = lafReference3;
            boolean bl = false;
            ((Collection)this$0.themes).add(new Theme(lafReference, false, AllIcons.MeetNewUi.DarkTheme, AllIcons.MeetNewUi.DarkThemeSelected));
        }
        if (LafManager.getInstance().getAutodetectSupported()) {
            ((Collection)this$0.themes).add(new Theme(null, true, AllIcons.MeetNewUi.SystemTheme, AllIcons.MeetNewUi.SystemThemeSelected));
        }
        int gap = JBUI.scale((int)8);
        JPanel themesPanel = new JPanel((LayoutManager)new WrapLayout(3, gap, gap));
        themesPanel.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGapsKt.UnscaledGaps((int)gap));
        for (Theme theme : this$0.themes) {
            themesPanel.add(theme.getButton());
        }
        $this$row.cell((JComponent)themesPanel).align(AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$1$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"meetnewui.toolwindow.density", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$1$4(MeetNewUiToolWindow this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon2 = AllIcons.MeetNewUi.DensityDefault;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"DensityDefault");
        String string = IdeBundle.message((String)"meetnewui.toolwindow.clean", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.cleanDensity = this$0.density($this$row, icon2, string, UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)8, (int)7, null), false);
        Icon icon3 = AllIcons.MeetNewUi.DensityCompact;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"DensityCompact");
        String string2 = IdeBundle.message((String)"meetnewui.toolwindow.compact", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this$0.compactDensity = this$0.density($this$row, icon3, string2, UnscaledGaps.EMPTY, true);
        $this$row.cell();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$1$5(MeetNewUiToolWindow this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"meetnewui.toolwindow.button.finishSetup", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.button(string, (Function1<? super ActionEvent, Unit>)((Function1)arg_0 -> MeetNewUiToolWindow.panel$lambda$0$0$1$5$0(this$0, arg_0)));
        MeetNewUiCustomization meetNewUiCustomization = MeetNewUiCustomization.Companion.firstOrNull();
        if (meetNewUiCustomization != null) {
            meetNewUiCustomization.addButtons(this$0.project, $this$row);
        }
        $this$row.cell();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$1$5$0(MeetNewUiToolWindow this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.Companion.getInstanceEx(this$0.project);
        Intrinsics.checkNotNull((Object)((Object)toolWindowManagerEx), (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
        ToolWindowManagerImpl toolWindowManager = (ToolWindowManagerImpl)toolWindowManagerEx;
        String string = this$0.toolWindow.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        ToolWindowManagerImpl.hideToolWindow$default(toolWindowManager, string, true, false, true, null, 20, null);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$0(MeetNewUiToolWindow this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateThemeSelection();
    }

    private static final void _init_$lambda$1(MeetNewUiToolWindow this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateDensitySelection();
    }

    private static final void density$lambda$0$0(MeetNewUiToolWindow this$0, boolean $compactMode) {
        this$0.setDensity($compactMode);
    }

    private static final Unit density$lambda$1(MeetNewUiButton $button, Ref.ObjectRef $label, String $name, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, arg_0 -> MeetNewUiToolWindow.density$lambda$1$0($button, arg_0), 1, null);
        Panel.row$default($this$panel, null, arg_0 -> MeetNewUiToolWindow.density$lambda$1$1($label, $name, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit density$lambda$1$0(MeetNewUiButton $button, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$button).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)8, (int)0, (int)11, null));
        return Unit.INSTANCE;
    }

    private static final Unit density$lambda$1$1(Ref.ObjectRef $label, String $name, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $label.element = $this$row.label($name).applyToComponent((Function1<JLabel, Unit>)((Function1)MeetNewUiToolWindow::density$lambda$1$1$0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit density$lambda$1$1$0(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont((Font)JBFont.medium());
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MeetNewUiToolWindow.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ClassLoader classLoader = MeetNewUiToolWindow.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        BANNER = IconLoader.getIcon((String)"expui/meetNewUi/newUIOnboardingToolWindow.png", (ClassLoader)classLoader);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/ui/experimental/meetNewUi/MeetNewUiToolWindow$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_platform_ide_impl", "()Lcom/intellij/openapi/diagnostic/Logger;", "CUSTOM_THEME_INDEX", "", "BANNER", "Ljavax/swing/Icon;", "BANNER_HEIGHT", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_platform_ide_impl() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

