/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.io.IOUtil;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.StyleSheetUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Deprecated
public final class TipUIUtil {
    private static final Logger LOG = Logger.getInstance(TipUIUtil.class);

    public static Browser createBrowser() {
        return new SwingBrowser();
    }

    private static final class SwingBrowser
    extends JEditorPane
    implements Browser {
        SwingBrowser() {
            this.setEditable(false);
            this.setBackground(UIUtil.getTextFieldBackground());
            this.addHyperlinkListener(new HyperlinkListener(this){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserUtil.browse((URL)e.getURL());
                    }
                }
            });
            HTMLEditorKit kit2 = new HTMLEditorKitBuilder().replaceViewFactoryExtensions(new Function2[]{this.getSVGImagesExtension()}).withGapsBetweenParagraphs().build();
            String fileName = "tips/css/" + (StartupUiUtil.isUnderDarcula() ? "tips_darcula.css" : "tips.css");
            try {
                byte[] data2 = ResourceUtil.getResourceAsBytes((String)fileName, (ClassLoader)TipUIUtil.class.getClassLoader());
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.assertTrue(data2 != null);
                }
                if (data2 != null) {
                    kit2.getStyleSheet().addStyleSheet(StyleSheetUtil.loadStyleSheet((InputStream)new ByteArrayInputStream(data2)));
                }
            }
            catch (IOException e) {
                LOG.error("Cannot load stylesheet " + fileName, (Throwable)e);
            }
            this.setEditorKit(kit2);
        }

        @NotNull
        private ExtendableHTMLViewFactory.Extension getSVGImagesExtension() {
            ExtendableHTMLViewFactory.Extension extension = (elem, view2) -> {
                if (!(view2 instanceof ImageView)) {
                    return null;
                }
                String src = (String)view2.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
                if (src != null) {
                    try {
                        final URL url = new URL(src);
                        Dictionary cache = (Dictionary)elem.getDocument().getProperty("imageCache");
                        if (cache == null) {
                            cache = new Dictionary(this){
                                private final HashMap myMap = new HashMap();

                                @Override
                                public int size() {
                                    return this.myMap.size();
                                }

                                @Override
                                public boolean isEmpty() {
                                    return this.size() == 0;
                                }

                                public Enumeration keys() {
                                    return Collections.enumeration(this.myMap.keySet());
                                }

                                public Enumeration elements() {
                                    return Collections.enumeration(this.myMap.values());
                                }

                                public Object get(Object key) {
                                    return this.myMap.get(key);
                                }

                                public Object put(Object key, Object value) {
                                    return this.myMap.put(key, value);
                                }

                                public Object remove(Object key) {
                                    return this.myMap.remove(key);
                                }
                            };
                            elem.getDocument().putProperty("imageCache", cache);
                        }
                        final Image image2 = src.endsWith(".svg") ? SVGLoader.load((URL)url, (float)(JBUI.isPixHiDPI((Component)null) ? 2.0f : 1.0f)) : Toolkit.getDefaultToolkit().createImage(url);
                        cache.put(url, image2);
                        if (src.endsWith(".svg")) {
                            return new ImageView(this, (Element)elem){

                                @Override
                                public Image getImage() {
                                    return image2;
                                }

                                @Override
                                public URL getImageURL() {
                                    return url;
                                }

                                @Override
                                public void paint(Graphics g, Shape a) {
                                    Rectangle bounds = a.getBounds();
                                    int width = (int)this.getPreferredSpan(0);
                                    int height = (int)this.getPreferredSpan(1);
                                    BufferedImage buffer2 = new BufferedImage(width, height, 2);
                                    Graphics2D graphics = buffer2.createGraphics();
                                    super.paint(graphics, new Rectangle(buffer2.getWidth(), buffer2.getHeight()));
                                    UIUtil.drawImage((Graphics)g, (Image)ImageUtil.ensureHiDPI((Image)image2, (ScaleContext)ScaleContext.create((Component)null)), (int)bounds.x, (int)bounds.y, null);
                                }

                                @Override
                                public float getMaximumSpan(int axis) {
                                    return this.getPreferredSpan(axis);
                                }

                                @Override
                                public float getMinimumSpan(int axis) {
                                    return this.getPreferredSpan(axis);
                                }

                                @Override
                                public float getPreferredSpan(int axis) {
                                    return (float)(axis == 0 ? image2.getWidth(null) : image2.getHeight(null)) / JBUIScale.sysScale();
                                }
                            };
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            };
            if (extension == null) {
                SwingBrowser.$$$reportNull$$$0(0);
            }
            return extension;
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            if (t != null && !t.isEmpty()) {
                this.setCaretPosition(0);
            }
        }

        @Override
        public void load(String url) throws IOException {
            @NlsSafe String text2 = IOUtil.readString((DataInput)new DataInputStream(new URL(url).openStream()));
            this.setText(text2);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TipUIUtil$SwingBrowser", "getSVGImagesExtension"));
        }
    }

    public static interface Browser
    extends TextAccessor {
        public void load(String var1) throws IOException;

        public JComponent getComponent();

        public void setText(@Nls String var1);
    }
}

