/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.otherIde;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.collectors.fus.otherIde.JavaScriptConfigurationFields;
import com.intellij.internal.statistic.collectors.fus.otherIde.LaunchJsonUsagesCollectorKt;
import com.intellij.internal.statistic.collectors.fus.otherIde.VSCodeJavaScriptLaunchConfigurationsKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/otherIde/LaunchJsonUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "reportLaunchJsonDetected", "rootNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nLaunchJsonUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchJsonUsagesCollector.kt\ncom/intellij/internal/statistic/collectors/fus/otherIde/LaunchJsonUsagesCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1788#2,4:106\n*S KotlinDebug\n*F\n+ 1 LaunchJsonUsagesCollector.kt\ncom/intellij/internal/statistic/collectors/fus/otherIde/LaunchJsonUsagesCollector\n*L\n62#1:106,4\n*E\n"})
public final class LaunchJsonUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("other.ide.vscode", 1, null, 4, null);
    @NotNull
    private static final EventId vsCodeFolderDetectedEvent = GROUP.registerEvent("folder.detected");
    @NotNull
    private static final IntEventField numberOfConfigurationsField = EventFields.Int((String)"numberOfConfigurations");
    @NotNull
    private static final BooleanEventField hasCompoundConfigurations = EventFields.Boolean((String)"hasCompoundConfigurations");
    @NotNull
    private static final EventId2<Integer, Boolean> launchJsonDetectedEvent = GROUP.registerEvent("launch.json.detected", (EventField)numberOfConfigurationsField, (EventField)hasCompoundConfigurations);
    @NotNull
    private static final VarargEventId jsConfigurationEvent;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Set set;
        block7: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project2);
            if (virtualFile == null) {
                return SetsKt.emptySet();
            }
            VirtualFile projectDir = virtualFile;
            Set $this$getMetrics_u24lambda_u240 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            VirtualFile virtualFile2 = VirtualFileUtil.findFileOrDirectory((VirtualFile)projectDir, (String)".vscode");
            if (virtualFile2 != null) {
                VirtualFile vsCodeDir = virtualFile2;
                if (!vsCodeDir.isDirectory()) {
                    LaunchJsonUsagesCollectorKt.access$getLogger$p().warn(".vscode is not a directory");
                }
                if (vsCodeDir.isValid()) {
                    VirtualFile launchJsonFile;
                    $this$getMetrics_u24lambda_u240.add(vsCodeFolderDetectedEvent.metric());
                    VirtualFile virtualFile3 = vsCodeDir.findChild("launch.json");
                    if (virtualFile3 != null && VirtualFileUtil.isFile((VirtualFile)(launchJsonFile = virtualFile3))) {
                        JsonNode jsonNode;
                        try {
                            jsonNode = LaunchJsonUsagesCollectorKt.access$getOBJECT_MAPPER$p().readTree(launchJsonFile.getInputStream());
                        }
                        catch (Throwable e) {
                            LaunchJsonUsagesCollectorKt.access$getLogger$p().warn("Cannot parse \"launch.json\" file", e);
                            break block7;
                        }
                        JsonNode rootNode = jsonNode;
                        Intrinsics.checkNotNull((Object)rootNode);
                        $this$getMetrics_u24lambda_u240.add(this.reportLaunchJsonDetected(rootNode));
                        $this$getMetrics_u24lambda_u240.addAll((Collection)VSCodeJavaScriptLaunchConfigurationsKt.reportJSConfigurations(rootNode));
                    }
                }
            }
        }
        return SetsKt.build((Set)set);
    }

    private final MetricEvent reportLaunchJsonDetected(JsonNode rootNode) {
        int n;
        boolean hasCompounds = rootNode.has("compounds");
        JsonNode configurationsNode = rootNode.get("configurations");
        if (configurationsNode.isArray()) {
            Intrinsics.checkNotNull((Object)configurationsNode);
            Iterable $this$count$iv = (Iterable)configurationsNode;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    JsonNode it = (JsonNode)element$iv;
                    boolean bl = false;
                    if (!it.isObject() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        } else {
            LaunchJsonUsagesCollectorKt.access$getLogger$p().info("\"configurations\" field is expected to be an array of objects, but the actual type is " + configurationsNode.getNodeType());
            n = -1;
        }
        int numberOfConfigurations = n;
        return launchJsonDetectedEvent.metric((Object)numberOfConfigurations, (Object)hasCompounds);
    }

    static {
        EventField[] eventFieldArray = new EventField[]{JavaScriptConfigurationFields.INSTANCE.getConfigurationType(), JavaScriptConfigurationFields.INSTANCE.getRequest(), JavaScriptConfigurationFields.INSTANCE.getHasPreLaunchTask(), JavaScriptConfigurationFields.INSTANCE.getHasNonEmptyRuntimeArgs(), JavaScriptConfigurationFields.INSTANCE.getHasCustomEnvVars(), JavaScriptConfigurationFields.INSTANCE.getHasCustomUrl(), JavaScriptConfigurationFields.INSTANCE.getUrlIsLocalHost(), JavaScriptConfigurationFields.INSTANCE.getHasCustomPort(), JavaScriptConfigurationFields.INSTANCE.getHasCustomSkipFiles(), JavaScriptConfigurationFields.INSTANCE.getHasPathMapping(), JavaScriptConfigurationFields.INSTANCE.getHasCustomWebRoot(), JavaScriptConfigurationFields.INSTANCE.getPauseForSourceMapEnabled()};
        jsConfigurationEvent = GROUP.registerVarargEvent("js.configuration", eventFieldArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/otherIde/LaunchJsonUsagesCollector$Companion;", "", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGROUP", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "vsCodeFolderDetectedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "getVsCodeFolderDetectedEvent", "()Lcom/intellij/internal/statistic/eventLog/events/EventId;", "numberOfConfigurationsField", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getNumberOfConfigurationsField", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "hasCompoundConfigurations", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getHasCompoundConfigurations", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "launchJsonDetectedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "", "getLaunchJsonDetectedEvent", "()Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "jsConfigurationEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "getJsConfigurationEvent", "()Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EventLogGroup getGROUP() {
            return GROUP;
        }

        @NotNull
        public final EventId getVsCodeFolderDetectedEvent() {
            return vsCodeFolderDetectedEvent;
        }

        @NotNull
        public final IntEventField getNumberOfConfigurationsField() {
            return numberOfConfigurationsField;
        }

        @NotNull
        public final BooleanEventField getHasCompoundConfigurations() {
            return hasCompoundConfigurations;
        }

        @NotNull
        public final EventId2<Integer, Boolean> getLaunchJsonDetectedEvent() {
            return launchJsonDetectedEvent;
        }

        @NotNull
        public final VarargEventId getJsConfigurationEvent() {
            return jsConfigurationEvent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

