/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationRouter;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0012\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/notification/impl/NotificationsListener;", "Lcom/intellij/notification/Notifications;", "<init>", "()V", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "notify", "", "notification", "Lcom/intellij/notification/Notification;", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNotificationsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsListener.kt\ncom/intellij/notification/impl/NotificationsListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,46:1\n13#2:47\n*S KotlinDebug\n*F\n+ 1 NotificationsListener.kt\ncom/intellij/notification/impl/NotificationsListener\n*L\n43#1:47\n*E\n"})
public final class NotificationsListener
implements Notifications {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public NotificationsListener() {
        this.project = null;
    }

    private NotificationsListener(Project project2) {
        this.project = project2;
        if (NotificationsManagerImpl.isDummyEnvironment()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    public void notify(@NotNull Notification notification2) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        for (NotificationRouter listener2 : NotificationRouter.Companion.getEP_NAME().getExtensionList()) {
            try {
                if (!listener2.routeNotification(notification2, this.project)) continue;
                return;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NotificationsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/notification/impl/NotificationsListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

