/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import org.jetbrains.annotations.Nullable;

public final class FinishMarkAction
extends BasicUndoableAction {
    @Nullable
    private final StartMarkAction myStartAction;
    private boolean myGlobal = false;
    private @NlsContexts.Command String myCommandName;
    private final DocumentReference myReference;

    FinishMarkAction(DocumentReference reference, boolean isGlobal) {
        this(reference, null);
        this.setGlobal(isGlobal);
    }

    private FinishMarkAction(DocumentReference reference, @Nullable StartMarkAction action2) {
        super(new DocumentReference[]{reference});
        this.myReference = reference;
        this.myStartAction = action2;
    }

    public void undo() {
    }

    public void redo() {
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        if (this.myStartAction != null) {
            this.myStartAction.setGlobal(isGlobal);
        }
        this.myGlobal = isGlobal;
    }

    public void setCommandName(@NlsContexts.Command String commandName) {
        if (this.myStartAction != null) {
            this.myStartAction.setCommandName(commandName);
        }
        this.myCommandName = commandName;
    }

    @NlsContexts.Command
    public String getCommandName() {
        return this.myCommandName;
    }

    public DocumentReference getAffectedDocument() {
        return this.myReference;
    }

    public static void finish(Project project2, Editor editor2, @Nullable StartMarkAction startAction) {
        if (startAction == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            DocumentReference reference = DocumentReferenceManager.getInstance().create(editor2.getDocument());
            UndoManager.getInstance((Project)project2).undoableActionPerformed((UndoableAction)new FinishMarkAction(reference, startAction));
            StartMarkAction.markFinished(editor2);
        }, IdeBundle.message((String)"command.finish", (Object[])new Object[0]), null);
    }
}

