/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class StacksHolderBase<E, ECollection extends Collection<E>> {
    protected static final Logger LOG = Logger.getInstance(StacksHolderBase.class);
    private final Key<ECollection> STACK_IN_DOCUMENT_KEY = Key.create((String)"STACK_IN_DOCUMENT_KEY");
    final Map<DocumentReference, ECollection> myDocumentStacks = CollectionFactory.createSmallMemoryFootprintMap();
    final Collection<Document> myDocumentsWithStacks = new WeakList();
    final Collection<VirtualFile> myNonlocalVirtualFilesWithStacks = new WeakList();

    @NotNull
    ECollection getStack(@NotNull DocumentReference r) {
        if (r == null) {
            StacksHolderBase.$$$reportNull$$$0(0);
        }
        return r.getFile() != null ? this.doGetStackForFile(r) : this.doGetStackForDocument(r);
    }

    @NotNull
    private ECollection doGetStackForFile(@NotNull DocumentReference r) {
        VirtualFile file2;
        if (r == null) {
            StacksHolderBase.$$$reportNull$$$0(1);
        }
        Object result2 = (file2 = r.getFile()).isInLocalFileSystem() ? this.myDocumentStacks.computeIfAbsent(r, __ -> this.newCollection()) : this.addWeaklyTrackedEmptyStack(file2, this.myNonlocalVirtualFilesWithStacks);
        ECollection ECollection = result2;
        if (ECollection == null) {
            StacksHolderBase.$$$reportNull$$$0(2);
        }
        return ECollection;
    }

    protected abstract ECollection newCollection();

    @NotNull
    private ECollection doGetStackForDocument(@NotNull DocumentReference r) {
        if (r == null) {
            StacksHolderBase.$$$reportNull$$$0(3);
        }
        return this.addWeaklyTrackedEmptyStack(r.getDocument(), this.myDocumentsWithStacks);
    }

    @NotNull
    private <T extends UserDataHolder> ECollection addWeaklyTrackedEmptyStack(@NotNull T holder, @NotNull Collection<? super T> allHolders) {
        Collection<Object> result2;
        if (holder == null) {
            StacksHolderBase.$$$reportNull$$$0(4);
        }
        if (allHolders == null) {
            StacksHolderBase.$$$reportNull$$$0(5);
        }
        if ((result2 = (Collection)holder.getUserData(this.STACK_IN_DOCUMENT_KEY)) == null) {
            result2 = this.newCollection();
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, result2);
            allHolders.add(holder);
        }
        Collection collection = result2;
        if (collection == null) {
            StacksHolderBase.$$$reportNull$$$0(6);
        }
        return (ECollection)collection;
    }

    void removeEmptyStacks() {
        this.myDocumentStacks.entrySet().removeIf(each -> ((Collection)each.getValue()).isEmpty());
        CollectionFactory.trimMap(this.myDocumentStacks);
        this.cleanWeaklyTrackedEmptyStacks(this.myDocumentsWithStacks);
        this.cleanWeaklyTrackedEmptyStacks(this.myNonlocalVirtualFilesWithStacks);
    }

    void clearDocumentReferences(@NotNull Document document2) {
        if (document2 == null) {
            StacksHolderBase.$$$reportNull$$$0(7);
        }
        this.myDocumentsWithStacks.remove(document2);
        DocumentReference referenceFile = DocumentReferenceManager.getInstance().create(document2);
        DocumentReferenceByDocument referenceDoc = new DocumentReferenceByDocument(document2);
        this.myDocumentStacks.remove(referenceFile);
        this.myDocumentStacks.remove(referenceDoc);
    }

    private <T extends UserDataHolder> void cleanWeaklyTrackedEmptyStacks(@NotNull Collection<T> stackHolders) {
        if (stackHolders == null) {
            StacksHolderBase.$$$reportNull$$$0(8);
        }
        HashSet<UserDataHolder> holdersToDrop = new HashSet<UserDataHolder>();
        for (UserDataHolder holder : stackHolders) {
            Collection stack = (Collection)holder.getUserData(this.STACK_IN_DOCUMENT_KEY);
            if (stack == null || !stack.isEmpty()) continue;
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, null);
            holdersToDrop.add(holder);
        }
        stackHolders.removeAll(holdersToDrop);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/StacksHolderBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allHolders";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackHolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/StacksHolderBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetStackForFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addWeaklyTrackedEmptyStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStack";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doGetStackForFile";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doGetStackForDocument";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addWeaklyTrackedEmptyStack";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearDocumentReferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cleanWeaklyTrackedEmptyStacks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

