/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.UIBundle;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class MultiplePasteAction
extends AnAction
implements DumbAware {
    private static final char P = 'P';

    public MultiplePasteAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MultiplePasteAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext2 = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        Component focusedComponent = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (!(focusedComponent instanceof JComponent)) {
            return;
        }
        ClipboardContentChooser chooser = new ClipboardContentChooser(project2);
        if (!chooser.getAllContents().isEmpty()) {
            chooser.show();
        } else {
            chooser.close(1);
        }
        if (chooser.getExitCode() == 0 || chooser.getExitCode() == MultiplePasteAction.getPasteSimpleExitCode()) {
            List selectedContents = chooser.getSelectedContents();
            CopyPasteManagerEx copyPasteManager = CopyPasteManagerEx.getInstanceEx();
            if (selectedContents.size() == 1) {
                copyPasteManager.moveContentToStackTop((Transferable)selectedContents.get(0));
            } else {
                copyPasteManager.setContents(new StringSelection(chooser.getSelectedText()));
            }
            if (editor2 != null) {
                if (editor2.isViewer()) {
                    return;
                }
                AnAction pasteAction = ActionManager.getInstance().getAction(chooser.getExitCode() == MultiplePasteAction.getPasteSimpleExitCode() ? "EditorPasteSimple" : "$Paste");
                AnActionEvent newEvent = new AnActionEvent(e.getInputEvent(), DataManager.getInstance().getDataContext(focusedComponent), e.getPlace(), e.getPresentation(), ActionManager.getInstance(), e.getModifiers());
                pasteAction.actionPerformed(newEvent);
            } else {
                Action pasteAction = ((JComponent)focusedComponent).getActionMap().get("paste-from-clipboard");
                if (pasteAction != null) {
                    pasteAction.actionPerformed(new ActionEvent(focusedComponent, 1001, ""));
                }
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            MultiplePasteAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MultiplePasteAction.$$$reportNull$$$0(2);
        }
        boolean enabled2 = MultiplePasteAction.isEnabled(e);
        e.getPresentation().setEnabled(enabled2);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(enabled2);
        }
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        Object component2;
        if (e == null) {
            MultiplePasteAction.$$$reportNull$$$0(3);
        }
        if (!((component2 = e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)) instanceof JComponent)) {
            return false;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 != null) {
            return !editor2.isViewer();
        }
        Action pasteAction = ((JComponent)component2).getActionMap().get("paste-from-clipboard");
        return pasteAction != null;
    }

    private static int getPasteSimpleExitCode() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/MultiplePasteAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/MultiplePasteAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class ClipboardContentChooser
    extends ContentChooser<Transferable> {
        ClipboardContentChooser(Project project2) {
            super(project2, UIBundle.message((String)"choose.content.to.paste.dialog.title", (Object[])new Object[0]), true, true);
            this.setOKButtonText(ActionsBundle.actionText((String)"EditorPaste"));
            this.setOKButtonMnemonic(80);
            this.setKeepPopupsOpen(true);
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getHelpAction(), this.getOKAction(), new PasteSimpleAction(), this.getCancelAction()};
            if (actionArray == null) {
                ClipboardContentChooser.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        @NotNull
        protected String getHelpId() {
            return "ixPasteSelected";
        }

        @Override
        protected String getStringRepresentationFor(Transferable content2) {
            try {
                return (String)content2.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e1) {
                return "";
            }
        }

        @Override
        @NotNull
        protected List<Transferable> getContents() {
            List<Transferable> list2 = Arrays.asList(CopyPasteManager.getInstance().getAllContents());
            if (list2 == null) {
                ClipboardContentChooser.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        protected void removeContentAt(Transferable content2) {
            CopyPasteManagerEx.getInstanceEx().removeContent(content2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/editor/actions/MultiplePasteAction$ClipboardContentChooser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContents";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        final class PasteSimpleAction
        extends DialogWrapper.DialogWrapperAction {
            private PasteSimpleAction() {
                super((DialogWrapper)ClipboardContentChooser.this, ActionsBundle.actionText((String)"EditorPasteSimple"));
            }

            protected void doAction(ActionEvent e) {
                ClipboardContentChooser.this.close(MultiplePasteAction.getPasteSimpleExitCode());
            }
        }
    }
}

