/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.textarea.TextComponentEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.EDT;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextComponentEditorAction
extends EditorAction {
    private final boolean allowSpeedSearch;

    protected TextComponentEditorAction(@NotNull EditorActionHandler defaultHandler) {
        if (defaultHandler == null) {
            TextComponentEditorAction.$$$reportNull$$$0(0);
        }
        this(defaultHandler, true);
    }

    protected TextComponentEditorAction(@NotNull EditorActionHandler defaultHandler, boolean allowSpeedSearch) {
        if (defaultHandler == null) {
            TextComponentEditorAction.$$$reportNull$$$0(1);
        }
        super(defaultHandler);
        this.allowSpeedSearch = allowSpeedSearch;
        this.ensureHandlerChainIsLoaded();
    }

    public synchronized void setInjectedContext(boolean worksInInjected) {
        throw new UnsupportedOperationException("TextComponentEditorAction is updated on EDT only and must not work in injected context");
    }

    private void ensureHandlerChainIsLoaded() {
        this.getHandler().runForAllCarets();
    }

    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            TextComponentEditorAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            TextComponentEditorAction.$$$reportNull$$$0(3);
        }
        return TextComponentEditorAction.getEditorFromContext(dataContext2, this.allowSpeedSearch);
    }

    @Nullable
    public static Editor getEditorFromContext(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            TextComponentEditorAction.$$$reportNull$$$0(4);
        }
        return TextComponentEditorAction.getEditorFromContext(dataContext2, true);
    }

    @Nullable
    private static Editor getEditorFromContext(@NotNull DataContext dataContext2, boolean allowSpeedSearch) {
        Object component2;
        boolean isEDT;
        Editor editor2;
        if (dataContext2 == null) {
            TextComponentEditorAction.$$$reportNull$$$0(5);
        }
        Editor editor3 = editor2 = (isEDT = EDT.isCurrentThreadEdt()) && !SlowOperations.isInSection((String)"action.perform") ? (Editor)CommonDataKeys.HOST_EDITOR.getData(dataContext2) : null;
        if (editor2 == null) {
            editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        }
        if (editor2 != null) {
            return editor2;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        Object data2 = PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext2);
        if (data2 instanceof EditorComponentImpl) {
            return null;
        }
        if (data2 instanceof JTextComponent) {
            return new TextComponentEditorImpl(project2, (JTextComponent)data2);
        }
        if (allowSpeedSearch && (component2 = PlatformDataKeys.SPEED_SEARCH_COMPONENT.getData(dataContext2)) instanceof JTextField) {
            return new TextComponentEditorImpl(project2, (JTextField)component2);
        }
        return null;
    }

    static {
        TextComponentEditorImpl.ensureRequiredClassesAreLoaded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/TextComponentEditorAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/TextComponentEditorAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

