/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.CharacterSequences;
import com.intellij.openapi.editor.impl.view.CharacterGridIterator;
import com.intellij.openapi.editor.impl.view.DoubleWidthCharacterStrategy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B,\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\bH\u0002J\b\u0010\"\u001a\u00020\u001fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u001e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/editor/impl/view/CharacterGridIteratorImpl;", "Lcom/intellij/openapi/editor/impl/view/CharacterGridIterator;", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "doubleWidthCharacterStrategy", "Lcom/intellij/openapi/editor/impl/view/DoubleWidthCharacterStrategy;", "startOffset", "", "endOffset", "<init>", "(Ljava/lang/CharSequence;Lcom/intellij/openapi/editor/impl/view/DoubleWidthCharacterStrategy;II)V", "substring", "", "textLength", "codePoint", "value", "", "isAtEnd", "()Z", "isLineBreak", "cellStartOffset", "getCellStartOffset", "()I", "cellEndOffset", "getCellEndOffset", "cellStartColumn", "getCellStartColumn", "cellEndColumn", "getCellEndColumn", "advance", "", "setOffset", "newOffset", "advanceColumn", "intellij.platform.ide.impl"})
final class CharacterGridIteratorImpl
implements CharacterGridIterator {
    @NotNull
    private final DoubleWidthCharacterStrategy doubleWidthCharacterStrategy;
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private final String substring;
    private final int textLength;
    private int codePoint;
    private boolean isAtEnd;
    private boolean isLineBreak;
    private int cellStartOffset;
    private int cellEndOffset;
    private int cellStartColumn;
    private int cellEndColumn;

    public CharacterGridIteratorImpl(@NotNull CharSequence text2, @NotNull DoubleWidthCharacterStrategy doubleWidthCharacterStrategy, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)doubleWidthCharacterStrategy, (String)"doubleWidthCharacterStrategy");
        this.doubleWidthCharacterStrategy = doubleWidthCharacterStrategy;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.substring = ((Object)text2.subSequence(this.startOffset, this.endOffset)).toString();
        this.textLength = text2.length();
        this.cellStartOffset = this.startOffset;
        this.setOffset(this.startOffset);
        this.advanceColumn();
    }

    @Override
    public boolean isAtEnd() {
        return this.isAtEnd;
    }

    @Override
    public boolean isLineBreak() {
        return this.isLineBreak;
    }

    @Override
    public int getCellStartOffset() {
        return this.cellStartOffset;
    }

    @Override
    public int getCellEndOffset() {
        return this.cellEndOffset;
    }

    @Override
    public int getCellStartColumn() {
        return this.cellStartColumn;
    }

    @Override
    public int getCellEndColumn() {
        return this.cellEndColumn;
    }

    @Override
    public void advance() {
        this.setOffset(this.getCellEndOffset());
        this.advanceColumn();
    }

    private final void setOffset(int newOffset) {
        if (newOffset >= this.endOffset) {
            this.codePoint = 0;
            this.isAtEnd = true;
            this.isLineBreak = true;
            this.cellStartOffset = this.endOffset;
            this.cellEndOffset = this.endOffset;
        } else {
            int n;
            this.codePoint = n = CharacterSequences.codePointAt((CharSequence)this.substring, (int)(newOffset - this.startOffset));
            this.isAtEnd = false;
            this.isLineBreak = n == 10 || n == 13;
            boolean bmp = Character.isBmpCodePoint(n);
            this.cellStartOffset = newOffset;
            this.cellEndOffset = bmp ? (n == 13 && newOffset + 1 < this.textLength && this.substring.charAt(newOffset - this.startOffset + 1) == '\n' ? newOffset + 2 : newOffset + 1) : newOffset + 2;
        }
    }

    private final void advanceColumn() {
        this.cellStartColumn = this.getCellEndColumn();
        this.cellEndColumn = this.isLineBreak() ? 0 : this.getCellEndColumn() + (this.doubleWidthCharacterStrategy.isDoubleWidth(this.codePoint) ? 2 : 1);
    }
}

