/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public final class Group
implements KeymapGroup {
    private Group myParent;
    private final @NlsActions.ActionText String myName;
    private final String myId;
    @Nullable
    private final @Nullable Supplier<? extends @Nullable Icon> icon;
    private final ArrayList<Object> myChildren;
    private final Set<String> myIds = new HashSet<String>();
    private boolean myForceShowAsPopup;

    public Group(@NlsActions.ActionText String name2, String id2, Icon icon2) {
        this.myName = name2;
        this.myId = id2;
        this.icon = icon2 == null ? null : () -> icon2;
        this.myChildren = new ArrayList();
    }

    public Group(@NlsActions.ActionText String name2, String id2) {
        this.myName = name2;
        this.myId = id2;
        this.icon = null;
        this.myChildren = new ArrayList();
    }

    public Group(@NlsActions.ActionText String name2, String id2, @Nullable @Nullable Supplier<? extends @Nullable Icon> icon2) {
        this.myName = name2;
        this.myId = id2;
        this.icon = icon2;
        this.myChildren = new ArrayList();
    }

    public Group(@NlsActions.ActionText String name2) {
        this(name2, null, (Icon)null);
    }

    @NlsActions.ActionText
    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        return this.icon == null ? null : this.icon.get();
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    public boolean isForceShowAsPopup() {
        return this.myForceShowAsPopup;
    }

    public void setForceShowAsPopup(boolean forceShowAsPopup) {
        this.myForceShowAsPopup = forceShowAsPopup;
    }

    public void addActionId(String id2) {
        if (this.myChildren.contains(id2)) {
            return;
        }
        this.myChildren.add(id2);
    }

    public void addQuickList(QuickList list2) {
        this.myChildren.add((Object)list2);
    }

    public void addHyperlink(Hyperlink link) {
        this.myChildren.add(link);
    }

    public void addGroup(KeymapGroup keymapGroup) {
        Group group2 = (Group)keymapGroup;
        if (this.myChildren.contains(group2)) {
            return;
        }
        this.myChildren.add(group2);
        group2.myParent = this;
    }

    public void addSeparator() {
        this.myChildren.add(Separator.getInstance());
    }

    public boolean containsId(String id2) {
        return this.myIds.contains(id2);
    }

    public Set<String> initIds() {
        for (Object child : this.myChildren) {
            if (child instanceof String) {
                this.myIds.add((String)child);
                continue;
            }
            if (child instanceof QuickList) {
                this.myIds.add(((QuickList)((Object)child)).getActionId());
                continue;
            }
            if (!(child instanceof Group)) continue;
            Group childGroup = (Group)child;
            this.myIds.addAll(childGroup.initIds());
            if (childGroup.myId == null) continue;
            this.myIds.add(childGroup.myId);
        }
        return this.myIds;
    }

    public ArrayList<Object> getChildren() {
        return this.myChildren;
    }

    public int getSize() {
        return this.myChildren.size();
    }

    public void normalizeSeparators() {
        Separator s;
        Object object;
        while (!this.myChildren.isEmpty() && (object = this.myChildren.get(0)) instanceof Separator && (s = (Separator)object).getText() != null) {
            this.myChildren.remove(0);
        }
        while (!this.myChildren.isEmpty() && this.myChildren.get(this.myChildren.size() - 1) instanceof Separator) {
            this.myChildren.remove(this.myChildren.size() - 1);
        }
        for (int i2 = 1; i2 < this.myChildren.size() - 1; ++i2) {
            if (!(this.myChildren.get(i2) instanceof Separator) || !(this.myChildren.get(i2 + 1) instanceof Separator)) continue;
            this.myChildren.remove(i2);
            --i2;
        }
    }

    public String getActionQualifiedPath(String id2, boolean presentable) {
        Group cur = this.myParent;
        StringBuilder answer2 = new StringBuilder();
        while (cur != null && !cur.isRoot()) {
            answer2.insert(0, cur.getName(presentable) + " | ");
            cur = cur.myParent;
        }
        String suffix = this.calcActionQualifiedPath(id2, presentable);
        if (StringUtil.isEmpty((String)suffix)) {
            return null;
        }
        answer2.append(suffix);
        return answer2.toString();
    }

    private String calcActionQualifiedPath(String id2, boolean presentable) {
        if (!this.isRoot() && StringUtil.equals((CharSequence)id2, (CharSequence)this.myId)) {
            return this.getName(presentable);
        }
        for (Object child : this.myChildren) {
            String path;
            if (child instanceof QuickList) {
                child = ((QuickList)((Object)child)).getActionId();
            }
            if (child instanceof String) {
                String path2;
                if (!id2.equals(child)) continue;
                AnAction action2 = presentable ? ActionManager.getInstance().getActionOrStub(id2) : null;
                String string = path2 = action2 != null ? action2.getTemplatePresentation().getText() : null;
                if (StringUtil.isEmpty((String)path2)) {
                    path2 = id2;
                }
                return !this.isRoot() ? this.getName(presentable) + " | " + path2 : path2;
            }
            if (!(child instanceof Group) || (path = ((Group)child).calcActionQualifiedPath(id2, presentable)) == null) continue;
            return !this.isRoot() ? this.getName(presentable) + " | " + path : path;
        }
        return null;
    }

    @Nullable
    private String getName(boolean presentable) {
        return presentable ? this.getName() : this.getId();
    }

    public boolean isRoot() {
        return this.myParent == null;
    }

    public String getQualifiedPath(boolean presentable) {
        StringBuilder path = new StringBuilder(64);
        Group group2 = this;
        while (group2 != null && !group2.isRoot()) {
            if (!path.isEmpty()) {
                path.insert(0, " | ");
            }
            path.insert(0, group2.getName(presentable));
            group2 = group2.myParent;
        }
        return path.toString();
    }

    public void addAll(Group group2) {
        for (Object o : group2.getChildren()) {
            if (o instanceof String) {
                this.addActionId((String)o);
                continue;
            }
            if (o instanceof QuickList) {
                this.addQuickList((QuickList)((Object)o));
                continue;
            }
            if (o instanceof Group) {
                this.addGroup((Group)o);
                continue;
            }
            if (!(o instanceof Separator)) continue;
            this.addSeparator();
        }
        if (group2.myId != null) {
            this.myIds.add(group2.myId);
        }
    }

    public ActionGroup constructActionGroup(boolean popup2) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group2 = new DefaultActionGroup(this.getName(), popup2);
        AnAction groupToRestorePresentation = null;
        if (this.getName() != null) {
            groupToRestorePresentation = actionManager.getAction(this.getName());
        } else if (this.getId() != null) {
            groupToRestorePresentation = actionManager.getAction(this.getId());
        }
        if (groupToRestorePresentation != null) {
            group2.copyFrom(groupToRestorePresentation);
        }
        for (Object o : this.myChildren) {
            if (o instanceof String) {
                group2.add(actionManager.getAction((String)o));
                continue;
            }
            if (o instanceof Separator) {
                group2.addSeparator();
                continue;
            }
            if (!(o instanceof Group)) continue;
            group2.add((AnAction)((Group)o).constructActionGroup(popup2));
        }
        return group2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Group)) {
            return false;
        }
        Group group2 = (Group)object;
        if (group2.getName() != null && this.getName() != null) {
            return group2.getName().equals(this.getName());
        }
        if (this.getChildren() != null && group2.getChildren() != null) {
            if (this.getChildren().size() != group2.getChildren().size()) {
                return false;
            }
            for (int i2 = 0; i2 < this.getChildren().size(); ++i2) {
                if (this.getChildren().get(i2).equals(group2.getChildren().get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public String toString() {
        return this.getName();
    }
}

